package com.ibm.ulc.examples.carRental.views;

import com.ibm.ulc.examples.carRental.model.FinalPersistentObject;
import com.ibm.ulc.examples.carRental.model.Location;
import com.ibm.ulc.examples.carRental.model.Country;
import com.ibm.ulc.examples.carRental.model.DataAccessor;

/**
 * Adapters used to show states in a tree widget.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
public class StateNode extends WrapperNode {
	/**
	 * The node's model is the country; this additional field identifies the state.
	 * @serial
	 */
	 protected String fState= "";
/**
 * StateNode constructor comment.
 */
public StateNode() {
	super();
}
/**
 * StateNode constructor comment.
 * @param model com.ibm.ulc.examples.carRental.model.FinalPersistentObject
 */
public StateNode(FinalPersistentObject model) {
	super(model);
}
/**
 * StateNode constructor comment.
 * @param model com.ibm.ulc.examples.carRental.model.FinalPersistentObject
 */
public StateNode(FinalPersistentObject model, AbstractLocationNode parent) {
	super(model);
	fParent= parent;
}
/**
 * Insert the method's description here.
 * 
 * Creation date: (30.12.99 12:24:41)
 * @param model com.ibm.ulc.examples.carRental.model.FinalPersistentObject
 * @param state java.lang.String
 * @param parent com.ibm.ulc.examples.carRental.views.AbstractLocationNode
 */
public StateNode(FinalPersistentObject model, String state, AbstractLocationNode parent) {
	super(model,parent);
	fState= state;
	}
/**
 * Answer a location node for each location in the state of the receiver.
 */
protected WrapperNode[] computeChildren() {
	DataAccessor dAcc= dataAccessor();
	Location[] locs= dAcc.getLocationsInCountryAndState(getCountry(),fState);

	LocationNode[] lNodes= new LocationNode[locs.length];
	for (int i=0; i<lNodes.length; i++) {
		lNodes[i]= new LocationNode(locs[i],this);
	}
	return lNodes;
}
/**
 * Insert the method's description here.
 * 
 * Creation date: (30.12.99 12:05:07)
 * @return com.ibm.ulc.examples.carRental.model.Country
 */
protected Country getCountry() {
	return (Country) fModel;
}
/**
 * Perform the getId method.
 * @return java.lang.String
 */
public String getId() {
	/* Perform the getId method. */
	return fState;
}
/**
 * Insert the method's description here.
 * Creation date: (06.01.00 13:17:12)
 * @return java.lang.String
 */
public String getLabel() {
	return fState;
}
}
