package com.ibm.ulc.test;

import java.util.Date;
import java.util.Vector;
import com.ibm.ulc.util.*;
import com.ibm.ulc.application.ULCTableModel;
public abstract class UlxModel implements IUlxModel {
	static int INVALID_ROWID = -1;
	protected transient java.beans.PropertyChangeSupport propertyChange;
	protected IUlxModelOwner[] fieldOwners = new IUlxModelOwner[0];
	protected int[] fIdentifiers = new int[0];
	protected Date fieldCreated = new Date();
	protected Date fieldLastModified = null;
	protected UlcHashtable fMethodCache = new UlcHashtable();
/**
 * UlxModel constructor comment.
 */
public UlxModel() {
	super();
}
/**
 * The addPropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().addPropertyChangeListener(listener);
}
/**
 * The firePropertyChange method was generated to support the propertyChange field.
 */
public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	setLastModified(new Date());
	if (propertyChange != null)
		getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
	if (fieldOwners.length > 0)
		for (int i = 0; i < fieldOwners.length; i++)
			fieldOwners[i].modelChanged(this, propertyName);
}
/**
 * getValueAt method comment.
 */
java.lang.reflect.Method getAccessMethod(String prefix, String attributeName) {
	String selector = prefix + (attributeName.substring(0, 1)).toUpperCase() + attributeName.substring(1);
	Object o = fMethodCache.get(selector);
	if (o != null)
		return (java.lang.reflect.Method) o;
	java.lang.reflect.Method method = null;
	try {
		java.lang.reflect.Method[] methods = getClass().getMethods();
		for (int i = 0; i < methods.length; i++) {
			if (methods[i].getName().equals(selector)) {
				method = methods[i];
				break;
			}
		}
	} catch (Throwable t) {
		t.toString();
	}
	fMethodCache.put(selector, method);
	return method;
}
/**
 * Accessor for the propertyChange field.
 */
protected static String[] getAttributes() {
	return new String[] {};
}
/**
 * Gets the created property (java.util.Date) value.
 * @return The created property value.
 */
public java.util.Date getCreated() {
	return fieldCreated;
}
public int getIdentifier(IUlxModelOwner modelOwner) {
	int index = UlxCollection.indexOf(fieldOwners, modelOwner);
	if (index < 0)
		return INVALID_ROWID;
	else
		return fIdentifiers[index];
}
/**
 * Gets the lastModified property (java.util.Date) value.
 * @return The lastModified property value.
 */
public java.util.Date getLastModified() {
	return fieldLastModified;
}
/**
 * Gets the listString property (java.lang.String) value.
 * @return The listString property value.
 */
abstract public String getListString();
/**
 * Accessor for the propertyChange field.
 */
protected java.beans.PropertyChangeSupport getPropertyChange() {
	if (propertyChange == null) {
		propertyChange = new java.beans.PropertyChangeSupport(this);
	};
	return propertyChange;
}
/**
 * getValueAt method comment.
 */
public Object getValueAt(String attributeName) {
	Object answer = null;
	try {
		java.lang.reflect.Method method = getAccessMethod("get", attributeName);
		answer = method.invoke(this, new Object[0]);
	}
	catch (Throwable t) {
	}
	return answer;
}
void handleException(Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	System.out.println(exception.toString());
	exception.printStackTrace(System.out);
}
public boolean isMapped(IUlxModelOwner modelOwner) {
	if (getIdentifier(modelOwner) != INVALID_ROWID)
		return true;
	else
		return false;
}
/**
 * Gets the listString property (java.lang.String) value.
 * @return The listString property value.
 */
public void listStringChanged() {
	firePropertyChange("listString", "", getListString());
}
/**
 * The removePropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().removePropertyChangeListener(listener);
}
public void resetOwner(IUlxModelOwner mo) {
	if (UlxCollection.contains(fieldOwners, mo)) {
		int index = UlxCollection.indexOf(fieldOwners, mo);
		IUlxModelOwner[] newOwners = new IUlxModelOwner[fieldOwners.length - 1];
		fieldOwners = (IUlxModelOwner[]) UlxCollection.remove(newOwners, fieldOwners, mo);
		int[] newIds = new int[fIdentifiers.length - 1];
		fIdentifiers[index] = -1;
		int count = 0;
		for (int i = 0; i < fIdentifiers.length; i++) {
			if (fIdentifiers[i] >= 0)
				newIds[count++] = fIdentifiers[i];
		}
		fIdentifiers = newIds;
	}
}
public void setIdentifier(IUlxModelOwner mo, int identifier) {
	if (UlxCollection.indexOf(fieldOwners, mo) < 0) {
		int index = fieldOwners.length;
		IUlxModelOwner[] newOwners = new IUlxModelOwner[index + 1];
		UlxCollection.add(newOwners, fieldOwners, mo);
		Vector newIds = UlxCollection.copyToVector(fIdentifiers);
		newIds.addElement(new Integer(identifier));
		fIdentifiers = new int[index + 1];
		for (int i = 0; i < fIdentifiers.length; i++)
			fIdentifiers[i] = ((Integer) newIds.elementAt(i)).intValue();
	}
}
/**
 * Sets the created property (java.util.Date) value.
 * @param created The new value for the property.
 * @see #getCreated
 */
private void setLastModified(java.util.Date lastModified) {
	if (fieldLastModified == null || !fieldLastModified.equals(lastModified)) {
		java.util.Date oldValue = fieldLastModified;
		fieldLastModified = lastModified;
		if (propertyChange != null)
			getPropertyChange().firePropertyChange("lastModified", oldValue, lastModified);
		if (fieldOwners.length > 0) {
			for (int i = 0; i < fieldOwners.length; i++)
				fieldOwners[i].modelChanged(this, "lastModified");
		}
	}
}
/**
 * getValueAt method comment.
 */
public void setValueAt(Object value, String attributeName) {
	java.lang.reflect.Method method = null;
	try {
		method = getAccessMethod("set", attributeName);
		if (method != null) {
			method.invoke(this, new Object[] {value});
		}
	} catch (Throwable t) {
		t.toString();
	}
}
}
