package com.ibm.ulc.test;

import java.util.Date;
import java.util.Vector;
import java.util.Random;
import com.ibm.ulc.application.ULCStringTable;
import com.ibm.ulc.application.ULCIcon;
import com.ibm.ulc.testsample.*;
public class UlxTestData {
	static Random fRandom = new Random();
	UlxTableModel fPersonTableModel = null;
	UlxTableModel fAddressTableModel = null;
	UlxTableModel fContainerTableModel = null;
	UlxTreeModel fContainerTreeModel = null;
	ULCStringTable fComboboxTableModel = null;
	ULCIcon[] fIcons = null;
	UlxData fDataSource= new UlxData();
	static int DATA_NONE = 0;
	static int DATA_SMALL = 1;
	static int DATA_NORMAL = 2;
	static int DATA_LARGE = 3;
	static int DATA_HUGE = 4;
	static int DATA_GIGANTIC = 5;
	static int[] SCOPE_TRANSLATION = new int[] {0, 10, 100, 500, 5000, 200000,};
	static String[] SCOPE_NAMES = new String[] {"None", "Small", "Standard", "Large", "Huge", "Gigantic"};
	int fScope = DATA_NORMAL;
/**
 * 
 * @param scope int
 */
public UlxTestData() {
	fIcons = new ULCIcon[3];
	fIcons[0] = new ULCIcon(getClass().getResource("/green-ball.gif"), true);
	fIcons[1] = new ULCIcon(getClass().getResource("/red-ball.gif"), true);
	fIcons[2] = new ULCIcon(getClass().getResource("/yellow-ball.gif"), true);
}
/**
 * 
 * @param scope int
 */
public UlxTestData(int scope) {
	this();
	fScope = scope;
}
public UlxTableModel getAddressTableModel() {
	if (fAddressTableModel == null) {
		int size = translateScopeToNumber();
		Vector addresses = new Vector(size);
		for (int i = 0; i < size; i++) {
			UlxAddress model = new UlxAddress();
			randomInitialize(i, model);
			addresses.addElement(model);
		}
		fAddressTableModel = new UlxTableModel();
		fAddressTableModel.setRows(addresses);
	}
	return fAddressTableModel;
}
public ULCStringTable getComboboxTableModel() {
	if (fComboboxTableModel == null) {
		String[] strings = new String[20];
		for (int i = 0; i < strings.length; i++) {
			strings[i] = randomString();
		}
		fComboboxTableModel = new ULCStringTable(strings);
	}
	return fComboboxTableModel;
}
public UlxTableModel getContainerTableModel() {
	if (fContainerTableModel == null) {
		fContainerTableModel = new UlxTableModel(getContainerTreeModel().getRows());
	}
	return fContainerTableModel;
}
public UlxTreeModel getContainerTreeModel() {
	if (fContainerTreeModel == null) {
		int breadth = -1;
		int depth = 3;
		if (getScope() == DATA_NONE)
			breadth = 0;
		if (getScope() == DATA_SMALL)
			breadth = 2;
		if (getScope() == DATA_NORMAL) {
			breadth = 4;
		}
		if (getScope() == DATA_LARGE) {
			breadth = 8;
		}
		if (getScope() == DATA_HUGE) {
			breadth = 8;
			depth = 4;
		}
		if (getScope() == DATA_GIGANTIC) {
			breadth = 10;
			depth = 5;
		}
		UlxContainer model = new UlxContainer();
		randomInitialize(breadth, depth, model);
		fContainerTreeModel = new UlxTreeModel(new UlxContainerTreeNodeAdapter());
		fContainerTreeModel.setRoot(model);
	}
	return fContainerTreeModel;
}
public UlxData getDataSource() {
	return fDataSource;
}
public String[] getPersonAttributes() {
	return UlxPerson.getAttributes();
}
public Vector getPersons(int number) {
	Vector persons = new Vector(number);
	for (int i = 0; i < number; i++) {
		UlxPerson model = new UlxPerson();
		randomInitialize(i, model);
		persons.addElement(model);
	}
	return persons;
}
public UlxTableModel getPersonTableModel() {
	if (fPersonTableModel == null) {
		int size = translateScopeToNumber();
		Vector persons = getPersons(size);
		fPersonTableModel = new UlxTableModel();
		fPersonTableModel.setRows(persons);
	}
	return fPersonTableModel;
}
public int getScope() {
	return fScope;
}
Date randomBirthDate() {
	return randomDate(1900, 78);
}
Date randomDate() {
	return randomDate(1900, 150);
}
Date randomDate(int minYear, int maxYear) {
	java.util.Calendar c = new java.util.GregorianCalendar();
	c.set(minYear + randomInt(maxYear), Math.max(1, randomInt(12)), Math.max(1, (randomInt(28))));
	return c.getTime();
}
synchronized float randomFloat(int multiplier) {
	return fRandom.nextFloat() * multiplier;
}
void randomInitialize(int numberOfChildren, int levelsToGo, UlxContainer entity) {
	entity.setName(randomString());
	if (levelsToGo > 0) {
		int newLevel = levelsToGo - 1;
		int randomChildren = randomInt(numberOfChildren * 2, Math.round(numberOfChildren / 2));
		UlxContainer[] children = new UlxContainer[randomChildren];
		for (int i = 0; i < randomChildren; i++) {
			UlxContainer container = new UlxContainer();
			container.setName(randomString(20, 3));
			container.setIcon(fIcons[randomInt(fIcons.length - 1)]);
			children[i] = container;
			randomInitialize(numberOfChildren, newLevel, container);
		}
		entity.setContained(children);
	}
}
void randomInitialize(int identifier, UlxAddress address) {
	address.setCity(randomString(20, 6));
	address.setCountry(randomString(10, 3));
	address.setState(randomString(10, 3));
	address.setStreet(randomString(15, 5));
	address.setZipCode(randomInteger(9999, 1000).toString());
}
void randomInitialize(int identifier, UlxPerson person) {
	person.setBirthdate(randomBirthDate());
	person.setFirstName(randomString(20, 5));
	person.setHomeAddress((UlxAddress) getAddressTableModel().getRowAt(Math.max(0, randomInt(translateScopeToNumber()) - 1)));
	person.setLastName(randomString(21, 4));
	person.setEmailAddress(person.getFirstName() + "_" + person.getLastName() + "@" + randomString(15, 3) + ".com");
	person.setNumberOfChildren(randomInt(9, 0));
	person.setPersonNumber(identifier);
	person.setPhoneNumber("(00" + randomInteger(999, 1).toString() + ") " + randomInteger(100, 1).toString() + "-" + randomInteger(999999, 10000).toString());
	person.setSpeaksForeignLanguages(identifier / 2 == 0);
	person.setXq(randomFloat(100));
}
synchronized int randomInt(int maxValue) {
	return Math.round(fRandom.nextFloat() * maxValue);
}
synchronized int randomInt(int maxValue, int minValue) {
	return Math.max(randomInt(maxValue), minValue);
}
synchronized Integer randomInteger(int maxValue, int minValue) {
	return new Integer(randomInt(maxValue, minValue));
}
String randomString() {
	return randomString(randomInt(20), 5);
}
String randomString(int maxLength) {
	return randomString(maxLength, 0);
}
String randomString(int maxLength, int minLength) {
	if (maxLength < minLength)
		return randomString(minLength, minLength);
	if (maxLength == 0)
		return "";
	char[] chars = new char[] {'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
	int length = randomInt(maxLength, minLength);
	char[] c = new char[length];
	c[0] = Character.toUpperCase(chars[Math.max(randomInt(26) - 1, 0)]);
	for (int i = 1; i < length; i++)
		c[i] = chars[Math.max(randomInt(26) - 1, 0)];
	return new String(c);
}
void removeRowsAfter(UlxTableModel tableModel, int newSize) {
	Vector rows = tableModel.getRows();
	Vector toBeRemoved = new Vector(newSize);
	for (int i = newSize; i < rows.size(); i++) {
		toBeRemoved.addElement(rows.elementAt(i));
	}
	tableModel.removeRows(toBeRemoved);
}
void setScope(int scope) {
	if (scope >= DATA_NONE && scope <= DATA_GIGANTIC) {
		if (fScope != scope) {
			int oldScope = fScope;
			fScope = scope;
			if (fAddressTableModel != null)
				updateAddressTableModel(oldScope);
			if (fPersonTableModel != null)
				updatePersonTableModel(oldScope);
		}
	}
}
int translateScopeToNumber() {
	return SCOPE_TRANSLATION[getScope()];
}
void updateAddressTableModel(int oldScope) {
	int oldSize = SCOPE_TRANSLATION[oldScope];
	int newSize = translateScopeToNumber();
	if (oldSize > newSize)
		removeRowsAfter(getAddressTableModel(), newSize);
	else {
		Vector addresses = new Vector(newSize - oldSize);
		for (int i = oldSize; i < newSize; i++) {
			UlxAddress model = new UlxAddress();
			randomInitialize(i, model);
			addresses.addElement(model);
		}
		getAddressTableModel().addRows(addresses);
	}
}
void updatePersonTableModel(int oldScope) {
	int oldSize = SCOPE_TRANSLATION[oldScope];
	int newSize = translateScopeToNumber();
	if (oldSize > newSize) {
		removeRowsAfter(getPersonTableModel(), newSize);
		java.util.Enumeration persons = getPersonTableModel().getRows().elements();
		while (persons.hasMoreElements()) {
			UlxPerson person = (UlxPerson) persons.nextElement();
			if (!person.getHomeAddress().isMapped(getAddressTableModel()))
				person.setHomeAddress((UlxAddress) getAddressTableModel().getRowAt(randomInt(translateScopeToNumber())));
		}
	}
	else {
		Vector addresses = new Vector(newSize - oldSize);
		for (int i = oldSize; i < newSize; i++) {
			UlxPerson model = new UlxPerson();
			randomInitialize(i, model);
			addresses.addElement(model);
		}
		getPersonTableModel().addRows(addresses);
	}
}
}
