package com.ibm.ulc.test;

/**
 * This class is used in the UI of this package.
 *
 * It wraps a single test composite (subclass of UlxAbstractTestComposite).
 */
import java.util.Vector;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.application.ULCRowModel;
import com.ibm.ulc.application.ULCTableModel;
import com.ibm.ulc.util.ITableRow;
import com.ibm.ulc.application.GenericTableModel;
class UlxTestFM extends ULCRowModel implements IUlxTestListener {
	private boolean fHasChanges = false;
	private GenericTableModel fieldTestedClassesModel = new GenericTableModel();
	private GenericTableModel fieldTestedApiModel = new GenericTableModel();
	private GenericTableModel fieldTestCategoriesModel = new GenericTableModel();
	private GenericTableModel fieldTestedProblemReportsModel = new GenericTableModel();
	private String fPackageName = null;
	private UlxTest fieldModel;
	private String fieldTestType = new String();
	private boolean fieldCanBeEdited = false;
	protected transient java.beans.PropertyChangeSupport propertyChange;
	private UlxSystem fieldSystem;
	private boolean fieldIsEditable = false;
	protected transient UlxEventListenerList fFormModelListeners = new UlxEventListenerList();
/**
 * Construct a new ULCFormModel with the default notification policy.
 */
public UlxTestFM() {
	super();
}
/**
 * 
 * @param newListener com.ibm.ulc.test.FormModelEventsListener
 */
public void addFormModelEventsListener(IUlxFormModelListener newListener) {
	fFormModelListeners.add(IUlxFormModelListener.class, newListener);
	return;
}
/**
 * The addPropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().addPropertyChangeListener(listener);
}
/**
 * Set the receiver's current UlxTest object. Notify the change.
 *
 * @param UlxTest	may be null.
 */
public void basicSetModel(UlxTest model) {
	if (model == null)
		basicSetModel(new UlxTest());
	else {
		if (fieldModel != null)
			fieldModel.removeListener(this);
		fieldModel = model;
		model.addListener(this);
		if (model.isNewTest())
			setTestType("new");
		else
			setTestType("old");
	if (fContext != null)
		fContext.startBatchingRequests();
	updateTableModels();
	if (fContext != null)
		fContext.stopBatchingRequests();
}
}
/**
 * Notify my peer that all values are to be marked as invalid.
 * This will cause the UI to request the values from the application once again.
 * Any changes that have been made in the UI are lost.
 */
public void cancelInput() {
	super.cancelInput();
	updateTableModels();
	fireInputCanceled();
}
/**
 * Answer true, if the receiver's test class can be run
 */
public boolean canRun() {
	return getModel().canRun();
}
/**
 * Method to support listener events.
 * @param event com.ibm.ulc.test.ULCFormModel
 */
protected void fireInputCanceled() {
	if (fFormModelListeners.getListenerCount(IUlxFormModelListener.class) > 0) {
		IUlxFormModelListener[] listeners = (IUlxFormModelListener[]) fFormModelListeners.getListeners(IUlxFormModelListener.class);
		for (int i = 0; i < listeners.length; i++)
			listeners[i].inputCanceled(this);
	}
}
/**
 * Method to support listener events.
 * @param event com.ibm.ulc.test.ULCFormModel
 */
protected void fireInputSaved() {
	resetPackageName();
	if (fFormModelListeners.getListenerCount(IUlxFormModelListener.class) > 0) {
		IUlxFormModelListener[] listeners = (IUlxFormModelListener[]) fFormModelListeners.getListeners(IUlxFormModelListener.class);
		for (int i = 0; i < listeners.length; i++)
			listeners[i].inputSaved(this);
	}
}
/**
 * Method to support listener events.
 * @param event com.ibm.ulc.test.ULCFormModel
 */
protected void fireModelChanged() {
	if (fFormModelListeners.getListenerCount(IUlxFormModelListener.class) > 0) {
		IUlxFormModelListener[] listeners = (IUlxFormModelListener[]) fFormModelListeners.getListeners(IUlxFormModelListener.class);
		for (int i = 0; i < listeners.length; i++)
			listeners[i].modelChanged(this);
	}
}
/**
 * The firePropertyChange method was generated to support the propertyChange field.
 */
public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
}
/**
 * Gets the canBeEdited property (boolean) value.
 * @return The canBeEdited property value.
 */
public boolean getCanBeEdited() {
	return fieldCanBeEdited;
}
/**
 * Gets the hasChanges property (boolean) value.
 */
public boolean getHasChanges() {
	return fHasChanges;
}
/**
 * Gets the isEditable property (boolean) value.
 * @return The isEditable property value.
 */
public boolean getIsEditable() {
	return fieldIsEditable;
}
/**
 * Answer the receiver's current UlxTest object. If none is defined, answer null.
 *
 * @return UlxTest	may be null.
 */
public UlxTest getModel() {
	return fieldModel;
}
/**
 * Accessor for the propertyChange field.
 */
protected java.beans.PropertyChangeSupport getPropertyChange() {
	if (propertyChange == null) {
		propertyChange = new java.beans.PropertyChangeSupport(this);
	};
	return propertyChange;
}
/**
 * Gets the system property (com.ibm.ulc.test.UlxSystem) value.
 * @return The system property value.
 * @see #setSystem
 */
public UlxSystem getSystem() {
	return fieldSystem;
}
/**
 * Gets the testCategoriesModel property (com.ibm.ulc.application.GenericTableModel) value.
 * @return The testCategoriesModel property value.
 */
public com.ibm.ulc.application.GenericTableModel getTestCategoriesModel() {
	return fieldTestCategoriesModel;
}
/**
 * Gets the testedApiModel property (com.ibm.ulc.application.GenericTableModel) value.
 * @return The testedApiModel property value.
 */
public com.ibm.ulc.application.GenericTableModel getTestedApiModel() {
	return fieldTestedApiModel;
}
/**
 * Gets the testedClassesModel property (com.ibm.ulc.application.GenericTableModel) value.
 * @return The testedClassesModel property value.
 */
public com.ibm.ulc.application.GenericTableModel getTestedClassesModel() {
	return fieldTestedClassesModel;
}
/**
 * Gets the testedProblemReportsModel property (com.ibm.ulc.application.GenericTableModel) value.
 * @return The testedProblemReportsModel property value.
 */
public com.ibm.ulc.application.GenericTableModel getTestedProblemReportsModel() {
	return fieldTestedProblemReportsModel;
}
/**
 * Gets the testType property (java.lang.String) value.
 * @return The testType property value.
 * @see #setTestType
 */
public String getTestType() {
	return fieldTestType;
}
/**
 * Override this method to return the requested value for the given key.
 *
 * @param formAttributeName 	The key at which the object is.
 */
public Object getValueAt(String formAttributeName) {
	if (getModel() == null)
		return null;
	else
		return getModel().getValueAt(formAttributeName);
}
/**
 * The UI has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("event")) {
		String type = args.get("type", "???");
		if (type.equals("hasChanges")) {
			fHasChanges = args.get("c").asBoolean(false);
		}
	}
	super.handleRequest(conn, request, args);
}
/**
 * initialize the receiver's attributes
 *
 */
protected void initialize() {
	super.initialize();
	fHasChanges = false;
	fieldTestedClassesModel = new GenericTableModel();
	fieldTestedApiModel = new GenericTableModel();
	fieldTestCategoriesModel = new GenericTableModel();
	fieldTestedProblemReportsModel = new GenericTableModel();
	fPackageName = null;
	fieldTestType = new String();
	fieldCanBeEdited = false;
	fieldIsEditable = false;
	fFormModelListeners = new UlxEventListenerList();

	getTestedClassesModel().setNotificationPolicy(ULCTableModel.TABLE_EDIT_UPDATE_ON_FOCUS_CHANGE);
	getTestedApiModel().setNotificationPolicy(ULCTableModel.TABLE_EDIT_UPDATE_ON_FOCUS_CHANGE);
	getTestCategoriesModel().setNotificationPolicy(ULCTableModel.TABLE_EDIT_UPDATE_ON_FOCUS_CHANGE);
	getTestedProblemReportsModel().setNotificationPolicy(ULCTableModel.TABLE_EDIT_UPDATE_ON_FOCUS_CHANGE);
}
/**
 * 
 * @param newListener com.ibm.ulc.test.FormModelEventsListener
 */
public void removeFormModelEventsListener(IUlxFormModelListener oldListener) {
	fFormModelListeners.remove(IUlxFormModelListener.class, oldListener);
	return;
}
/**
 * The removePropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().removePropertyChangeListener(listener);
}
/**
 * Sets the testType property (java.lang.String) value.
 * @param testType The new value for the property.
 * @see #getTestType
 */
void resetPackageName() {
	fPackageName = null;
}
/**
 * Notify my peer that all values are to be marked as invalid.
 * This will cause the UI to request the values from the application once again.
 * Any changes that have been made in the UI are lost.
 */
public boolean saveInput() {
	if (super.saveInput()) {
		getModel().setTestCategories(toStringsArray(getTestCategoriesModel().getRows()));
		getModel().setTestedAPI(toStringsArray(getTestedApiModel().getRows()));
		getModel().setTestedClasses(toStringsArray(getTestedClassesModel().getRows()));
		getModel().setTestedPRs(toStringsArray(getTestedProblemReportsModel().getRows()));
		getModel().setDataDone(this, new String[0]);
		fireInputSaved();
		return true;
	} else
		return false;
}
/**
 * Sets the model property (com.ibm.ulc.test.UlxTest) value.
 * @param model The new value for the property.
 * @see #getModel
 */
public void setModel(UlxTest model) {
	UlxTest oldValue = fieldModel;
	resetPackageName();
	basicSetModel(model);
	firePropertyChange("model", oldValue, model);
	setCurrentRow(model);
}
/**
 * Sets the system property (com.ibm.ulc.test.UlxSystem) value.
 * @param system The new value for the property.
 * @see #getSystem
 */
public void setSystem(UlxSystem system) {
	UlxSystem oldValue = fieldSystem;
	fieldSystem = system;
	setTableModel(system.getTableModel());
	firePropertyChange("system", oldValue, system);
}
/**
 * Sets the testType property (java.lang.String) value.
 * @param testType The new value for the property.
 * @see #getTestType
 */
public void setTestType(String testType) {
	fieldTestType = testType;
}
/**
 * Override this method to return the requested value for the given key.
 *
 * @param formAttributeName 	The key at which the object is.
 */
public void setValueAt(Object object, String formAttributeName) {
	if (getModel() == null)
		return;
	else
		getModel().setValueAt(object, formAttributeName);
}
/**
 * The @attributeNames of a @test has changed.
 *
 * @param attributeNames	String[] 	all attributes that changed
 * @param test				UlxTest		the test that was modified
 */
public void testChanged(UlxTest test, String[] attributeNames) {
	if (test == getModel()) {
		fContext.startBatchingRequests();
		updateTableModels();
		fContext.stopBatchingRequests();
	}
}
/**
 * Set the receiver's current UlxTest object. Notify the change.
 *
 * @param UlxTest	may be null.
 */
private Vector toRowModels(GenericTableModel model, String[] strings) {
	Vector answer = new Vector(strings.length);
	for (int i = 0; i < strings.length; i++) {
		answer.addElement(model.createNewRow("string", strings[i]));
	}
	return answer;
}
/**
 * Set the receiver's current UlxTest object. Notify the change.
 *
 * @param UlxTest	may be null.
 */
private String[] toStringsArray(Vector rows) {
	String[] strings = new String[rows.size()];
	for (int i = 0; i < strings.length; i++) {
		strings[i] = (String) ((ITableRow) rows.elementAt(i)).getValueAt("string");
	}
	return strings;
}
/**
 * Gets the system property (com.ibm.ulc.test.UlxSystem) value.
 * @return The system property value.
 * @see #setSystem
 */
public String typeString() {
	return "RowModel";
}
/**
 * Set the receiver's current UlxTest object. Notify the change.
 *
 * @param UlxTest	may be null.
 */
private void updateTableModels() {
	getTestedClassesModel().setRows(toRowModels(getTestedClassesModel(), getModel().getTestedClasses()));
	getTestedApiModel().setRows(toRowModels(getTestedApiModel(), getModel().getTestedAPI()));
	getTestCategoriesModel().setRows(toRowModels(getTestCategoriesModel(), getModel().getTestCategories()));
	getTestedProblemReportsModel().setRows(toRowModels(getTestedProblemReportsModel(), getModel().getTestedPRs()));
}
}
