package com.ibm.ulc.test;

/**
 * This class implements the infrastructure for a set of ULC tests.
 */
import java.util.Enumeration;
import com.ibm.ulc.util.UlcHashtable;
import com.ibm.ulc.application.ULCVajContext;
import com.ibm.ulc.application.ULCApplication;
import com.ibm.ulc.application.ULCNotebook;
import com.ibm.ulc.application.ULCPage;
import com.ibm.ulc.testsample.*;

public class UlxTestSuite implements IUlxTestListener {
	private UlxSystem fSystem = null;
	private UlxAbstractTestComposite[] composites = new UlxAbstractTestComposite[0];
	private ULCNotebook fNotebook = null;
	private UlxWindowTestSuite fWindow = null;
	private UlxTestData fTestData = new UlxTestData();
	private UlxBusinessController fController= new UlxBusinessController();
	private String fName = "";
	private int fTabPlacement = ULCNotebook.BOX_TOP;
	private int fInnerTabPlacement = ULCNotebook.BOX_TOP;
/**
 * Create a new instance of the receiver.
 */
UlxTestSuite() {
}
/**
 * Create a new instance of the receiver.
 */
UlxTestSuite(UlxSystem system) {
	fSystem = system;
	system.addTestSuite(this);
}
/**
 * Create a new instance of the receiver.
 */
UlxTestSuite(UlxSystem system, UlxTest[] tests) {
	this(system);
	setComponents(tests);
}
/**
 * Create a new instance of the receiver.
 */
UlxTestSuite(UlxSystem system, UlxTest[] tests, int tabPlacement, int innerTabPlacement) {
	this(system);
	fTabPlacement = tabPlacement;
	fInnerTabPlacement = innerTabPlacement;
	setComponents(tests);
}
/**
 * setup the components of the receiver
 */
private void addNotebookPage(ULCNotebook notebook, String label, UlcHashtable contents) {
	if (contents.size() == 0)
		return;
	if (contents.size() == 1) {
		addTestToNotebook((UlxTest) contents.elements().nextElement(), notebook, label);
	}
	else {
		ULCNotebook minorBook = new ULCNotebook();
		minorBook.addSelectionChangedListener(getWindow());
		ULCPage page = new UlxPage(label, minorBook);
		notebook.addPage(page);
		String[] minors = sortKeys(contents);
		for (int i = 0; i < minors.length; i++) {
			addTestToNotebook((UlxTest) contents.get(minors[i]), minorBook, minors[i]);
		}
	}
}
/**
 * setup the components of the receiver
 */
private void addTestToNotebook(UlxTest test, ULCNotebook notebook, String label) {
	UlxAbstractTestComposite composite = test.getTestComposite(fInnerTabPlacement);
	if (composite != null) {
		UlxViewTestRunner runner = new UlxViewTestRunner(fSystem.getContext());
		runner.setTestComponent(this, composite);
		ULCPage page = new UlxPage(label, runner);
		notebook.addPage(page);
	}
}
/**
 * Compares the object at leftOid to rightOid answer 0 if they are equal -1 if its less and 1 if its greater.
 *
 * @return  the value <code>0</code> if the attribute at attributeIndex
 *			of the row leftOid is equal to that in rightOid;
 * 			a value less than <code>0</code> if its less; and a
 *          value greater than <code>0</code> if its greater.
 */
private int compare(String left, String right) {
	return left.compareTo(right);
}
/**
 * setup the components of the receiver
 */
private ULCVajContext getContext() {
	if (fSystem != null)
		return fSystem.getContext();
	return null;
}
public UlxBusinessController getController() {
	return fController;
}
/**
 * open the receiver's interface
 */
public int getDataScope() {
	return getTestData().getScope();
}
public UlxData getDataSource() {
	return fTestData.getDataSource();
}
/**
 * setup the components of the receiver
 */
private ULCNotebook getNotebook() {
	if (fNotebook == null) {
		fNotebook = new ULCNotebook();
		fNotebook.setTabPlacement(fTabPlacement);
	}
	return fNotebook;
}
/**
 * open the receiver's interface
 */
public UlxTestData getTestData() {
	return fTestData;
}
private UlxWindowTestSuite getWindow() {
	if (fWindow == null) {
		fWindow = new UlxWindowTestSuite(getContext());
		ULCApplication application = new ULCApplication(getContext());
		application.add(fWindow);
		fWindow.setNotebook(getNotebook());
		if (fName != "")
			fWindow.setLabel(fWindow.getLabel() + " [" + fName + "]");
		else
			fWindow.setLabel(fWindow.getLabel() + " [" + (new java.util.GregorianCalendar()).getTime().toString() + "]");
	}
	return fWindow;
}
/**
 * open the receiver's interface
 */
public void open() {
	UlxWindowTestSuite window = getWindow();
	window.setVisible(true);
}
/**
 * setup the components of the receiver
 */
private void setApiMajor(UlcHashtable major, UlxTest test) {
	String key = test.getTestPageTabString();
	UlcHashtable table;
	Object object = major.get(key, null);
	if (object == null) {
		table = new UlcHashtable();
		major.put(key, table);
	} else {
		table = (UlcHashtable) object;
	}
	if (table.get(test.getTestPageTabString()) == null)
		table.put(test.getTestPageTabString(), test);
	else {
		int count = 1;
		do {
			String k = test.getTestPageTabString() + (new Integer(count)).toString();
			if (table.get(k) == null) {
				table.put(k, test);
				count = 0;
			} else
				count++;
		} while (count > 0);
	}
}
/**
 * setup the components of the receiver
 */
private void setComponents(UlxTest[] tests) {
	UlcHashtable major = new UlcHashtable();
	for (int i = 0; i < tests.length; i++) {
		if (tests[i].isApiTest())
			setApiMajor(major, tests[i]);
		else
			setMajor(major, tests[i]);
	}
	String[] sortedMajor = sortKeys(major);
	ULCNotebook notebook = getNotebook();
	for (int i = 0; i < sortedMajor.length; i++) {
		addNotebookPage(notebook, sortedMajor[i], (UlcHashtable) major.get(sortedMajor[i]));
	}
}
/**
 * open the receiver's interface
 */
public void setDataScope(int scope) {
	fTestData.setScope(scope);
}
/**
 * setup the components of the receiver
 */
private void setMajor(UlcHashtable major, UlxTest test) {
	String[] classes = test.getTestedClasses();
	for (int i = 0; i < classes.length; i++) {
		UlcHashtable table;
		Object object = major.get(classes[i], null);
		if (object == null) {
			table = new UlcHashtable();
			major.put(classes[i], table);
		}
		else {
			table = (UlcHashtable) object;
		}
		if (table.get(test.getTestPageTabString()) == null)
			table.put(test.getTestPageTabString(), test);
		else {
			int count = 1;
			do {
				String key = test.getTestPageTabString() + (new Integer(count)).toString();
				if (table.get(key) == null) {
					table.put(key, test);
					count = 0;
				}
				else
					count++;
			}
			while (count > 0);
		}
	}
}
/**
 * open the receiver's interface
 */
public void setName(String name) {
	if (name != null)
		fName = name;
}
/**
 * one of BOX_TOP, BOX_BOTTOM, BOX_LEFT or BOX_RIGHT
 */
public void setTabPlacement(int constant) {
	fTabPlacement = constant;
}
/**
 * Sort the nodes in the given array.
 */
private void sort(String[] list, int left, int right) {
	int original_left = left;
	int original_right = right;
	String mid = list[ (left + right) / 2];
	do {
		while (compare(list[left], mid) < 0) {
			left++;
		}
		while (compare(mid, list[right]) < 0) {
			right--;
		}
		if (left <= right) {
			String tmp = list[left];
			list[left] = list[right];
			list[right] = tmp;
			left++;
			right--;
		}
	} while (left <= right);
	if (original_left < right) {
		sort(list, original_left, right);
	}
	if (left < original_right) {
		sort(list, left, original_right);
	}
}
/**
 * setup the components of the receiver
 */
private String[] sortKeys(UlcHashtable hashtable) {
	String[] answer = new String[hashtable.size()];
	Enumeration keys = hashtable.keys();
	int count = 0;
	while (keys.hasMoreElements()) {
		answer[count++] = (String) keys.nextElement();
	}
	sort(answer, 0, answer.length - 1);
	return answer;
}
/**
 * The @attributeNames of a UlxTest has changed. Have the current development
 * implementation update its source.
 *
 * @param attributeNames	String[] 	all attributes that changed
 * @param newValues			Object[]	all new values 
 */
public void testChanged(UlxTest test, String[] attributeNames) {
}
}
