package com.ibm.ulc.test;

/**
 * This class is used when the receiver is running inside of VAJ.
 */
import java.util.Vector;
import java.util.StringTokenizer;
import java.lang.reflect.Modifier;
import java.lang.reflect.Method;
import com.ibm.uvm.abt.edit.codeGeneration.CgClassDescription;
import com.ibm.uvm.abt.edit.codeGeneration.CgMethodDescription;
import com.ibm.uvm.abt.edit.codeGeneration.CgPackageDescription;
import com.ibm.ivj.util.base.Type;
import com.ibm.ivj.util.base.ToolEnv;
import com.ibm.uvm.tools.DebugSupport;
class UlxVAJImplementation extends UlxAbstractDevelopmentImplementation {
	boolean fCanBrowse = false;
	Vector fTestedAPI = null;
	Vector fTestedClasses = null;
	//Workspace fWorkspace = null;
/**
 * Add the static packageName method to clsDescription only if it has changed.
 * 
 */
private boolean basicSetPrivateStaticMethod(CgClassDescription clsDescription, String methodName, String stringSource, Class returnType) {
	CgMethodDescription mth = new CgMethodDescription(methodName, returnType);
	mth.setModifiers((java.lang.reflect.Modifier.STATIC | java.lang.reflect.Modifier.PRIVATE));
	mth.setMethodBody(stringSource);
	clsDescription.addMethod(mth);
	return true;
}
/**
 * Add the static packageName method to clsDescription only if it has changed.
 * 
 */
private boolean basicSetStaticMethod(CgClassDescription clsDescription, String methodName, String stringSource, Class returnType) {
	CgMethodDescription mth = new CgMethodDescription(methodName, returnType);
	mth.setModifiers((java.lang.reflect.Modifier.STATIC | java.lang.reflect.Modifier.PUBLIC));
	mth.setMethodBody("	return " + stringSource + ";\n");
	clsDescription.addMethod(mth);
	return true;
}
/**
 * Answer true, if the current environment can open VisualAge browsers.
 */
public boolean canBrowse() {
	return fCanBrowse;
}
/**
 * Answer the subclasses of @class.
 *
 * This method uses reflection to accomplish its task.
 */
Vector computeAvailableTests() {
	Vector answer = getSubclasses(UlxAbstractTestComposite.class);
	answer.removeElement(UlxPrivateTestComposite.class);
	return answer;
}
/**
 * Update the tested testComponent's implementation now.
 * 
 */
private boolean generate(CgClassDescription clsDescription, UlxTest test) {
	try {
		clsDescription.generate();
	} catch (Throwable t) {
		t.toString();
		return false;
	}
	return true;
}
private String getBuilderDataString() {
	String s = "/*V1.1\n**start of data**" +
	"\n\tD0CB838494G88G88GE00EEAA7GGGGGGGGGGGG8CGGGE2F5E9ECE4E5F2A0E4E1F4E135BC8BF494D51638F2BC51E5F69887E7B91A3303E7185D4CEEF697B5AAEA44G018408884A1FA061A3C40890A47C83D668FC95B4C8C6619807B8868C9010CFA0A190488757B086BA108F8119C3BA69A2E9689F5D95929898775E776AD6D7D7D73701C9B867DAF56FFD756E3B775DF7BF5595051C9D0352D2B66688C2CA1AA07FABCE910479E78461E86B0EEC22353FE44C90D47F3E8258A2FCF1B7952EDD" +
	"\n\t4013B656E6E48B3B5BB3816F87788940BF077B2D427E764155F063C74EDD60D52E5877E2E0B9332F121C8C063F30F393DCBF86688F34B0FC66E5A348FFFD67B619BE8DE89F4B7788A99B85E1G9B336E72B6957D744BFCDC9F791A778A0ED938B3D76647829D47A481E43E6219B30B2DEE6C4192999FDC7438F0606A17991BD116EAFE02F67959FE72B534ADA48D8DE1903E4A7A962EA7EAEF341DECF55876DBDAEC7BBB2C2D7BA551AD1516B6D83B6A61264AE1F3BA5C96C92C97EDCE2BC99205E4364E3C9FB359" +
	"\n\t9C029089B8DFD3297D04AC33FE4BCB6905DFBF1F223726127C67D34A4379DA4C611EB5ED6A1F121A73AA4E7D492ECD72F303019F8B40E5B66CA219CDB0EE9A9BDBFC994776077B900008D7E9AD555F53DAC23EF8A95D3A7B7914CFF456F265DF1F5C1CBB0C2F6174B04FDA0640DA36337D3EE142BD6B833C41GC381E2811281F2DFB3E6FC417CECD7739E38D6342031EC8EFB0553D9E9B53B4EBA4C22956ECBCB01A353AE082D8E17D99038AF6D7C31D0E73F880ADE7376A34F5EDF94E86F07BCBCG6C5F181326" +
	"\n\t231B505EE528166738721AC7B72ED7C6AB6AF59768838106GC4834483E4C610DE4E6643BF2757993BA43A6CA6EBDDC70B536412AABBACD6336812757B632EC07A6981FF6E6B7BFE0E5BA564305AAE35239AF3B2F46C12B87459747C88EE0F93919E3BF059177D4A3E92613B9F6C7CC6209F7E9773C3A75C2748BE4A694FB3FA240A4EFD3C0C51911F843C12616437318E52616E1D470548C8FD9DD2DFFCB6BDF8B8DFCF58F06D5EA618B1064481BD99A0E704B123902086209D606E885A5FD71A717CB7D8DB7D6C" +
	"\n\tAFF0E4DA2DEAEF79331269B3380ADD124BF4466E16CC76D63151643218DA2C22DB10475CB3615ADB3C1E7BA7F61EDAC1467722DDF419A40B438E331BECA2B8121B0F79E753969C639299375EE203B8E432B9851A7757262DF0351A5CD203538CA149B302731FB221ADEF199AE1C618G6EE3C6204D0F3318958C77C381382D36DFC3DA76C8E3C641C8324BE7AD1F427587F0EC51DADAFA5A520A4BB039EE137C6CD60CA562AD51AE1D961D225D8CB7EE1977F9EB1647AE579C4A1A3FE4F4BCA3D530F037C27F3AF5" +
	"\n\t8B27439CEAAB93FFAF631BA449E5E9691044BAD112AC76B64F730759DA5CDE474FADF05D325B5047CE00DE75GE6C53F70562DAA7DEA9C0E9B9D4EFA5CB959CECE96E73BE0FC7F1114771E390CF9B0ECA4796912A672532E0983047C146186BDBF0D6DF85490BB127BE752C86DD9FB054D6911D1F53969BE4FFDF7A0CC164BE5DC69959986794A6D7EF0BB5ABDB7924EB5C0D3A459FDD5EB1E4062E92549ADD284B53AE047C433474B785815E67FBE365E2C6FE386D15F47324440BE34C55473A14E5BA6E2EEF1F4" +
	"\n\t5AD5BE792578A9BB43F63B48962DBCA2703AE2C9BD5A42E237C897AD66B6D12A335C9185E1E0A47A56F9F6861DF05FB712FC2973EB722522F10F8B2BA7059874725900990F99E2A379DEA6C6FAFC092F69CF57506622D53401212A9C9DF609537359791669F2FC792CCDFFECEE9B7A638D7136BCAE2FADDD40B8E26D90955D0618BE42753BACB658AABC30C257A8546B11DD6A5AAE9BE8D88756403599404066CBEA43F921304A434AAACFA92D72145A0A7BCF38855797814FCD82C898C57E935C36DDF5EEE54729" +
	"\n\tF2D82DFC9B147DF9349D0BE737F833C304300C877B87C5277E6D1FEAF80D32FE1CBF309D75332AE2C26AE8542FCD2977B0E7F05ABDC63B8887EBDD9A656033596A3AB4E6D4E80A5EDEA2D40F16EB13515A7C356CBA4EFB97687DC6136EDBAD6A18D561F6BBDAADACBD487BF2B0A3F0ADDB5162066352AAF95534F2AD3BC429AB870D263A7271825C03E900A782E4C6112F7E6E885515F773DECAB7676B5738FD001E97A55715D19E7D1C314DB9DC1F9196DF3F0C32FC8857EB96179B6AAA3358C5FB723A85E5E33E" +
	"\n\t1349D4879ED25B3AFE6C33697EEC5DD7DE4340A82D2D9F3662BA42009E9DC5362E3E3EC5E5EB28D9A13D3701A750FAD6DEB770F3A263EB2F2751B991A84EAE8FD84345C67956D23CDECA5F0DF6CF0C5256D1590CAEC4EB6B280185D4C7E583CF0A263CBE560667F19A60C9G1B4698B37281CE831847101E8F5DB8AC7CCC7D63273E157D540E366B837375D7661CF9E3334AF6358E0BDDD26C96E445F862F0D95AACF6227D025120ABE08116675F2CEFF05EC1B06750B1149BB76D4658942B601FB1BCC1417F2D20" +
	"\n\tBBF98D1FFF107C46E53C58AD990687187FE345C6EF597C673D99B67D3C97E7534FFB8BEC01EB2BA53640F9F1254DFFDEDCE9C7BF6CD2462EE5B81408F2BCFA26936368B5A8ECE14ABA2758AA8C9E0BFB3B639B4A93590067831C86B083749DCBF96221C33837D52255DAB38E1F79EE37BA37A40C65F5D99E700A46D1EFFC1A798C2EE1G50E258F34EEFF2B47BF29C7E339F2E1C7F34979FED31DBD0735F7462230DF7242A792682B5BFCD75BC0FCF7D2FD22C0C3978DC3AB37676E6FF6FA8F2E238DF164857E098" +
	"\n\tCBF39A04280FF7893E6774BB33C5F2386820223510A248B17DEF3BB365671DB194531FE1B1A48470882445D0CC5F7B2DBA26B7BD71246EBAA520A74A6B4BF95D93C7D77FB2A5151F0FB35FBCD85F5AD711DF734CB369B5CF0626FC6447CECD325CAE79AABD951A02D79E0F5EF5221F04GAF92A09EC0988F7D9FC061F80ACF779C38C628BB51D89512E4EAEDE799084A51C60B5869A12363F25D7A6C56532DFC3CF7BC29D761BCEE6F5C03B6EF9F2F0D675FB2FA57F8EDBCFFF1B74573A060A50C27F87ED7976AD6" +
	"\n\t7B06B1438A5097A098A09CA0768D52AD5AD12C63A73A719C5DC5B7267F079BFDFAB54C19B3816AF7009A006689A46393671F397DF4EC779D943BD58E568DCB94975EF77A0FE7EB1CBF5FC3EF3C09B5C10BC3129CB61C1F6819B7F1DFA4071391B9ED73CD74A7C8AF6D929FAA53375E4433E0952FB1B24FB13FE16763AE685518CEF967A9C68B16E9FC5F776E41D894BE01724C9106CFD370D7F777F4BF05323C734E149E17214ED15CC657DC7E774966524FBBEE17FE5E396D8A1CF79EF2854EBB0F3A7C671D7FF5" +
	"\n\t7BDF678B6E1F7727575C2C6E84BF283F6D94B9AD524D6A12EB575C226237E35C598A6D0C3B964BE5A836F9BC7E61B42E7F166812AC2DA6EB055552E647F3A0D03CBE5F0E35FABB94BAF79CF6C9BD026737EB92465733A60B3D4EE93500096C682B3C0FB26FD1673AE470852CF10AA69AB32A81787CB33270FD2BCF2DEFF242EC2D2CA90033DED3251A1C6704A777D0CEE81EC8B9E1830BC383819F8290BD117C7A37FBB05E45CD6CDE3D148463F8DCF36D4579B25F64F18DE5F17ABDC64FD551F93CCBE5F4448FG" +
	"\n\tEFGGBF0B4F33352E861C65DBC61B40E81B5EB2E6943CC56B6C5A0B349300B7A9340799CD82FC20C27BF06F031EA11C5B9F2F69AD753B152F9FD8C6201AB1CDB5E62BB00E5900FC0F53966C41B3E1365C3240C129F1F09790F6B09E6C05C07F62CE7171193B507FB09E32CE504EFD17737E3893E531982AE266CFC27BBF37D76D1B6120BB464155F05D84FCBE6677477546D80157E792796F516F755E3BFA57B30A73AA058D77615F96128F8F1CC4BEBC3990FDE8826071G42E42AEB5ACFD0DD117CD33281EB95" +
	"\n\tFF75573649727B70491E3AA6A26B098F394C0AB21299B419E4F61631F7940883A4CEA6BF9BDC28D7A7E4CE7176215CA95ABA614CBE1C6F4094ED1DD0476865D334F5424CC22A93EA0197B6056A84E7875AFF5BD40899GB5GE6003EG0327D28EEF114AF56C2F5F772937413BE0607A7EDF191E3E91D33D751DB4D52B6FE2E63F7829DAFDD7B07A6A29DAFD6F15113E1953401F26D11CF83950B70F3FD6681B470D7BB0EFCF18C67BF40961898ABE27D0FBF6F1ECCF65DBAEE32D0F0C876D9575C04E3D9D7E73E3" +
	"\n\t1F8E7DBC7EC807FE9E6F5791B80F8F68881C4703BB7472B85F23ABE53E7BE6AA735D37E5E538CF5953E91F56B13CC0419FAE535A9447766C3E857B486849FD63F177634BF80FEF67AADC22295261E2068E1D0EF6895A270E29B5C0435C56872E8326D34F7C7BEA2C131563FA106A09BDA73575846644A4F8AEF386456355FF79C668C6BDA1AF0A4744E17B681DE15E8C0A09E70F6299ED825C8990B40362706CCA0A4373FF99B88E8F1A4177AEF206A78E8F8A8E5E4CE5B61F24B81CBD13E48EBD09B22B81EF8668" +
	"\n\t1AC9FEB1F2DFF7FB517EB3656F90D87C994EF498BCD39B1746B1FA58CCEDDC2ABBCAF1A992F8853194072BBA516E7DG8F8108G1886309AE05BAC0A43C7EE158977512F55320388C1587BACF2FD451328EF512C6E79FE75AC2A578ACF617A2F4C5256EB450C6E1C252D57061D24FA2DAF7062E7D19C1E4E7C2166ED580737E98F220E62D935AA78C40677D170CBC73BD3AF61738FFEF6DD5D12710F3D332B69749FF36BBA75E36E25CE7D18FB35B3F04CED6B8C9CF39D1D7EE36E5FCED27D0CEB6734DF1D24BA7B" +
	"\n\tCF0A4D8E1DC25AE030FB0432D7E50C968B38B01BE811A79F345E9D2C5953881DBD66B2E6BD308C6D1E26799933D5D83A8FF9D6D30BE805EB7EEC7C8E4AF1CFD0785B77A09F0FA004D5013F13940A55F1359D1E41DAA2982EC3E6D3CCDED34D7CD7DDE79F24B97FF08677493B4EBEA8575936D35A9A9A73DDB44C9BBB1B6A6C05977446A481BFB30E626E28E6756FA3C5D9A78CF8167562EEDE9C37FFE11C769B292D67B0B7C0A4429A7CAF26DBA67E13A645A71E93B4B57A51E2254F0C23B8EDADE6FDA660C3G22" +
	"\n\t63683D6D6FCE5158B8E56CF496FB364DB1E69CG281EC3E33F2CD3661DC3E36B6A583C008F81081EC3715774F7C1B9934F5D5B8957C653F55FCE232205A9E5EC39AE36CA7526B6456F0E976B650F38B95EFE1AB4C7DB5746B1BDB367EA7347A2C65FB6D71BBFDC4514BF8A0057EFAE1D2D10D3FA729367FA4BCF1D2715FF361C49192715FF11518B66E9654FBEC572CB0097BC0F647F39CECF3EB05FDBFE4EFC2D7CA8369F85733572A7B2FA49FC2D7CCBF5A43F9AF82173A91F1CAF762D8F9B0BFD6B4385452CBE" +
	"\n\tFC07561D487082856FAA76298F5F69697A70D7BEB2FA32BE643A8FBB65EB0F1127FC6DD1D70E7A57A87A7F15616D8A7E4E297B0927B577E9ABAEE343FD4938DFDBF15DCB6AFC6DD1D667EB0F576BD07FFE0A7ED3999E2A60D76B9EB43F746B06EDE49FFCE0995D318D4FA74BEF63EFA61E7E21CBA8DC40FEEFABD167098930E62C3F846065AC20BCD53F9FF9D58E3B64F2D85D5E3DC73FF2ED6F01B500844F86A94F379E46EFAA70152B2B03FD092119A33DDEBB875690036079308554034C3D1CAFF42B8769123F" +
	"\n\t05AD21DC903300F2418BA598CBD2979AB3F2810A96D29E0CBC226EBFD2F76AFF33D08B741A05FCCF1D8BBDF9B0BC087A0F9165A4B3ECA149BCD701B293GCF0D873971142BCE54D3FFD494CFE3C75663D8AB60FD8102634987AF1728E3EDD8FCE03F0A0E275AFD4FB11CAFB6DEDB3B9FE17444F8ED6D9EDEC235FB6A3B460C76F7A9D7AE7F8977A78670F8GE19174A8GA5GCD0B28D7D9787723C2B7FB9558A3ED13A277836501FAB2E911C76F20C56A1EEC8433F170A2EDCE09E17450C55A1CD2DFC1B9A59CF8" +
	"\n\tF90B494E95755D6D897BAED64BAFEEE0B546E22D7C8AC68FD92C15BF261E648F85DEEE8265B4A77359BE895C67B96DB1C66B1F404F92DF6701E32C7E865A5084DA7BF1C60B81BCD1210DA869495F05D09EDE07A6285FE94F6CD199944F2896673E157C137F7E49A06877CFD902FE7F74099038FF7ADC885CBF6D907C77CF334A693B94CF9E1ADBCEFDEF4EFB34AF519518E372947CCD0697A978650AA6195FD3F6754DB9EEA623A76B90B5F05DAF56136ECD0AEEE58D282BD9413FE7F817023FD12F75A7F38F5A01" +
	"\n\t4B08771151736F6B9EA9C13DDC0ECEB7478715206CD6073543E6F74BE34632EFAF01F690469D643462F6956D1030846DF86318BABF8603BD30FE1D8457F8GBEA628D4EFCCB5702EG701E5502E1C816BD3B02FA56C382752CA9155A1E956BC2891E8FD266383351B34753C7E80E434A9C379A34F3E0ADB5881E8FDBC239BC530D5F41847EFD87120467139539EFFC7A18125317D04E1C4AF2D96AD20823GC5CBA92767D62AFF5B8973734D8AC24DD2B927AF75647426C7A9278FABA519C317124C24D216BF814F" +
	"\n\tCC047C11C8B93D38124616A452D8DBA5FBCF86F89040A0E5ECE803B22FB2F6AE4B970900E7AE03F91751197877E31817CAG2FD9563D3340734F8FEC1D4D4BF87EC9D168750CEED551F9DE1AF50C7E2E288BF8314BA87FCFB4601E163F8F3E84A0817483888508F91F72FF6446D21DBD75177FF5BEAF114F6648D254B59E66CDFE7FFEF4EDBF0EEB4FDE2E5575A62367AE576A3A3614F4ADGDE3F65E46B93153AFD75F2CDDF1D246DEB6730FD5E16242D8196B3FAC1123686F0D7AAFDB5700213143FA3E8506D2B" +
	"\n\tD7E87A6A95DA790D0DCC4E8A2D7CE6C6AFD921159F5F207455408BDDC1B5C8B8BBE359ABF93D41E94399ADEF253A86B90F5BAD5FDFD65D4FBB569BFFBF609D3F13FBD5067CAD2541FF4DB14720DFF3ACB468579C6F9982579CAB8C01EB0E75867FB54774D25AAFCF4D78F6296FFE590FFB7628D3F5AF9C6F7D7D5A5E2BB2384E97AAFD7B7D0B153E7D7E42CA4C4B87D652F9DB4670EA853FDD69EF2D78CC4F5863F13FB2FA228E613AC7B5785AA32641579ED79A59EFB00A7E57989E2460CB9A1AE4FE6F79C7C6E3" +
	"\n\tEF56223C6678C8707E7E780EC05FA773DA2674B03E9F713C632077A3F9D55A77A3D8270702BDA2D6527B0D664F70FC2A5EEF60AB96797755A79A554FCF03E73A64FAB6FB9555820DD5D48B942C22DA606533ACF7835E8550FF9555CE26BDD8BB797FBB8E6DAAC0A61BAF0265019018A782E52C227D7D31CA1DEF92D7855E67545574EEE17FB9166FD6733C02F10F530FB3FA110A4E73CD84538771DA6005A9732C3D4466D9234D5B8676771F79EB34F9FBF4A3656D83409B30067216F4167DCE35C69D877F0551B2" +
	"\n\t57F29A5737689CFE37178B34A2009A006635CA7F4FF892608381428162945E68335D09E1B8DFF7FCB2D79ED764A5FFF637E4E4F4536F553DF416223FF0D9D06E33D477B10D3D1F875E69D5997CACBEF6563B6F9AFC56376FFAA2ADCB7074DD8715E7CF272B6807BC74CDD7651E6C1027CF3B5D2C2249FD1A7B1C3687433C123A4E1831ED9D75E97D0DFAE38EG7F34B2663FEB7546DC813ED399B3763C5E18A060872F23387207F34A7B48F594D7E6337319GF8EAB274CC49B4F634114696A55358E4A36B93G6F" +
	"\n\t8B902C0C1DD72B4C2B0C5DFE1E4D8BF86AFA18F7BD0D95AEA8732E2731C7AF30F9816F8B903C1E7C7FFF4EE1AC8A83BCFA7D7D547EF5EC1D316B35B1648A23472F574610F74ED18CC982DE538612BF4E087243811F3061FE64BBEBF13E799B3472EFB3FA62862D7C0D35A4BF99F84D9F107C78DA149F8978348F6EC77EAF386DBF504A7F8D232F7EC0ABFF47F9121FAA54E63483F079E997D0FE8C60F1G5D177F1FECBF136099EF794FB13A10D22B11FF6282495F84BCA7G0F571167FCFB0FB167FCEB59CBC6C1" +
	"\n\t39EFD15DAFBE577BB1AC55587B356C9C23EFCD3F4068EB07DB359E5DFFD25DE756763E9D3E6AD599DC678D353E7EE0B8CFF6706474DF1F77689E2C3A5FF93E776DF032D7E5F01D3F38606B8FF997FC6DB06402C77717D4771597FA5F8EBF762A8C7E7FABFA638E7EDDC368FBC21AA4E431BF914792D792B229EC1704CD6ADF99696F471EA8D4FF6732AD447F5FDC8F5D4863DE0CFC757C9D702777D8ADE9284D4887103F133E3BCF707F5DC81D4DE435CAA66B0D8A3B993FA1293CAD091E1E7E73FBB83F1B4648CC" +
	"\n\t79EF756F613A2F2B1E79FFD0CB878839D22B3D0996GG8CCAGGD0CB818294G94G88G88GE00EEAA739D22B3D0996GG8CCAGG8CGGGGGGGGGGGGGGGGGE2F5E9ECE4E5F2A0E4E1F4E1D0CB8586GGGG81G81GBAGGG4396GGGG" +
	"\n**end of data**/\n" + 
	"\n";

	return s;
}
String[] getClassesUnderstandingApi(String[] selectors) {
	Vector names = new Vector();
	Vector cNames = getTestedClasses();
	String[] classNames = new String[cNames.size()];
	cNames.copyInto(classNames);
	for (int i = 0; i < classNames.length; i++) {
		Class cls = getClassForName((String) classNames[i]);
		if (cls != null) {
			Method[] methods = cls.getMethods();
			int implementing = 0;
			for (int si = 0; si < selectors.length; si++) {
				for (int mi = 0; mi < methods.length; mi++) {
					if (methods[mi].getName().equals(selectors[si])) {
						implementing++;
					}
				}
			}
			if (implementing == selectors.length && (!names.contains(classNames[i])))
				names.addElement(classNames[i]);
		}
	}
	String[] answer = new String[names.size()];
	names.copyInto(answer);
	return answer;
}
Class getClassForName(String className) {
	Class cls = null;
	try {
		cls = Class.forName("com.ibm.ulc.application.ULC" + className);
	} catch (Throwable t) {
		try {
			cls = Class.forName("com.ibm.ulc.application." + className);
		} catch (Throwable tt) {
		}
	}
	if (cls == null) {
		try {
			cls = Class.forName(className);
		} catch (Throwable t) {
			System.out.println("unknown class " + className);
			//DebugSupport.halt();
		}
	}
	return cls;
}
java.util.Enumeration getComposedTests() {
	Vector vector = getSubclasses(UlxTestedViewAbstract.class);
	java.util.Enumeration enum = getSubclasses(UlxControlViewAbstract.class).elements();
	while (enum.hasMoreElements()) {
		vector.addElement(enum.nextElement());
	}
	Vector tests = new Vector(vector.size());
	for (int i = 0; i < vector.size(); i++) {
		tests.addElement(new UlxComposedTest(fSystem, ((Class) vector.elementAt(i))));
	}
	return tests.elements();
}
/**
 * Answer the concrete subclasses of @class.
 *
 * This method uses reflection to accomplish its task.
 */
Vector getConcreteSubclasses(Class cls) {
	Vector answer = new Vector();
	java.util.Enumeration subclasses = getSubclasses(cls).elements();
	while (subclasses.hasMoreElements()) {
		Class c = (Class) subclasses.nextElement();
		if (!Modifier.isAbstract(c.getModifiers()))
			answer.addElement(c);
	}
	return answer;
}
Class[] getJavaClasses(String[] clsNames) {
	Vector classes = new Vector();
	for (int i = 0; i < clsNames.length; i++) {
		try {
			Class cls = Class.forName(clsNames[i]);
			classes.addElement(cls);
		} catch (Throwable t) {
		}
	}
	Class[] answer = new Class[classes.size()];
	classes.copyInto(answer);
	return answer;
}
/**
 * Update the tested testComponent's implementation now.
 * 
 */
private String getRunItSource(UlxTest test) {
	return 	"	boolean result = false;\n" + 
			"	testStarted(\"" + test.getQualifiedClassName() + "\");\n" +
			"	//boolean result = callingLocalTestRoutine();\n" +
			"	testCompleted(result);\n" +
			"	return result;\n";
}
/**
 * Answer the subclasses of @class.
 *
 * This method uses reflection to accomplish its task.
 */
Vector getSubclasses(Class cls) {
	java.util.Vector subClasses = new java.util.Vector();
	CgClassDescription c = new CgClassDescription(cls);
	return c.allSubclasses();
}
Vector getTestedAPI() {
	if (fTestedAPI == null) {
		fTestedAPI = new Vector(0);
		java.util.Enumeration classes = getSubclasses(UlxControlViewAbstract.class).elements();
		while (classes.hasMoreElements()) {
			String[] api = (String[]) UlxMessage.invoke((Class) classes.nextElement(), "testedAPI", new Object[0], new String[0]);
			UlxCollection.addUnique(fTestedAPI, api);
		}
	}
	return fTestedAPI;
}
String[] getTestedApiFor(String[] classNames) {
	Vector temp = new Vector(0);
	for (int i = 0; i < classNames.length; i++) {
		Class cls = getClassForName(classNames[i]);
		if (cls != null)
			getTestedApiFor(cls, temp);
	}
	String[] answer = new String[temp.size()];
	temp.copyInto(answer);
	return answer;
}
void getTestedApiFor(Class cls, Vector vector) {
	Method[] methods = cls.getMethods();
	for (int i = 0; i < methods.length; i++) {
		if (getTestedAPI().contains(methods[i].getName())) {
			if (!vector.contains(methods[i].getName()))
				vector.addElement(methods[i].getName());
		};
	}
}
Vector getTestedClasses() {
	if (fTestedClasses == null) {
		fTestedClasses = new Vector(0);
		java.util.Enumeration classes = getSubclasses(UlxTestedViewAbstract.class).elements();
		while (classes.hasMoreElements()) {
			Class c = (Class) classes.nextElement();
			String[] clsNames = (String[]) UlxMessage.invoke(c, "testedClasses", new Object[0], new String[0]);
			UlxCollection.addUnique(fTestedClasses, clsNames);
		}
	}
	return fTestedClasses;
}
com.ibm.ivj.util.base.Workspace getWorkspace() {
	try {
		return ToolEnv.connectToWorkspace();
	}
	catch (Throwable t) {
		return null;
	}
}
/**
 * Open an Inspector on @object.
 */
protected void inspect(Object object) {
	DebugSupport.inspect(object);
}
/**
 * Answer true
 */
static public boolean isRunningVaj() {
	return true;
}
void openBrowser(String typeName) {
	Type type = getWorkspace().loadedTypeNamed(typeName);
	if (type != null) {
		try {
			type.openBrowser();
		}
		catch (Throwable t) {
		}
	}
}
/**
 * Open a composition editor on @composite.
 *
 * Currently this feature is not available. Do nothing
 */
protected void openBrowserOn(UlxAbstractTestComposite composite) {
	openBrowserOn(composite.getClass());
}
/**
 * Open a composition editor on @composite.
 *
 * Currently this feature is not available. Do nothing
 */
public void openBrowserOn(Class theClass) {
	openBrowser(theClass.getName());
}
/**
 * Open a composition editor on @composite.
 *
 * Currently this feature is not available. Do nothing
 */
public String promptForPackageName(String defaultName) {
	return CgPackageDescription.promptForPackageName(defaultName);
}
private void readClass(Class cls, CgClassDescription clsDescription) {
	java.lang.reflect.Field[] fields = cls.getDeclaredFields();
	for (int i = 0; i < fields.length; i++) {
		java.lang.reflect.Field field = fields[i];
		clsDescription.addField(field.getName(), field.getType(), field.getModifiers(), null);
	}
	Class[] interfaces = cls.getInterfaces();
	for (int i = 0; i < interfaces.length; i++) {
		clsDescription.addInterface(interfaces[i]);
	}
}
/**
 * Add the static packageName method to clsDescription only if it has changed.
 * 
 */
private boolean setRunItMethod(CgClassDescription clsDescription, UlxTest test) {
	CgMethodDescription mth = new CgMethodDescription("runIt", boolean.class);
	mth.addParameter("visibly", boolean.class);
	mth.setModifiers(java.lang.reflect.Modifier.PUBLIC);
	mth.setMethodBody(getRunItSource(test));
	clsDescription.addMethod(mth);
	return true;
}
/**
 * Add the static packageName method to clsDescription only if it has changed.
 * 
 */
private boolean setStaticMethod(CgClassDescription clsDescription, UlxTest test, String methodName, String[] strings) {
	String[] current = (String[]) UlxMessage.invoke(test.getTestClass(), methodName, new Object[0], new String[0]);
	if (UlxCollection.sameContents(current, strings))
		return false;
	String source = "new String[] {";
	for (int i = 0; i < strings.length; i++) {
		if (i > 0)
			source = source + ", ";
		source = source + "\"" + strings[i] + "\"";
	}
	source = source + "};";
	return basicSetStaticMethod(clsDescription, methodName, source, String[].class);
}
/**
 * Add the static packageName method to clsDescription only if it has changed.
 * 
 */
private boolean setStaticMethod(CgClassDescription clsDescription, UlxTest test, String methodName, String string) {
	String current = (String) UlxMessage.invoke(test.getTestClass(), methodName, "");
	if (current.equals(string))
		return false;
	else
		return basicSetStaticMethod(clsDescription, methodName, toSourceString(string), String.class);
}
/**
 * Set the receiver's testSuite now
 */
void setSystem(UlxSystem system) {
	super.setSystem(system);
	fCanBrowse = (getWorkspace() != null);
}
/**
 * Update the tested testComponent's implementation now.
 * 
 */
synchronized protected boolean testChanged(UlxTest test) {
	if (!test.isComplete())
		return false;
	boolean success = false;
	CgClassDescription clsDescription;
	boolean isNew = test.isNewTest();
	if (isNew) {
		clsDescription = new CgClassDescription(test.getTestClassName(), test.getTestPackageName(), UlxAbstractTestComposite.class);
		setRunItMethod(clsDescription, test);
	}
	else {
		clsDescription = new CgClassDescription(test.getTestedClass());
		readClass(test.getTestedClass(), clsDescription);
	}
	success = updateClassDescription(clsDescription, test);
	//if (test.isNewTest())
	//	initializeBuilderMethods(clsDescription, test);
	generate(clsDescription, test);
	test.updated(success);
	if (isNew) {
		//versionAndReload(test);
		openBrowser(test.getQualifiedClassName());
		//openBrowser(UlxTestCompositeTemplate.class.getName());
	}
	return success;
}
private String toSourceString(String string) {
	if (string.length() == 0)
		return string;
	StringTokenizer tokenizer = new StringTokenizer(string, "\n");
	String answer = null;
	while (tokenizer.hasMoreTokens()) {
		if (answer == null)
			answer = "\"" + tokenizer.nextToken() + "\"";
		else
			answer = answer + " + \"\\n\" + \"" + tokenizer.nextToken() + "\"";
	};
	return answer;
}
/**
 * Update the tested testComponent's implementation now.
 * 
 */
private boolean updateClassDescription(CgClassDescription clsDescription, UlxTest test) {
	boolean answer = false;
	if (setStaticMethod(clsDescription, test, "testPackageName", test.getTestPackageName()))
		answer = true;
	if (setStaticMethod(clsDescription, test, "testDescription", test.getDescription()))
		answer = true;
	if (setStaticMethod(clsDescription, test, "testedClasses", test.getTestedClasses()))
		answer = true;
	if (setStaticMethod(clsDescription, test, "testedAPI", test.getTestedAPI()))
		answer = true;
	if (setStaticMethod(clsDescription, test, "testedPRs", test.getTestedPRs()))
		answer = true;
	if (setStaticMethod(clsDescription, test, "testCategories", test.getTestCategories()))
		answer = true;
	if (setStaticMethod(clsDescription, test, "testAuthor", test.getAuthor()))
		answer = true;
	if (setStaticMethod(clsDescription, test, "testPageTabString", test.getTestPageTabString()))
		answer = true;
	if (basicSetPrivateStaticMethod(clsDescription, "getBuilderData", getBuilderDataString(), void.class))
		answer = true;
	return answer;
}
void versionAndReload(UlxTest test) {
	Type type = getWorkspace().loadedTypeNamed(test.getQualifiedClassName());
	if (type != null) {
		try {
			type.createVersion("Newly Generated");
			type.getEdition().loadIntoWorkspace();
			type.createNewEdition();
		}
		catch (Throwable t) {
		}
	}
}
}
