package com.ibm.ulc.ui;

import javax.swing.JMenu;
public interface IMenuComponent {
/**
 * The receiver is expected to configure itself to be an item in either a menubar
 * (if @isMenuBarItem is true), or a popup menu (if @isMenuBarItem is false)
 */
void configureAsMenuBarItem(boolean isMenuBarItem);
/**
 * 
 * @param menu com.ibm.ulc.ui.UIMenu
 * @param jmenu javax.swing.JMenu
 * @param isMenuBarItem boolean
 * @param index int
 */
void insertIn(UIMenu menu, javax.swing.JMenu jmenu, boolean isMenuBarItem, int index);
/*
 * The receiver prepares its <code>JComponent</code> for display
 *
 */
void prepareForPopup();
/*
 * The receiver should add to the passed menu according to its current state.
 *
 */
void rebuildPopupMenu(JMenu menu);
/**
 * 
 * @param menu com.ibm.ulc.ui.UIMenu
 * @param jmenu javax.swing.JMenu
 * @param index int
 */
void removeFrom(UIMenu menu, javax.swing.JMenu jmenu, int index);
}
