package com.ibm.ulc.ui;

import com.ibm.ulc.base.*;
import com.ibm.ulc.util.*;
import com.ibm.ulc.comm.*;
import java.applet.*;
import java.net.*;
import java.awt.Component;
/**
 * This class is used to display a HTML page in an external web browser.
 * If the UI is being run as an Applet it causes the browser in which the
 * applet is running to display the requested page and the browserPath is ignored.
 * If not running as an applet an external web browser is launched.
 * <p>
 * <pre>
 * The rules for determining which external browser is launched is as follows:
 * 	1)	Use the browser path to launch the browser if specified.
 * 	2) 	Under Windows NT/95 and OS2 the system default HTML browser is launched if 
 *		browserPath is not specified.
 *	3) 	On other platforms if the browser path is not specified the default is to
 * 		attempt to get the system property <i>ULC.Browser</i>. If this property is not
 * 		defined then attempt to start the executable Netscape.exe which should be on 
 *		the system path.
 * </pre>
 * <p>
 * NOTE: the browser path if specified must be valid and accessible for the UI-Engine.
 */
public class UIBrowserContext extends UIComponent {
	protected UiBrowserHelper fBrowserHelper = null;
public UiBrowserHelper getBrowserHelper() {
	return fBrowserHelper;
}
public Component getComponent() {
	return null;
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	URL url = null;
	if (request.equals("showDoc")) {
		String u = args.get("url", "");
		try {
			url = new URL(u);
			String params = args.get("parm", null);
			if (params != null)
				fBrowserHelper.showDocument(url, params);
			else
				fBrowserHelper.showDocument(url);
			return;
		}
		catch (Exception e) {
			System.out.println("UIBrowserContext.handleRequest: Exception processing URL " + u);
			e.printStackTrace();
		}
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	super.restoreState(conn, args);
	ICallable ui = conn.find(Common.FACTORY_ID);
	Applet applet = null;
	if (ui != null)
		applet = (Applet) ((UI) ui).getApplet();
	String browserPath= args.get("bp", null);
	fBrowserHelper= new UiBrowserHelper(applet, browserPath);
}
}
