package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997 Object Technology International Inc.
 */
import com.ibm.ulc.ui.lists.*;
import java.awt.event.ItemListener;
import javax.swing.*;
import com.ibm.ulc.ui.dataTypes.*;
import javax.swing.plaf.*;

public class UICheckbox extends UIToggleButton {
	public UICheckbox() {
		super(true);
	}
/**
 * Configure the UIColumn to use this widget as a renderer.
 *
 * @see UIColumn#restoreState
 */
public void configureAsColumnRenderer(UIColumn column, boolean editable, IDataType dataType) {
	// we have to remove the UIComponent as a ItemListener
	// otherwise we'll get zillions of itemStateChangeEvents
 	JCheckBox c= (JCheckBox) getComponent();
 	c.removeItemListener((ItemListener) this);
	column.getTableColumn().setCellRenderer(new UiTableCellRenderer(c));
	if (editable) {
		JCheckBox checkbox= new JCheckBox();
		checkbox.setHorizontalAlignment(c.getHorizontalAlignment());
		checkbox.setVerticalAlignment(c.getVerticalAlignment());
		if (! (c.getFont() instanceof FontUIResource))		
			checkbox.setFont(c.getFont());
		if (! (c.getForeground() instanceof ColorUIResource))
			checkbox.setForeground(c.getForeground());
		if (! (c.getBackground() instanceof ColorUIResource))
			checkbox.setBackground(c.getBackground());
		column.getTableColumn().setCellEditor(new UiCellEditor(checkbox));
	}
	else
		column.getTableColumn().setCellEditor(null);
}
}
