package com.ibm.ulc.ui;

import java.lang.reflect.Method;
import java.util.*;
import java.awt.Component;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.base.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.util.Assert;
public class UIEnabler extends UIProxy implements IEnableListener, IEnableListenerTarget {
	protected Vector fTargetListeners = new Vector();
	protected boolean fLastState = true;
	private String fSetter= null;
/**
 * UIEnabler constructor comment.
 */
public UIEnabler() {
	super();
}
/**
 * Add the given component as listener, who will be informed
 * when the state of the receiver changes from enabled to disabled,
 * or vice-versa.
 *
 * @param component : The Component which will act as listener.
 */
public void addEnableListener(IEnableListenerTarget component) {
	Assert.isNotNull(component);
	if (!fTargetListeners.contains(component)) {
		fTargetListeners.addElement(component);
//		if (component instanceof IEnableListener)
//			 ((IEnableListener) component).addEnableListener(this);
		if (fSetter == null)
			component.setEnabled(shouldEnableListener());
		else
			invokeBooleanPropertySetter(component, shouldEnableListener());
	}
}
void enableListeners(boolean state) {
	Enumeration enum = fTargetListeners.elements();
	while (enum.hasMoreElements()) {
		IEnableListenerTarget c = (IEnableListenerTarget) enum.nextElement();
		if (c != this)
			if (fSetter == null)
				c.setEnabled(state);
			else
				invokeBooleanPropertySetter(c, state);
	}
}
public void free() {
	fTargetListeners.removeAllElements();
	super.free();
}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request write a message out on the console.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setSetter")) {
		if (args.isDefined("setter"))
			setSetter(args.get("setter", ""));
		else
			setSetter(null);
		return;
	}
	else
		super.handleRequest(conn, request, args);
}
protected void invokeBooleanPropertySetter(Object c, boolean state) {
	Method method= null;
	try {
		method= c.getClass().getMethod(fSetter, new Class[] {boolean.class});
	} catch (NoSuchMethodException ex) {
		System.err.println("--------------------------------------------------------");
		System.err.println("Error: " + c.getClass().getName() + " does not support " + fSetter);
		ex.printStackTrace(System.err);		
		System.err.println("--------------------------------------------------------");
		return;	//do nothing
	}
	try {
		method.invoke(c, new Object[] {new Boolean(state)});
	} catch (IllegalAccessException ex) {
		System.err.println("--------------------------------------------------------");
		System.err.println("Illegal access while invoking " + fSetter);
		ex.printStackTrace(System.err);		
		System.err.println("--------------------------------------------------------");
	} catch (java.lang.reflect.InvocationTargetException ex) {
		System.err.println("--------------------------------------------------------");
		System.err.println("InvocationTargetException while invoking " + fSetter);
		System.err.println("The original exception is:");
		ex.getTargetException().printStackTrace(System.out);
		System.err.println("--------------------------------------------------------");
	}
}
/**
 * remove the given component as listener from being informed
 * when the state of the receiver changes from enabled to disabled,
 * or vice-versa.
 *
 * @param component : The Component which will act as listener.
 */
public void removeEnableListener(IEnableListenerTarget component) {
	Assert.isNotNull(component);
	fTargetListeners.removeElement(component);
	if (component instanceof IEnableListener)
		 ((IEnableListener) component).removeEnableListener(this);
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	if (args.isDefined("setter"))
		fSetter= args.get("setter", "");
	super.restoreState(conn, args);		
}
/**
 * Set the receiver as enabled/disabled.
 */
public void setEnabled(boolean state) {
	boolean b = shouldEnableListener();
	if (fLastState != b) {
		fLastState = b;
		enableListeners(b);
	}
}
/**
 * Set the method name of the boolean setter
 */
protected void setSetter(String setter) {
	if (fSetter != setter) {
		fSetter= setter;
		enableListeners(fLastState);
	}
}
/**
 * Return true if the component for which I am an enabler should be enabled.
 *
 */
public boolean shouldEnableListener() {
	return false;
}
}
