package com.ibm.ulc.ui;

/*
 * Copyright (c) 1997 Object Technology International Inc.
 */
import java.awt.*;
import javax.swing.*;
import java.awt.event.*;
import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;
import com.ibm.ulc.ui.base.*;
public class UIMenuItem extends UIComponent implements ActionListener, IMenuComponent {
	protected JMenuItem fMenuItem = null;
	private boolean fVisible = true;
	protected UITrigger fTrigger = null;
public void actionPerformed(ActionEvent e) {
	sendEventULC("action", "cmd", new Anything(e.getActionCommand()));
	if (fTrigger != null)
		fTrigger.trigger(fConnection, TRIGGER_ON_ACTION_AND_SELECTION, this, null);
}
/**
 * The receiver is expected to configure itself to be an item in either a menubar
 * (if @isMenuBarItem is true), or a popup menu (if @isMenuBarItem is false). 
 */
public void configureAsMenuBarItem(boolean isMenuBarMenu) {
}
	public void free() {
		if (fMenuItem != null) {
			fMenuItem.removeAll();
			fMenuItem.removeActionListener(this);
			fMenuItem= null;
		}	
		setIcon(null);
		super.free();
	}
	public Component getComponent() {
	    return fMenuItem;
	}
/**
 * The ULC application has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("setIcon")) {
		setIcon((UIIcon) getManaged(UIIcon.class, conn, args));
		return;
	}
	if (request.equals("setAccelerator")) {
		setAccelerator(args);
		return;
	}
	if (request.equals("setMnemonic")) {
		setMnemonic(args.asInt(-1));
		return;
	}
	if (request.equals("setTrigger")) {
		if (args.isNull())
			fTrigger = null;
		else
			fTrigger = (UITrigger) getManaged(UITrigger.class, conn, args);
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * The receiver is expected to insert itself in both the UIMenu and its associated JMenu.
 * if <code>isMenuBarItem</code> is true, the receiver is expected to configure itself properly as
 * such. <code>index</code> indicates at which offset into <code>jmenu</code> the receiver is to be inserted.
 *
 * @param menu		the UIMenu into which the receiver is to be inserted
 * @param jmenu		the physical JMenu into which the receiver's compoennt is to be inserted
 * @param isMenuBarItem indicates whether <code>menu</code> is a menubar menu
 * @param index		the index at which the receiver is to be inserted into <code>menu</menu>
 *
 */
public void insertIn(UIMenu menu, JMenu jmenu, boolean isMenuBarMenu, int index) {
	jmenu.insert((JMenuItem) getComponent(), index);
}
/*
 * The receiver prepares its <code>JComponent</code> for display
 *
 */public void prepareForPopup() {
}
/**
 * Insert the method's description here.
 * Creation date: (10/15/99 11:28:57 AM)
 * @param menu javax.swing.JMenu
 */
public void rebuildPopupMenu(JMenu menu) {
	if (fVisible)
		menu.add(getComponent());
}
/**
 * The receiver is expected to remove itself from @jmenu (the associated menu of @menu).
 * @index indicates at which offset into @jmenu the receiver currently is.
 */
public void removeFrom(UIMenu menu, JMenu jmenu, int index) {
	if (jmenu != null)
		jmenu.remove((JMenuItem) getComponent());
}
/**
 * This method is the first method called after this widget is instantiated.
 * All widget specific initialization must take place in this method.
 * All the parameters necessary to initialize this widget are specified in the arguments.
 * Subclasses implementing this method must call the superclass implementation as well.
 *
 * @param conn 		the <code>UlcConnection</code> in which this operation is performed
 * @param args		the <code>Anything</code> containing the optional initialization parameters
 */
public void restoreState(ORBConnection conn, Anything args) {
	setComponent(conn, args);
	super.restoreState(conn, args);
	if (args.isDefined("accelerator"))
		setAccelerator(args.get("accelerator"));
	String label = args.get("label", "no label");
	UiLabelAndMnemonic u = internalParseLabelForMnemonic(label);
	label = u.fLabel;
	if (u.fMnemonic != null)
		setMnemonic(u.fMnemonic.charValue());
	if (args.isDefined("mnemonic"))
		setMnemonic(args.get("mnemonic", -1));
	UIIcon icon = (UIIcon) getManaged(UIIcon.class, conn, args.get("icon"));
	if (icon != null) {
		setIcon(icon);
		if (!label.equals("")) {
			fMenuItem.setText(label);
			fMenuItem.setHorizontalTextPosition(JButton.RIGHT);
		}
	} else
		fMenuItem.setText(label);
	fTrigger = (UITrigger) getManaged(UITrigger.class, conn, args.get("trigger"));
}
/* valid modifiers are:
 * InputEvent.SHIFT_MASK=1
 * InputEvent.CTRL_MASK=2
 * InputEvent.META_MASK=4
 * InputEvent.ALT_MASK=8
*/
	private void setAccelerator(Anything args) {
		int keyCode= args.get("keyCode", -1);
		if (keyCode != -1)
			fMenuItem.setAccelerator(KeyStroke.getKeyStroke(keyCode,
						args.get("modifier", InputEvent.ALT_MASK),
						args.get("onKeyRelease", true)));
	}
protected void setComponent(ORBConnection conn, Anything args) {
	fMenuItem = new JMenuItem() {
		public JToolTip createToolTip() {
			return new UiJMultiLineToolTip();
		}
	};
	fMenuItem.addActionListener(this);
}
private void setIcon(UIIcon icon) {
	if (icon != null) {
		Image image = icon.getImage(this, "setIcon");
		if (image != null) {
			ImageIcon imageIcon = new ImageIcon(image); // 041
			if (imageIcon != null) {
				fMenuItem.setIcon(imageIcon);
			}
			/*else
			trouble("setIcon", "imageIcon is null");*/
		}
	}
	/*else {
		fMenuItem.setIcon(null);
	}*/
}
	public void setLabel(String label) {
		if (fMenuItem != null)
			fMenuItem.setText(label);
	}
	private void setMnemonic(int keyCode) {
		if (keyCode != -1)
			fMenuItem.setMnemonic((char)keyCode);
	}
/**
 * Set the component to be visible or hidden.
 * 
 */
public void setVisible(boolean visible) {
	if (fVisible != visible) {
		fVisible = visible;
		if (getProxyParent() != null)
			 ((UIMenu) getProxyParent()).setVisible(this, visible);
	}
}
public void updateCachedResource(String methodName, ICachedResource resource, Object userData) {
	if (methodName.equals("setIcon")) {
		UIIcon icon = (UIIcon) resource;
		setIcon(icon);
		getBasicComponent().invalidate();
		forceFramePack();
		return;
	}
	super.updateCachedResource(methodName, resource, userData);
}
}
