package com.ibm.ulc.ui;

import java.awt.Component;
import java.awt.Cursor;
import javax.swing.*;

public class UiJPanel extends javax.swing.JPanel {
/**
 * UiJPanel constructor comment.
 */
public UiJPanel() {
	super();
}
/**
 * UiJPanel constructor comment.
 * @param layout java.awt.LayoutManager
 */
public UiJPanel(java.awt.LayoutManager layout) {
	super(layout);
}
/**
 * UiJPanel constructor comment.
 * @param layout java.awt.LayoutManager
 * @param isDoubleBuffered boolean
 */
public UiJPanel(java.awt.LayoutManager layout, boolean isDoubleBuffered) {
	super(layout, isDoubleBuffered);
}
/**
 * UiJPanel constructor comment.
 * @param isDoubleBuffered boolean
 */
public UiJPanel(boolean isDoubleBuffered) {
	super(isDoubleBuffered);
}
public JToolTip createToolTip() {
	return new UiJMultiLineToolTip();
}
public void setCursor(Cursor cursor) {
	super.setCursor(cursor);
	Component comps[] = getComponents();
	for (int i = 0; i < comps.length; i++) {
		Component c = comps[i];
		c.setCursor(cursor);
	}
}
public void setEnabled(boolean state) {
	super.setEnabled(state);
	Component comps[] = getComponents();
	for (int i = 0; i < comps.length; i++) {
		Component c = comps[i];
		c.setEnabled(state);
	}
	Component parent = getParent();
	if (parent != null) { //calling invalidate here causes layout problems.
		parent.repaint();
	}
}
public void setToolTipText(String text) {
	super.setToolTipText(text);
	Component comps[] = getComponents();
	for (int i = 0; i < comps.length; i++) {
		Component c = comps[i];
		if (c instanceof JComponent)
			((JComponent)c).setToolTipText(text);
	}
}
}
