package com.ibm.ulc.ui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
public class UiJTabbedPane extends javax.swing.JTabbedPane implements ComponentListener {
	protected boolean fFirstResize= true;
/**
 * UiJTabbedPane constructor comment.
 */
public UiJTabbedPane() {
	super();
	addComponentListener(this);
}
/**
 * UiJTabbedPane constructor comment.
 * @param tabPlacement int
 */
public UiJTabbedPane(int tabPlacement) {
	super(tabPlacement);
	addComponentListener(this);
}
/**
 * Invoked when component has been hidden.
 */
public void componentHidden(ComponentEvent e) {
}
/**
 * Invoked when component has been moved.
 */
public void componentMoved(ComponentEvent e) {
}
/**
 * Invoked when component has been resized.
 */
public void componentResized(ComponentEvent e) {
	if (fFirstResize) { //1FBNKGZ
		fFirstResize = false;
		Component p = getParent();
		p.invalidate();
		p.validate();
	}
}
/**
 * Invoked when component has been shown.
 */
public void componentShown(ComponentEvent e) {
}
public JToolTip createToolTip() {
	return new UiJMultiLineToolTip();
}
public void setCursor(Cursor cursor) {
	super.setCursor(cursor);
	Component comps[] = getComponents();
	for (int i = 0; i < comps.length; i++) {
		Component c = comps[i];
		c.setCursor(cursor);
	}
}
public void setEnabled(boolean state) {
	super.setEnabled(state);
	for (int i = 0; i < getTabCount(); i++)
		setEnabledAt(i, state);
	Component comps[] = getComponents();
	for (int i = 0; i < comps.length; i++) {
		Component c = comps[i];
		c.setEnabled(state);
	}
	Component parent = getParent();
	if (parent != null) {
		parent.invalidate();
		parent.validate();
		parent.repaint();
	}
}
}
