package com.ibm.ulc.ui.lists;

/*
 * Copyright (c) 1997 Object Technology International Inc.
 */

import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import com.ibm.ulc.ui.base.*;

class UiListCellRenderer implements ListCellRenderer, IAboutToPaintListener {
	protected Component fRendererComponent= null;
	protected Object fCell= null;
	protected IJList fList= null;
	protected int fRow;
	protected String fColId = null;
public UiListCellRenderer(Component comp) {
	fRendererComponent = comp;
}
public UiListCellRenderer(Component comp, String colId) {
	fRendererComponent = comp;
	fColId = colId;
}
public void aboutToPaint() {
	if (fList != null && fCell instanceof InvalidCell)
		fList.requestValue(fRow, fColId);
}
public void free() {
	if (fRendererComponent != null) {
		((Container) fRendererComponent).removeAll();
		fRendererComponent = null;
	}
	fCell = null;
	fList = null;
}
public Component getComponent() {
	return fRendererComponent;
}
public Component getListCellRendererComponent(JList list, Object o, int row, boolean isSelected, boolean cellHasFocus) {
	fRow = row;
	fCell = o;
	if (list instanceof IJList) {
		fList = (IJList) list;
		//fCell = ((IJList) list).requestValue(row, fColId);
	}
	else
		fList = null;
	if (fRendererComponent != null && fRendererComponent instanceof IRenderer) {
		IRenderer r = (IRenderer) fRendererComponent;
		r.configureAsRenderer(list, this, fCell, isSelected);
	}
	fRendererComponent.setFont(list.getFont());
	fRendererComponent.setEnabled(list.isEnabled());
	return fRendererComponent;
}
}
