package com.ibm.ulc.ui.lists;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
/**
 * PendingNode is a placeholder for TreeModel nodes.
 * It is inserted into the model when any node is expanded, 
 * and the UI is waiting for the reply from the ULC side.
 * It also need to know it's parent since the lazy-rendering
 * process needs this.
 */
import com.ibm.ulc.util.UlcHashtable;
import com.ibm.ulc.util.UlcObject;
import com.ibm.ulc.util.Anything;
public class UiRow extends UiPendingRow {
	protected UlcHashtable fEditCache = null;
/**
 * answer the receiver's object identifier (oid)
 */
public UiRow(int oid) {
	super(oid);
}
/**
 * answer the receiver's object identifier (oid)
 */
public IRow asNonPendingRow(UiItemCache cache, int oid) {
	if (fOid != oid) {
		trouble("asNonPendingRow", "this should NEVER happen");
	}
	return this;
}
/**
 * set the value of the receiver's attribute called <code>attributeName</code> to <code>value</code>
 *
 * @param attributeName		the attribute to be set is named this
 * @param value				the value of the attribute
 */
public void cancelInput(UiItemCache cache) {
	if (isEdited()) {
		java.util.Enumeration changedKeys = ((UlcHashtable) fEditCache.clone()).keys();
		while (changedKeys.hasMoreElements()) {
			resetInput(cache, (String) changedKeys.nextElement());
		}
	}
}
/**
 * answer the value of the receiver's attribute called attributeName. 
 * Answer null, if the attribute is not defined
 *
 * @param attributeName		the attribute requested is named this
 */
private Object getInputAt(String attributeName) {
	if (fEditCache == null)
		return null;
	return fEditCache.get(attributeName);
}
/**
 * answer the value of the receiver's attribute called attributeName. 
 * Answer null, if the attribute is not defined
 *
 * @param attributeName		the attribute requested is named this
 */
private Object getValueAt(String attributeName) {
	if (fData == null)
		return null;
	return fData.get(attributeName);
}
/**
 * answer the value of the receiver's attribute called attributeName. 
 * Answer null, if the attribute is not defined
 *
 * @param attributeName		the attribute requested is named this
 */
public Object getValueAt(String attributeName, UiItemCache cache) {
	Object answer;
	if (isEdited()) {
		answer = getInputAt(attributeName);
		if (answer != null || fEditCache.containsKey(attributeName)) {
			return answer;
		}
	}
	answer = super.getValueAt(attributeName, cache);
	return answer;
}
/**
 * answer the receiver's object identifier (oid)
 */
public boolean hasUnsavedChanges() {
	return isEdited();
}
/**
 * answer the receiver's object identifier (oid)
 */
private boolean isEdited() {
	return fEditCache != null;
}
/**
 * set the value of the receiver's attribute called <code>attributeName</code> to <code>value</code>
 *
 * @param attributeName		the attribute to be set is named this
 * @param value				the value of the attribute
 */
private boolean isInputSameAsValue(String attributeName, Object input) {
	Object value = getValueAt(attributeName);
	boolean answer = false;
	if (value == null || input == null) {
		answer = (input == value);
	}
	else {
		answer = input.equals(value);
	}
	return answer;
}
public void prepareChanges(UITableModel model, Anything rowIds, Anything changes) {
	if (!isEdited())
		return;
	boolean veto = model.fVetoChanges;
	Anything columns = new Anything();
	java.util.Enumeration changedKeys = fEditCache.keys();
	while (changedKeys.hasMoreElements()) {
		Anything attributeAny = new Anything();
		String attribute = (String) changedKeys.nextElement();
		Object value = fEditCache.get(attribute);
		attributeAny.put("colId", attribute);
		attributeAny.put("value", model.convert(value));
		columns.append(attributeAny);
		if (!veto) {
			fData.put(attribute, value);
		}
	}
	Anything answer = new Anything();
	answer.put("cols", columns);
	changes.append(answer);
	rowIds.append(new Anything(getOid()));
}
/**
 * the receiver is about to be replaced by <code>anotherRow</code>. update it if required
 *
 * @param anotherRow the row about to replace the receiver
 */
private void resetInput(UiItemCache cache, String attributeName) {
	if (isEdited()) {
		fEditCache.remove(attributeName);
		if (fEditCache.size() == 0) {
			fEditCache = null;
			cache.removeEdited(this);
		}
	}
}
/**
 * the receiver is about to be replaced by <code>anotherRow</code>. update it if required
 *
 * @param anotherRow the row about to replace the receiver
 */
protected void resetValue(String attributeName) {
	if (isEdited())
		fEditCache.remove(attributeName);
	super.resetValue(attributeName);
}
/**
 * answer the receiver's object identifier (oid)
 */
public void resetValues(UiItemCache cache) {
	cancelInput(cache);
	super.resetValues(cache);
}
/**
 * set the value of the receiver's attribute called <code>attributeName</code> to <code>value</code>
 *
 * @param attributeName		the attribute to be set is named this
 * @param value				the value of the attribute
 */
public void saveInput(UiItemCache cache) {
	if (isEdited()) {
		cache.saveInput(-1, new IRow[] {this});
	}
}
/**
 * set the value of the receiver's attribute called <code>attributeName</code> to <code>value</code>
 *
 * @param attributeName		the attribute to be set is named this
 * @param value				the value of the attribute
 */
public boolean setInput(UiItemCache cache, String attributeName, Object value) {
	boolean answer = false;
	if (isInputSameAsValue(attributeName, value)) {
		resetInput(cache, attributeName);
	} else {
		startEditing(cache);
		Object currentInput = fEditCache.get(attributeName);
		if (currentInput == null || value == null) {
			if (getValueAt(attributeName) != null)
				answer = true;
			else
				answer = (currentInput != value);
		} else {
			answer = !currentInput.equals(value);
		}
		if (answer)
			fEditCache.put(attributeName, value);
	}
	return answer;
}
/**
 * set the value of the receiver's attribute called <code>attributeName</code> to <code>value</code>
 *
 * @param attributeName		the attribute to be set is named this
 * @param value				the value of the attribute
 */
public void setValue(UiItemCache cache, String attributeName, Object value) {
	super.setValue(cache, attributeName, value);
	resetInput(cache, attributeName);
}
/**
 * the receiver is about to be replaced by <code>anotherRow</code>. update it if required
 *
 * @param anotherRow the row about to replace the receiver
 */
public void startEditing(UiItemCache cache) {
	if (fEditCache == null) {
		fEditCache = new UlcHashtable();
		cache.startedEditing(this);
	}
}
/**
 * the receiver is about to be replaced by <code>anotherRow</code>. update it if required
 *
 * @param anotherRow the row about to replace the receiver
 */
public void updateData(UiItemCache cache, UlcHashtable data) {
	java.util.Enumeration e = data.keys();
	while (e.hasMoreElements()) {
		String key = (String) e.nextElement();
		setValue(cache, key, data.get(key));
	}
}
}
