package com.ibm.ulc.vaedit;

import com.ibm.uvm.abt.edit.*;
import javax.swing.*;
public class ULCIconEditor implements java.beans.PropertyEditor {
	private static java.util.ResourceBundle resabtedit = java.util.ResourceBundle.getBundle("com/ibm/uvm/abt/edit/abtedit"); //$NON-NLS-1$
	Icon value = null;
	UlcIconCustomEditor customEditor = null;
	protected transient java.beans.PropertyChangeSupport propertyChange = new java.beans.PropertyChangeSupport(this);
	private boolean customEditorURLChoiceEnabled = true;
	private boolean MakeFilePathRelative = true;
	private boolean fCachedOnUI = false;
	private static final String genSep = "/"; //$NON-NLS-1$;
/**
 * UlcIconEditor constructor comment.
 */
public ULCIconEditor() {
	super();
}
	public void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
		propertyChange.addPropertyChangeListener(listener);
	}
	public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
		propertyChange.firePropertyChange(propertyName, oldValue, newValue);
	}
	public String getAsText() {
		String result = resabtedit.getString("Unknown_Source"); //$NON-NLS-1$
		if (value instanceof NamedImageIcon) {
			result = ((NamedImageIcon) value).getSourceName();
		} else
			if (value == null) {
				result = null;
			}
		return result;
	}
	public java.awt.Component getCustomEditor() {
		if (customEditor == null) {
			customEditor = new UlcIconCustomEditor(this);
		}
		return customEditor;
	}
	/**
	 * This method was created in VisualAge.
	 * @return boolean
	 */
	public boolean getCustomEditorURLChoiceEnabled() {
		return customEditorURLChoiceEnabled;
	}
public String getJavaInitializationString() {
	String result = "???";//$NON-NLS-1$
	javax.swing.Icon val= (javax.swing.Icon)getValue();
	
	if (val != null && val instanceof com.ibm.uvm.abt.edit.NamedImageIcon) {
		com.ibm.uvm.abt.edit.NamedImageIcon imageIcon = (com.ibm.uvm.abt.edit.NamedImageIcon)val;
	
		int source = imageIcon.getSource();
		String newString = "new ULCIcon(";//$NON-NLS-1$
		if (source == NamedImageIcon.FILE) {
			String filename = null;
			imageIcon.getSourceName();
			if (getMakeFilePathRelative()) {
				filename = imageIcon.getResourceName();
				result = newString + "getClass().getResource(\"" + filename+"\")"+ ", " + fCachedOnUI+")";//$NON-NLS-2$//$NON-NLS-1$
			} else {
				filename = imageIcon.getSourceName();
				result = newString + "\"" + filename+"\")"+ ", " + fCachedOnUI+")";//$NON-NLS-2$//$NON-NLS-1$
			}
		}	
		else if (source == NamedImageIcon.URL)
			result = newString + 
				"new java.net.URL(\""+imageIcon.getSourceName()+"\")"+ ", " + fCachedOnUI+")";//$NON-NLS-2$//$NON-NLS-1$
	}		
	return result;
}
	/**
	 * This method was created in VisualAge.
	 * @return boolean
	 */
	public boolean getMakeFilePathRelative() {
		return MakeFilePathRelative;
	}
	public java.lang.String[] getTags() {
		return null;
	}
	public Object getValue() {
		return value;
	}
public boolean isCachedOnUI() {
	return fCachedOnUI;
}
	public boolean isPaintable() {
		return false;
	}
	public void paintValue(java.awt.Graphics gfx, java.awt.Rectangle box) {
	}
	public void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
		propertyChange.removePropertyChangeListener(listener);
	}
	public void setAsText(String text) throws IllegalArgumentException {
		setValue(text);
	}
public void setCachedOnUI(boolean isCachedOnUI) {
	boolean oldCache = fCachedOnUI;
	fCachedOnUI = isCachedOnUI;
	if (value instanceof UlcNamedImageIcon)
		 ((UlcNamedImageIcon) value).setCachedOnUI(fCachedOnUI);
	else
		if (oldCache != isCachedOnUI) {
			// We've switched the flag, but we don't have a ulc named image icon
			// so we will create one so that the flag can be saved across invokations.
			if (value instanceof NamedImageIcon) {
				// We can only work with a named image icon. If it is null or just Icon,
				// we can't set the cache flag. Shouldn't happen though, but just in case.
				setValue(UlcNamedImageIcon.create((NamedImageIcon) value, fCachedOnUI));
			}
		}
}
	/**
	 * This method was created in VisualAge.
	 * @param newValue boolean
	 */
	public void setCustomEditorURLChoiceEnabled(boolean newValue) {
		customEditorURLChoiceEnabled = newValue;
		if (customEditor != null)
			customEditor.setURLChoiceEnabled(newValue);
	}
	/**
	 * This method was created in VisualAge.
	 * @param newValue boolean
	 */
	public void setMakeFilePathRelative(boolean newValue) {
		MakeFilePathRelative = newValue;
	}
public void setValue(Object newValue) {
	Icon oldValue = value;
	if (newValue instanceof String) {
		value = new UlcNamedImageIcon((String) newValue, fCachedOnUI);
	} else
		if (newValue instanceof java.net.URL) {
			value = new UlcNamedImageIcon((java.net.URL) newValue, fCachedOnUI);
		} else {
			if (newValue instanceof UlcNamedImageIcon)
				fCachedOnUI = ((UlcNamedImageIcon) newValue).getCachedOnUI();
			value = (Icon) newValue;
		}
	firePropertyChange("value", oldValue, value); //$NON-NLS-1$
}
	public boolean supportsCustomEditor() {
		return true;
	}
}
