package com.ibm.ulc.vaedit;

import java.awt.event.*;
import javax.swing.*;
import java.awt.*;
import java.text.*;
import java.util.*;
import com.ibm.ulc.application.*;
/**
 * Custom editor for selecting the accelerator to use
 * Creation date: (08-20-99 11:06:54 AM)
 * @author: Richard Kulp
 */

public class UlcAcceleratorCustomEditor extends JPanel {
	private JPanel ivjCharacterEntryPanel = null;
	private JTextField ivjCharacterField = null;
	private JLabel ivjCharacterLabel = null;
	private JRadioButton ivjKeyCharacterRadio = null;
	private JPanel ivjKeyEntryPanel = null;
	private JRadioButton ivjKeyPressRadio = null;
	private JPanel ivjKeyReleasePanel = null;
	private JRadioButton ivjKeyReleaseRadio = null;
	private JPanel ivjKeyTypeSelectionPanel = null;
	private GridLayout ivjKeyTypeSelectionPanelGridLayout = null;
	private JRadioButton ivjKeyVirtualRadio = null;
	private static java.util.ResourceBundle resUlcVaEdit = java.util.ResourceBundle.getBundle("UlcVaEdit"); //$NON-NLS-1$;
	private ButtonGroup ivjKeyReleaseGroup = null;
	private ButtonGroup ivjKeyTypeGroup = null;
	private JPanel ivjSeparator = null;
	private JPanel ivjKeyPanel = null;
	// The sorted list of Virtual Keys (In the current Locale)
	private static Vector fVirtualKeysLocalized;
	// The lookup table of localized virtual keys to actual value
	private static Hashtable fVirtualKeysLookup;
	private JCheckBox ivjCtrlCheck = null;
	private JCheckBox ivjMetaCheck = null;
	private JPanel ivjModifierPanel = null;
	private JCheckBox ivjShiftCheck = null;
	private JCheckBox ivjAltCheck = null;
	private ULCAccelerator fAccelerator = null;
	private JRadioButton ivjNoAccelRadio = null;
	private JPanel ivjNoCharactersPanel = null;
	IvjEventHandler ivjEventHandler = new IvjEventHandler();
	private JList ivjVirtualKeyListbox = null;
	private JScrollPane ivjVirtualScrollPane = null;

class IvjEventHandler implements java.awt.event.ComponentListener, java.awt.event.ItemListener {
		public void componentHidden(java.awt.event.ComponentEvent e) {};
		public void componentMoved(java.awt.event.ComponentEvent e) {};
		public void componentResized(java.awt.event.ComponentEvent e) {};
		public void componentShown(java.awt.event.ComponentEvent e) {
			if (e.getSource() == UlcAcceleratorCustomEditor.this.getCharacterEntryPanel()) 
				connEtoM1(e);
			if (e.getSource() == UlcAcceleratorCustomEditor.this.getVirtualScrollPane()) 
				connEtoM2(e);
		};
		public void itemStateChanged(java.awt.event.ItemEvent e) {
			if (e.getSource() == UlcAcceleratorCustomEditor.this.getNoAccelRadio()) 
				connEtoC1(e);
		};
	};
/**
 * UlcAcceleratorCustomEditor constructor comment.
 */
public UlcAcceleratorCustomEditor() {
	super();
	initialize();
}
/**
 * UlcAcceleratorCustomEditor constructor comment.
 */
public UlcAcceleratorCustomEditor(ULCAccelerator anAccel) {
	super();
	initialize();
	setAcceleratorValue(anAccel);
}
/**
 * connEtoC1:  (NoAccelRadio.item.itemStateChanged(java.awt.event.ItemEvent) --> UlcAcceleratorCustomEditor.noAccelRadio_ItemStateChanged(Ljava.awt.event.ItemEvent;)V)
 * @param arg1 java.awt.event.ItemEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoC1(java.awt.event.ItemEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		this.noAccelRadio_ItemStateChanged(arg1);
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * connEtoM1:  (CharacterEntryPanel.component.componentShown(java.awt.event.ComponentEvent) --> CharacterEntryPanel.requestDefaultFocus()Z)
 * @return boolean
 * @param arg1 java.awt.event.ComponentEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private boolean connEtoM1(java.awt.event.ComponentEvent arg1) {
	boolean connEtoM1Result = false;
	try {
		// user code begin {1}
		// user code end
		connEtoM1Result = getCharacterEntryPanel().requestDefaultFocus();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
	return connEtoM1Result;
}
/**
 * connEtoM2:  (VirtualScrollPane.component.componentShown(java.awt.event.ComponentEvent) --> VirtualKeyListbox.requestFocus()V)
 * @param arg1 java.awt.event.ComponentEvent
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void connEtoM2(java.awt.event.ComponentEvent arg1) {
	try {
		// user code begin {1}
		// user code end
		getVirtualKeyListbox().requestFocus();
		// user code begin {2}
		// user code end
	} catch (java.lang.Throwable ivjExc) {
		// user code begin {3}
		// user code end
		handleException(ivjExc);
	}
}
/**
 * Get the new ULCAccelerator from the editor.
 * Creation date: (08-23-99 4:00:38 PM)
 */
public ULCAccelerator getAcceleratorValue() {
	if (getNoAccelRadio().isSelected())
		return null;
	else {
		int keyCode;
		if (getKeyCharacterRadio().isSelected()) {
			// We have a specific character.
			String keyString = getCharacterField().getText();
			if (keyString.length() == 0)
				return null; // There was no character, so still nothing
			keyCode = keyString.charAt(0);
		} else {
			// We have a virtual key
			keyCode = ((Integer) fVirtualKeysLookup.get(getVirtualKeyListbox().getSelectedValue())).intValue();
		}

		// Now check on the modifiers
		int modifiers = 0;
		if (getAltCheck().isSelected())
			modifiers += KeyEvent.ALT_MASK;
		if (getCtrlCheck().isSelected())
			modifiers += KeyEvent.CTRL_MASK;
		if (getMetaCheck().isSelected())
			modifiers += KeyEvent.META_MASK;
		if (getShiftCheck().isSelected())
			modifiers += KeyEvent.SHIFT_MASK;

		// Now the key release flag
		boolean onKeyRelease = getKeyReleaseRadio().isSelected();
		return ULCAccelerator.getAccelerator(keyCode, modifiers, onKeyRelease);
	}
}
/**
 * Return the AtlCheck property value.
 * @return javax.swing.JCheckBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JCheckBox getAltCheck() {
	if (ivjAltCheck == null) {
		try {
			ivjAltCheck = new javax.swing.JCheckBox();
			ivjAltCheck.setName("AltCheck");
			ivjAltCheck.setToolTipText(resUlcVaEdit.getString("accel.custom.ModifierToolTip"));
			ivjAltCheck.setMnemonic('a');
			ivjAltCheck.setText("AltCheck");
			// user code begin {1}
			ivjAltCheck.setText(Toolkit.getProperty("AWT.alt", "Alt"));
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjAltCheck;
}
/**
 * Return the CharacterEntryPanel property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getCharacterEntryPanel() {
	if (ivjCharacterEntryPanel == null) {
		try {
			ivjCharacterEntryPanel = new javax.swing.JPanel();
			ivjCharacterEntryPanel.setName("CharacterEntryPanel");
			ivjCharacterEntryPanel.setLayout(new java.awt.GridBagLayout());

			java.awt.GridBagConstraints constraintsCharacterLabel = new java.awt.GridBagConstraints();
			constraintsCharacterLabel.gridx = 0; constraintsCharacterLabel.gridy = 0;
			constraintsCharacterLabel.anchor = java.awt.GridBagConstraints.NORTHWEST;
			constraintsCharacterLabel.insets = new java.awt.Insets(10, 10, 4, 4);
			getCharacterEntryPanel().add(getCharacterLabel(), constraintsCharacterLabel);

			java.awt.GridBagConstraints constraintsCharacterField = new java.awt.GridBagConstraints();
			constraintsCharacterField.gridx = 0; constraintsCharacterField.gridy = 1;
			constraintsCharacterField.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsCharacterField.anchor = java.awt.GridBagConstraints.WEST;
			constraintsCharacterField.weightx = 1.0;
			constraintsCharacterField.insets = new java.awt.Insets(10, 10, 4, 4);
			getCharacterEntryPanel().add(getCharacterField(), constraintsCharacterField);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjCharacterEntryPanel;
}
/**
 * Return the CharacterField property value.
 * @return javax.swing.JTextField
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JTextField getCharacterField() {
	if (ivjCharacterField == null) {
		try {
			ivjCharacterField = new javax.swing.JTextField();
			ivjCharacterField.setName("CharacterField");
			ivjCharacterField.setDocument(new com.ibm.ulc.vaedit.UlcAcceleratorEditorDocument());
			ivjCharacterField.setColumns(1);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjCharacterField;
}
/**
 * Return the CharacterLabel property value.
 * @return javax.swing.JLabel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JLabel getCharacterLabel() {
	if (ivjCharacterLabel == null) {
		try {
			ivjCharacterLabel = new javax.swing.JLabel();
			ivjCharacterLabel.setName("CharacterLabel");
			ivjCharacterLabel.setText(resUlcVaEdit.getString("accel.custom.CharacterLabel"));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjCharacterLabel;
}
/**
 * Return the CtrlCheck property value.
 * @return javax.swing.JCheckBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JCheckBox getCtrlCheck() {
	if (ivjCtrlCheck == null) {
		try {
			ivjCtrlCheck = new javax.swing.JCheckBox();
			ivjCtrlCheck.setName("CtrlCheck");
			ivjCtrlCheck.setToolTipText(resUlcVaEdit.getString("accel.custom.ModifierToolTip"));
			ivjCtrlCheck.setMnemonic('l');
			ivjCtrlCheck.setText("CtrlCheck");
			// user code begin {1}
			ivjCtrlCheck.setText(Toolkit.getProperty("AWT.control", "Ctrl"));
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjCtrlCheck;
}
/**
 * Return the KeyCharacterRadio property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JRadioButton getKeyCharacterRadio() {
	if (ivjKeyCharacterRadio == null) {
		try {
			ivjKeyCharacterRadio = new javax.swing.JRadioButton();
			ivjKeyCharacterRadio.setName("KeyCharacterRadio");
			ivjKeyCharacterRadio.setToolTipText(resUlcVaEdit.getString("accel.custom.KeyTypeSelectionToolTip"));
			ivjKeyCharacterRadio.setMnemonic('C');
			ivjKeyCharacterRadio.setText(resUlcVaEdit.getString("accel.custom.KeyCharacterRadio"));
			ivjKeyCharacterRadio.setActionCommand("CharacterEntryPanel");
			ivjKeyCharacterRadio.setSelected(false);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjKeyCharacterRadio;
}
/**
 * Return the KeyEntryPanel property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getKeyEntryPanel() {
	if (ivjKeyEntryPanel == null) {
		try {
			ivjKeyEntryPanel = new javax.swing.JPanel();
			ivjKeyEntryPanel.setName("KeyEntryPanel");
			ivjKeyEntryPanel.setLayout(new java.awt.CardLayout());
			getKeyEntryPanel().add(getNoCharactersPanel(), getNoCharactersPanel().getName());
			getKeyEntryPanel().add(getCharacterEntryPanel(), getCharacterEntryPanel().getName());
			getKeyEntryPanel().add(getVirtualScrollPane(), getVirtualScrollPane().getName());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjKeyEntryPanel;
}
/**
 * Return the KeyPanel property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getKeyPanel() {
	if (ivjKeyPanel == null) {
		try {
			ivjKeyPanel = new javax.swing.JPanel();
			ivjKeyPanel.setName("KeyPanel");
			ivjKeyPanel.setBorder(new javax.swing.border.EtchedBorder());
			ivjKeyPanel.setLayout(new java.awt.GridBagLayout());

			java.awt.GridBagConstraints constraintsKeyTypeSelectionPanel = new java.awt.GridBagConstraints();
			constraintsKeyTypeSelectionPanel.gridx = 0; constraintsKeyTypeSelectionPanel.gridy = 0;
			constraintsKeyTypeSelectionPanel.fill = java.awt.GridBagConstraints.BOTH;
			constraintsKeyTypeSelectionPanel.anchor = java.awt.GridBagConstraints.WEST;
			constraintsKeyTypeSelectionPanel.insets = new java.awt.Insets(5, 5, 0, 5);
			getKeyPanel().add(getKeyTypeSelectionPanel(), constraintsKeyTypeSelectionPanel);

			java.awt.GridBagConstraints constraintsKeyEntryPanel = new java.awt.GridBagConstraints();
			constraintsKeyEntryPanel.gridx = 1; constraintsKeyEntryPanel.gridy = 0;
			constraintsKeyEntryPanel.fill = java.awt.GridBagConstraints.HORIZONTAL;
			constraintsKeyEntryPanel.anchor = java.awt.GridBagConstraints.WEST;
			constraintsKeyEntryPanel.insets = new java.awt.Insets(0, 5, 0, 0);
			getKeyPanel().add(getKeyEntryPanel(), constraintsKeyEntryPanel);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjKeyPanel;
}
/**
 * Return the KeyPressRadio property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JRadioButton getKeyPressRadio() {
	if (ivjKeyPressRadio == null) {
		try {
			ivjKeyPressRadio = new javax.swing.JRadioButton();
			ivjKeyPressRadio.setName("KeyPressRadio");
			ivjKeyPressRadio.setSelected(true);
			ivjKeyPressRadio.setToolTipText(resUlcVaEdit.getString("accel.custom.KeyReleaseToolTip"));
			ivjKeyPressRadio.setMnemonic('P');
			ivjKeyPressRadio.setText(resUlcVaEdit.getString("accel.custom.KeyPressedRadio"));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjKeyPressRadio;
}
/**
 * Return the KeyReleaseGroup property value.
 * @return javax.swing.ButtonGroup
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.ButtonGroup getKeyReleaseGroup() {
	if (ivjKeyReleaseGroup == null) {
		try {
			ivjKeyReleaseGroup = new javax.swing.ButtonGroup();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjKeyReleaseGroup;
}
/**
 * Return the KeyReleasePanel property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getKeyReleasePanel() {
	if (ivjKeyReleasePanel == null) {
		try {
			ivjKeyReleasePanel = new javax.swing.JPanel();
			ivjKeyReleasePanel.setName("KeyReleasePanel");
			ivjKeyReleasePanel.setToolTipText(resUlcVaEdit.getString("accel.custom.KeyReleaseToolTip"));
			ivjKeyReleasePanel.setLayout(new java.awt.GridLayout());
			getKeyReleasePanel().add(getKeyPressRadio(), getKeyPressRadio().getName());
			getKeyReleasePanel().add(getKeyReleaseRadio(), getKeyReleaseRadio().getName());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjKeyReleasePanel;
}
/**
 * Return the KeyReleaseRadio property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JRadioButton getKeyReleaseRadio() {
	if (ivjKeyReleaseRadio == null) {
		try {
			ivjKeyReleaseRadio = new javax.swing.JRadioButton();
			ivjKeyReleaseRadio.setName("KeyReleaseRadio");
			ivjKeyReleaseRadio.setToolTipText(resUlcVaEdit.getString("accel.custom.KeyReleaseToolTip"));
			ivjKeyReleaseRadio.setMnemonic('r');
			ivjKeyReleaseRadio.setText(resUlcVaEdit.getString("accel.custom.KeyReleasedRadio"));
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjKeyReleaseRadio;
}
/**
 * Return the KeyTypeGroup property value.
 * @return javax.swing.ButtonGroup
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.ButtonGroup getKeyTypeGroup() {
	if (ivjKeyTypeGroup == null) {
		try {
			ivjKeyTypeGroup = new javax.swing.ButtonGroup();
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjKeyTypeGroup;
}
/**
 * Return the KeyTypeSelectionPanel property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getKeyTypeSelectionPanel() {
	if (ivjKeyTypeSelectionPanel == null) {
		try {
			ivjKeyTypeSelectionPanel = new javax.swing.JPanel();
			ivjKeyTypeSelectionPanel.setName("KeyTypeSelectionPanel");
			ivjKeyTypeSelectionPanel.setToolTipText(resUlcVaEdit.getString("accel.custom.KeyTypeSelectionToolTip"));
			ivjKeyTypeSelectionPanel.setLayout(getKeyTypeSelectionPanelGridLayout());
			getKeyTypeSelectionPanel().add(getKeyCharacterRadio(), getKeyCharacterRadio().getName());
			getKeyTypeSelectionPanel().add(getKeyVirtualRadio(), getKeyVirtualRadio().getName());
			getKeyTypeSelectionPanel().add(getNoAccelRadio(), getNoAccelRadio().getName());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjKeyTypeSelectionPanel;
}
/**
 * Return the KeyTypeSelectionPanelGridLayout property value.
 * @return java.awt.GridLayout
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private java.awt.GridLayout getKeyTypeSelectionPanelGridLayout() {
	java.awt.GridLayout ivjKeyTypeSelectionPanelGridLayout = null;
	try {
		/* Create part */
		ivjKeyTypeSelectionPanelGridLayout = new java.awt.GridLayout();
		ivjKeyTypeSelectionPanelGridLayout.setRows(3);
		ivjKeyTypeSelectionPanelGridLayout.setVgap(5);
		ivjKeyTypeSelectionPanelGridLayout.setHgap(5);
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	};
	return ivjKeyTypeSelectionPanelGridLayout;
}
/**
 * Return the KeyVirtualRadio property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JRadioButton getKeyVirtualRadio() {
	if (ivjKeyVirtualRadio == null) {
		try {
			ivjKeyVirtualRadio = new javax.swing.JRadioButton();
			ivjKeyVirtualRadio.setName("KeyVirtualRadio");
			ivjKeyVirtualRadio.setToolTipText(resUlcVaEdit.getString("accel.custom.KeyTypeSelectionToolTip"));
			ivjKeyVirtualRadio.setMnemonic('V');
			ivjKeyVirtualRadio.setText(resUlcVaEdit.getString("accel.custom.KeyVirtualRadio"));
			ivjKeyVirtualRadio.setActionCommand("VirtualScrollPane");
			ivjKeyVirtualRadio.setSelected(false);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjKeyVirtualRadio;
}
/**
 * Return the MetaCheck property value.
 * @return javax.swing.JCheckBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JCheckBox getMetaCheck() {
	if (ivjMetaCheck == null) {
		try {
			ivjMetaCheck = new javax.swing.JCheckBox();
			ivjMetaCheck.setName("MetaCheck");
			ivjMetaCheck.setToolTipText(resUlcVaEdit.getString("accel.custom.ModifierToolTip"));
			ivjMetaCheck.setMnemonic('m');
			ivjMetaCheck.setText("MetaCheck");
			// user code begin {1}
			ivjMetaCheck.setText(Toolkit.getProperty("AWT.meta", "Meta"));
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjMetaCheck;
}
/**
 * Return the ModifierPanel property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getModifierPanel() {
	if (ivjModifierPanel == null) {
		try {
			ivjModifierPanel = new javax.swing.JPanel();
			ivjModifierPanel.setName("ModifierPanel");
			ivjModifierPanel.setToolTipText(resUlcVaEdit.getString("accel.custom.ModifierToolTip"));
			ivjModifierPanel.setBorder(new javax.swing.border.EtchedBorder());
			ivjModifierPanel.setLayout(new java.awt.GridBagLayout());

			java.awt.GridBagConstraints constraintsCtrlCheck = new java.awt.GridBagConstraints();
			constraintsCtrlCheck.gridx = 0; constraintsCtrlCheck.gridy = 0;
			constraintsCtrlCheck.anchor = java.awt.GridBagConstraints.WEST;
			constraintsCtrlCheck.insets = new java.awt.Insets(2, 4, 2, 2);
			getModifierPanel().add(getCtrlCheck(), constraintsCtrlCheck);

			java.awt.GridBagConstraints constraintsAltCheck = new java.awt.GridBagConstraints();
			constraintsAltCheck.gridx = 1; constraintsAltCheck.gridy = 0;
			constraintsAltCheck.anchor = java.awt.GridBagConstraints.WEST;
			constraintsAltCheck.insets = new java.awt.Insets(2, 4, 2, 2);
			getModifierPanel().add(getAltCheck(), constraintsAltCheck);

			java.awt.GridBagConstraints constraintsShiftCheck = new java.awt.GridBagConstraints();
			constraintsShiftCheck.gridx = 0; constraintsShiftCheck.gridy = 1;
			constraintsShiftCheck.anchor = java.awt.GridBagConstraints.WEST;
			constraintsShiftCheck.insets = new java.awt.Insets(2, 4, 2, 2);
			getModifierPanel().add(getShiftCheck(), constraintsShiftCheck);

			java.awt.GridBagConstraints constraintsMetaCheck = new java.awt.GridBagConstraints();
			constraintsMetaCheck.gridx = 1; constraintsMetaCheck.gridy = 1;
			constraintsMetaCheck.insets = new java.awt.Insets(2, 4, 2, 2);
			getModifierPanel().add(getMetaCheck(), constraintsMetaCheck);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjModifierPanel;
}
/**
 * Return the NoAccelRadio property value.
 * @return javax.swing.JRadioButton
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JRadioButton getNoAccelRadio() {
	if (ivjNoAccelRadio == null) {
		try {
			ivjNoAccelRadio = new javax.swing.JRadioButton();
			ivjNoAccelRadio.setName("NoAccelRadio");
			ivjNoAccelRadio.setToolTipText(resUlcVaEdit.getString("accel.custom.NoAccelTooltip"));
			ivjNoAccelRadio.setMnemonic('n');
			ivjNoAccelRadio.setText(resUlcVaEdit.getString("accel.custom.NoAccelRadio"));
			ivjNoAccelRadio.setActionCommand("NoCharactersPanel");
			ivjNoAccelRadio.setSelected(true);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjNoAccelRadio;
}
/**
 * Return the NoCharactersPanel property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getNoCharactersPanel() {
	if (ivjNoCharactersPanel == null) {
		try {
			ivjNoCharactersPanel = new javax.swing.JPanel();
			ivjNoCharactersPanel.setName("NoCharactersPanel");
			ivjNoCharactersPanel.setLayout(null);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjNoCharactersPanel;
}
/**
 * Return the Separator property value.
 * @return javax.swing.JPanel
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JPanel getSeparator() {
	if (ivjSeparator == null) {
		try {
			ivjSeparator = new javax.swing.JPanel();
			ivjSeparator.setName("Separator");
			ivjSeparator.setBorder(new javax.swing.border.EtchedBorder());
			ivjSeparator.setLayout(null);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjSeparator;
}
/**
 * Return the ShiftCheck property value.
 * @return javax.swing.JCheckBox
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JCheckBox getShiftCheck() {
	if (ivjShiftCheck == null) {
		try {
			ivjShiftCheck = new javax.swing.JCheckBox();
			ivjShiftCheck.setName("ShiftCheck");
			ivjShiftCheck.setToolTipText(resUlcVaEdit.getString("accel.custom.ModifierToolTip"));
			ivjShiftCheck.setMnemonic('s');
			ivjShiftCheck.setText("ShiftCheck");
			// user code begin {1}
			ivjShiftCheck.setText(Toolkit.getProperty("AWT.shift", "Shift"));
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjShiftCheck;
}
/**
 * Return the VirtualKeyListbox property value.
 * @return javax.swing.JList
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JList getVirtualKeyListbox() {
	if (ivjVirtualKeyListbox == null) {
		try {
			ivjVirtualKeyListbox = new javax.swing.JList();
			ivjVirtualKeyListbox.setName("VirtualKeyListbox");
			ivjVirtualKeyListbox.setAutoscrolls(true);
			ivjVirtualKeyListbox.setVisibleRowCount(5);
			ivjVirtualKeyListbox.setBackground(java.awt.SystemColor.control);
			ivjVirtualKeyListbox.setBounds(0, 0, 100, 100);
			ivjVirtualKeyListbox.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjVirtualKeyListbox;
}
/**
 * Return the VirtualScrollPane property value.
 * @return javax.swing.JScrollPane
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private javax.swing.JScrollPane getVirtualScrollPane() {
	if (ivjVirtualScrollPane == null) {
		try {
			ivjVirtualScrollPane = new javax.swing.JScrollPane();
			ivjVirtualScrollPane.setName("VirtualScrollPane");
			ivjVirtualScrollPane.setAutoscrolls(true);
			getVirtualScrollPane().setViewportView(getVirtualKeyListbox());
			// user code begin {1}
			// user code end
		} catch (java.lang.Throwable ivjExc) {
			// user code begin {2}
			// user code end
			handleException(ivjExc);
		}
	}
	return ivjVirtualScrollPane;
}
/**
 * Called whenever the part throws an exception.
 * @param exception java.lang.Throwable
 */
private void handleException(Throwable exception) {

	/* Uncomment the following lines to print uncaught exceptions to stdout */
	// System.out.println("--------- UNCAUGHT EXCEPTION ---------");
	// exception.printStackTrace(System.out);
}
/**
 * Initializes connections
 * @exception java.lang.Exception The exception description.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initConnections() throws java.lang.Exception {
	// user code begin {1}
	// user code end
	getNoAccelRadio().addItemListener(ivjEventHandler);
	getCharacterEntryPanel().addComponentListener(ivjEventHandler);
	getVirtualScrollPane().addComponentListener(ivjEventHandler);
}
/**
 * Initialize the class.
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
private void initialize() {
	try {
		// user code begin {1}
		inititializeStatics();
		// user code end
		setName("UlcAcceleratorCustomEditor");
		setLayout(new java.awt.GridBagLayout());
		setSize(656, 199);

		java.awt.GridBagConstraints constraintsKeyPanel = new java.awt.GridBagConstraints();
		constraintsKeyPanel.gridx = 0; constraintsKeyPanel.gridy = 0;
		constraintsKeyPanel.fill = java.awt.GridBagConstraints.HORIZONTAL;
		constraintsKeyPanel.anchor = java.awt.GridBagConstraints.WEST;
		constraintsKeyPanel.insets = new java.awt.Insets(4, 4, 4, 4);
		add(getKeyPanel(), constraintsKeyPanel);

		java.awt.GridBagConstraints constraintsModifierPanel = new java.awt.GridBagConstraints();
		constraintsModifierPanel.gridx = 1; constraintsModifierPanel.gridy = 0;
		constraintsModifierPanel.fill = java.awt.GridBagConstraints.VERTICAL;
		constraintsModifierPanel.anchor = java.awt.GridBagConstraints.WEST;
		constraintsModifierPanel.insets = new java.awt.Insets(4, 4, 4, 4);
		add(getModifierPanel(), constraintsModifierPanel);

		java.awt.GridBagConstraints constraintsSeparator = new java.awt.GridBagConstraints();
		constraintsSeparator.gridx = 0; constraintsSeparator.gridy = 1;
		constraintsSeparator.gridwidth = 2;
		constraintsSeparator.fill = java.awt.GridBagConstraints.HORIZONTAL;
		constraintsSeparator.anchor = java.awt.GridBagConstraints.WEST;
		constraintsSeparator.weightx = 1.0;
		constraintsSeparator.insets = new java.awt.Insets(4, 4, 4, 4);
		add(getSeparator(), constraintsSeparator);

		java.awt.GridBagConstraints constraintsKeyReleasePanel = new java.awt.GridBagConstraints();
		constraintsKeyReleasePanel.gridx = 0; constraintsKeyReleasePanel.gridy = 2;
		constraintsKeyReleasePanel.anchor = java.awt.GridBagConstraints.NORTHWEST;
		constraintsKeyReleasePanel.weighty = 1.0;
		constraintsKeyReleasePanel.insets = new java.awt.Insets(5, 5, 5, 5);
		add(getKeyReleasePanel(), constraintsKeyReleasePanel);
		initConnections();
	} catch (java.lang.Throwable ivjExc) {
		handleException(ivjExc);
	}
	// user code begin {2}
	// Radio Group for Character Input Selection
	getKeyTypeGroup().add(getKeyCharacterRadio());
	getKeyTypeGroup().add(getKeyVirtualRadio());
	getKeyTypeGroup().add(getNoAccelRadio());

	// Radio Group for On Key Release/Press Selection
	getKeyReleaseGroup().add(getKeyPressRadio());
	getKeyReleaseGroup().add(getKeyReleaseRadio());

	// Listener to handle changing Key Entry Panel card
	ItemListener selectCharInputCard = new ItemListener() {
		public void itemStateChanged(ItemEvent e) {
			if (e.getStateChange() == ItemEvent.SELECTED)
				 ((CardLayout) getKeyEntryPanel().getLayout()).show(
					 getKeyEntryPanel(),
					 getKeyTypeGroup().getSelection().getActionCommand());
		}
	};
	getKeyCharacterRadio().addItemListener(selectCharInputCard);
	getKeyVirtualRadio().addItemListener(selectCharInputCard);
	getNoAccelRadio().addItemListener(selectCharInputCard);

	// Make sure the correct card is displayed
 	((CardLayout) getKeyEntryPanel().getLayout()).show(getKeyEntryPanel(), getKeyTypeGroup().getSelection().getActionCommand());

	// Put the localized virtual keys into the virtual keys list box.
	getVirtualKeyListbox().setListData(fVirtualKeysLocalized);

	// Reset its size to its preferred size.
	setSize(getPreferredSize());
	// user code end
}
/**
 * This method will initialize the static variables if not already initialized.
 * It is done this way instead of in initializer statements because they are
 * intensive and we don't want to waste time doing them if this editor is never called.
 * Creation date: (08-23-99 12:38:25 PM)
 */
private void inititializeStatics() {
	if (fVirtualKeysLocalized == null) {
		fVirtualKeysLocalized = new Vector(64); // An initial guess at the size
		fVirtualKeysLookup = new Hashtable(64);
		
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.enter", "Enter"), new Integer(KeyEvent.VK_ENTER));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.backSpace", "Backspace"), new Integer(KeyEvent.VK_BACK_SPACE));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.tab", "Tab"), new Integer(KeyEvent.VK_TAB));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.cancel", "Cancel"), new Integer(KeyEvent.VK_CANCEL));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.clear", "Clear"), new Integer(KeyEvent.VK_CLEAR));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.shift", "Shift"), new Integer(KeyEvent.VK_SHIFT));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.control", "Control"), new Integer(KeyEvent.VK_CONTROL));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.alt", "Alt"), new Integer(KeyEvent.VK_ALT));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.pause", "Pause"), new Integer(KeyEvent.VK_PAUSE));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.capsLock", "Caps Lock"), new Integer(KeyEvent.VK_CAPS_LOCK));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.escape", "Escape"), new Integer(KeyEvent.VK_ESCAPE));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.space", "Space"), new Integer(KeyEvent.VK_SPACE));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.pgup", "Page Up"), new Integer(KeyEvent.VK_PAGE_UP));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.pgdn", "Page Down"), new Integer(KeyEvent.VK_PAGE_DOWN));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.end", "End"), new Integer(KeyEvent.VK_END));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.home", "Home"), new Integer(KeyEvent.VK_HOME));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.left", "Left"), new Integer(KeyEvent.VK_LEFT));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.up", "Up"), new Integer(KeyEvent.VK_UP));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.right", "Right"), new Integer(KeyEvent.VK_RIGHT));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.down", "Down"), new Integer(KeyEvent.VK_DOWN));
		
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.multiply", "NumPad *"), new Integer(KeyEvent.VK_MULTIPLY));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.add", "NumPad +"), new Integer(KeyEvent.VK_ADD));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.separater", "NumPad ,"), new Integer(KeyEvent.VK_SEPARATER));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.subtract", "NumPad -"), new Integer(KeyEvent.VK_SUBTRACT));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.decimal", "NumPad ."), new Integer(KeyEvent.VK_DECIMAL));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.divide", "NumPad /"), new Integer(KeyEvent.VK_DIVIDE));
		
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.f1", "F1"), new Integer(KeyEvent.VK_F1));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.f2", "F2"), new Integer(KeyEvent.VK_F2));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.f3", "F3"), new Integer(KeyEvent.VK_F3));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.f4", "F4"), new Integer(KeyEvent.VK_F4));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.f5", "F5"), new Integer(KeyEvent.VK_F5));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.f6", "F6"), new Integer(KeyEvent.VK_F6));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.f7", "F7"), new Integer(KeyEvent.VK_F7));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.f8", "F8"), new Integer(KeyEvent.VK_F8));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.f9", "F9"), new Integer(KeyEvent.VK_F9));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.f10", "F10"), new Integer(KeyEvent.VK_F10));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.f11", "F11"), new Integer(KeyEvent.VK_F11));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.f12", "F12"), new Integer(KeyEvent.VK_F12));
		
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.delete", "Delete"), new Integer(KeyEvent.VK_DELETE));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.numLock", "Num Lock"), new Integer(KeyEvent.VK_NUM_LOCK));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.scrollLock", "Scroll Lock"), new Integer(KeyEvent.VK_SCROLL_LOCK));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.printScreen", "Print Screen"), new Integer(KeyEvent.VK_PRINTSCREEN));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.insert", "Insert"), new Integer(KeyEvent.VK_INSERT));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.help", "Help"), new Integer(KeyEvent.VK_HELP));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.meta", "Meta"), new Integer(KeyEvent.VK_META));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.backQuote", "Back Quote"), new Integer(KeyEvent.VK_BACK_QUOTE));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.quote", "Quote"), new Integer(KeyEvent.VK_QUOTE));
		
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.final", "Final"), new Integer(KeyEvent.VK_FINAL));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.convert", "Convert"), new Integer(KeyEvent.VK_CONVERT));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.noconvert", "No Convert"), new Integer(KeyEvent.VK_NONCONVERT));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.accept", "Accept"), new Integer(KeyEvent.VK_ACCEPT));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.modechange", "Mode Change"), new Integer(KeyEvent.VK_MODECHANGE));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.kana", "Kana"), new Integer(KeyEvent.VK_KANA));
		fVirtualKeysLookup.put(Toolkit.getProperty("AWT.kanji", "Kanji"), new Integer(KeyEvent.VK_KANJI));
		
		String numpad = Toolkit.getProperty("AWT.numpad", "NumPad") + "-";
		fVirtualKeysLookup.put(numpad + "0", new Integer(KeyEvent.VK_NUMPAD0));
		fVirtualKeysLookup.put(numpad + "1", new Integer(KeyEvent.VK_NUMPAD1));
		fVirtualKeysLookup.put(numpad + "2", new Integer(KeyEvent.VK_NUMPAD2));
		fVirtualKeysLookup.put(numpad + "3", new Integer(KeyEvent.VK_NUMPAD3));
		fVirtualKeysLookup.put(numpad + "4", new Integer(KeyEvent.VK_NUMPAD4));
		fVirtualKeysLookup.put(numpad + "5", new Integer(KeyEvent.VK_NUMPAD5));
		fVirtualKeysLookup.put(numpad + "6", new Integer(KeyEvent.VK_NUMPAD6));
		fVirtualKeysLookup.put(numpad + "7", new Integer(KeyEvent.VK_NUMPAD7));
		fVirtualKeysLookup.put(numpad + "8", new Integer(KeyEvent.VK_NUMPAD8));
		fVirtualKeysLookup.put(numpad + "9", new Integer(KeyEvent.VK_NUMPAD9));

		// Now we need to get these localized strings into a vector. Rather than re-getting
		// them all again, we'll just enumerate the keys from the lookup table.
		Enumeration keys = fVirtualKeysLookup.keys();
		while (keys.hasMoreElements())
			fVirtualKeysLocalized.addElement(keys.nextElement());
		sort(fVirtualKeysLocalized);
	}
	
}
/**
 * main entrypoint - starts the part when it is run as an application
 * @param args java.lang.String[]
 */
public static void main(java.lang.String[] args) {
	try {
		javax.swing.JFrame frame = new javax.swing.JFrame();
		UlcAcceleratorCustomEditor aUlcAcceleratorCustomEditor;
		aUlcAcceleratorCustomEditor = new UlcAcceleratorCustomEditor();
		frame.setContentPane(aUlcAcceleratorCustomEditor);
		frame.pack();
		frame.addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				System.exit(0);
			};
		});
		frame.setVisible(true);
	} catch (Throwable exception) {
		System.err.println("Exception occurred in main() of javax.swing.JPanel");
		exception.printStackTrace(System.out);
	}
}
/**
 * Comment
 */
private void noAccelRadio_ItemStateChanged(ItemEvent itemEvent) {
	// If the toggle is selected, then we want everything else disabled
	boolean isAccel = (itemEvent.getStateChange() != ItemEvent.SELECTED);
	getAltCheck().setEnabled(isAccel);
	getCtrlCheck().setEnabled(isAccel);
	getMetaCheck().setEnabled(isAccel);
	getShiftCheck().setEnabled(isAccel);

	getKeyPressRadio().setEnabled(isAccel);	
	getKeyReleaseRadio().setEnabled(isAccel);
	return;
}
	/**
	 * Sort the objects in sorted collection and return that collection.
	 *
	 * @param sortedCollection java.lang.Object[]
	 * @param left int
	 * @param right int
	 */
	private Vector quickSort(Vector sortedCollection, CollationKey[] keyArray, int left, int right) {
		int original_left = left;
		int original_right = right;
		CollationKey mid = keyArray[ (left + right) / 2];
		do {
			while (keyArray[left].compareTo(mid) < 0)
				left++; // Find first left that is greater or equal to mid
			while (mid.compareTo(keyArray[right]) < 0)
				right--; // Find first right that is less than or equal to mid
			if (left <= right) {
				// Swap them (in both vectors)
				Object tmp = sortedCollection.elementAt(left);
				sortedCollection.setElementAt(sortedCollection.elementAt(right), left);
				sortedCollection.setElementAt(tmp, right);
				CollationKey keyTmp = keyArray[left];
				keyArray[left] = keyArray[right];
				keyArray[right] = keyTmp;
				left++;
				right--;
			}
		} while (left <= right);
		if (original_left < right) {
			sortedCollection = quickSort(sortedCollection, keyArray, original_left, right);
		}
		if (left < original_right) {
			sortedCollection = quickSort(sortedCollection, keyArray, left, original_right);
		}
		return sortedCollection;
	}
/**
 * Set the new ULCAccelerator into the editor.
 * Creation date: (08-23-99 4:00:38 PM)
 * @param anAccel com.ibm.ulc.application.ULCAccelerator
 */
public void setAcceleratorValue(ULCAccelerator anAccel) {
	if (anAccel == null) {
		getNoAccelRadio().setSelected(true);
	} else {
		// Set up whether a character or virtual key (and set in the value).
		Integer keyCode = new Integer(anAccel.getKeyCode());
		if (!fVirtualKeysLookup.contains(keyCode)) {
			getKeyCharacterRadio().setSelected(true);
			getCharacterField().setText(String.valueOf((char)anAccel.getKeyCode()));
		} else {
			getKeyVirtualRadio().setSelected(true);
			// Need to do a reverse lookup to find the correct text to select in the
			// virtual key model.
			Enumeration keys = fVirtualKeysLookup.keys();
			while (keys.hasMoreElements()) {
				Object nextKey = keys.nextElement();
				if (fVirtualKeysLookup.get(nextKey).equals(keyCode)) {
					getVirtualKeyListbox().setSelectedValue(nextKey, true);
					break;
				}
			}
		}

		// Set up the modifiers
		int modifiers = anAccel.getModifiers();
		getAltCheck().setSelected((modifiers & KeyEvent.ALT_MASK) != 0);
		getCtrlCheck().setSelected((modifiers & KeyEvent.CTRL_MASK) != 0);
		getMetaCheck().setSelected((modifiers & KeyEvent.META_MASK) != 0);
		getShiftCheck().setSelected((modifiers & KeyEvent.SHIFT_MASK) != 0);

		// Set up the key released/pressed
		getKeyReleaseRadio().setSelected(anAccel.isOnKeyRelease());
	}
}
	/**
	 * Sort a vector using current locale and collation.
	 */
	private Vector sort(Vector unSortedCollection) {
		int size = unSortedCollection.size();
		if (size > 1) {
			// Collation sorting is faster if the sort is on CollateKey instead of the string itself
			// So we will actually sort a copy of the vector containing CollationKeys instead.
			CollationKey[] keyArray = new CollationKey[unSortedCollection.size()];
			Collator collator = Collator.getInstance();
			for (int index = 0; index < keyArray.length; index++)
				keyArray[index] = collator.getCollationKey((String) unSortedCollection.elementAt(index));
			quickSort(unSortedCollection, keyArray, 0, size - 1);
		}
		return unSortedCollection;
	}
}
