package com.ibm.vap.Transactions;

/**
 * VapEJBObjectImpl
 *
 * Licensed Material - Property of IBM 
 * IBM(R) VisualAge(TM) for Java(TM) Version 2.0 
 * (C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 * 
 */

import java.util.Vector;
import javax.ejb.*;
import java.rmi.RemoteException;
import java.beans.*;
import com.ibm.vap.common.VapTransactionRequiredException;
import com.ibm.vap.swing.table.VapJTableElement;
import com.ibm.vap.swing.list.VapJListElement;

public abstract class VapEJBObjectImpl implements VapEJBObject, VapDeferredMessageReceiver, VapJTableElement, VapJListElement
{
	private BOManager bom = null;
	private static final java.lang.String copyright  = "(c) Copyright International Business Machines Corporation, 1998";
/**
 * VapEJBObjectImpl constructor
 */
public VapEJBObjectImpl (VapHome aHome)
{
	this.setBom(new BOManager(this, aHome));
}
/* For the property change event support
this is handled by the version */
public void addPropertyChangeListener(PropertyChangeListener aListener) throws RemoteException
{
	this.getBom().addPropertyChangeListener(aListener);
}
/* For the property change event support
this is handled by the version
Try to resume the transaction tx before removing aListener
all exceptions must be handled.*/
public synchronized void addPropertyChangeListener(PropertyChangeListener aListener, Transaction tx) throws RemoteException
{
	Transaction current = Transaction.getCurrent();
	try {
		tx.resume();
	} catch (VapTransactionRequiredException ivjExc) {}
	try {
		getBom().addPropertyChangeListener(aListener);
	} catch(Throwable ex) {}
	current.resume();
}
/**
 * Test if the versions can be merged
 */
public boolean canMerge(Version aParentVersion, Version aChildVersion)
{
	return false;
}
/**
 * Copy the bean for a new version
 */
public EntityBean copyBean(EntityBean anOldBean) throws RemoteException
{
	EntityBean newBean = null;

	newBean = this.getInitialBean();
	this.initializeBean(newBean, anOldBean);
	return newBean;
}
/**
 * Return a string that will be used to display the object in a JList.
 * The default is to use toString(), but you can override this method
 * to return any string.
 */
public java.lang.String displayString() {

	return toString();
}
/**
 * This method is sent to all EjbObjects that have version data
 * that can be merged as part of a transaction commit
 */
public void firePropertyChanges(EntityBean originalBean) throws java.rmi.RemoteException {
	/* Do nothing by default.
	 * Specialize in subclasses to perform any processing that should be done
	 * following a merge of the data from a child transaction's version data */
}
/**
 * Answer the business object manager
 */
public BOManager getBom()
{
	return bom;
}
/**
 * Answer the home
 */
public EJBHome getEJBHome() throws RemoteException
{
	return (EJBHome)this.getBom().getHome();
}
/**
 * Answer object's handle
 */
public Handle getHandle() throws RemoteException
{
	return null;
}
/**
 * Answer a new bean instance
 */
public abstract EntityBean getInitialBean() throws RemoteException;
/**
 * This method was created by a SmartGuide.
 * @return com.ibm.vap.Transactions.Key
 * @param versionData com.ibm.vap.Transactions.VersionData
 */
public abstract Key getKeyFor(EntityBean aBean);
/**
 * Answer the bean's links
 * Default implementation returns empty vector so subclasses can call super first
 */
public Vector getLinksFor(EntityBean bean) {
	return new Vector();
}
/**
 * getPrimaryKey method comment.
 */
public Object getPrimaryKey() throws RemoteException
{
	return this.getKeyFor(this.getBom().getBeanForRead());
}

public String getShortClassName() {
	
	return com.ibm.vap.common.ClassShortName.name(this);

}
/**
 * Initialize a new bean by copyng the old bean's property values into it.
 * @param newBean javax.ejb.EntityBean
 * @param oldBean javax.ejb.EntityBean
 */
/* WARNING: THIS METHOD WILL BE REGENERATED. */
public void initializeBean(EntityBean aNewBean, EntityBean anOldBean)
{
		// subclasses will override and invoke their super.
}
/**
* Answer true if the object is business object
*/
public boolean isBusinessObject()
{
	return true;
}
/**
 * This method was called from aTableModel to determine if the attribute
 * that is populated using aColumnId (there will be a 'get{aColumnId}' and 'set{aColumnId}').
 * The default will be true.  Override this method in a subclass to prevent editing
 * of particular attributes under certain circumstances.
 *
 * @return boolean
 * @param aString The columnIdentifier from aTableModel.
 * @param aTableModel com.ibm.vap.swing.table.VapAbstractTableModel
 */
public boolean isFieldEditable(String aColumnId, com.ibm.vap.swing.table.VapAbstractTableModel aTableModel) {

	return true;
}
/**
 * isIdentical method comment.
 */
public boolean isIdentical(EJBObject anEjbObject) throws RemoteException
{
	return false;
}
/**
 * BOs and NullTargets are not initial targets
 */
public boolean isInitialTarget()
{
	return false; 
}
/**
 *
 */
public boolean isNotVapRemoved()
{
	try {
		return !this.getBom().getVersionForRead().isRemoved();
	} catch (RemoteException e) {
		return false;
	} 
	
}
/**
 * Answer true if I exists in the database.  So the only time
 * this would answer false would be that I am newly created and
 * not yet inserted to the database
 */
public boolean isPersistent()
{
	Version version;
	
	try
	{
		version = this.getBom().getVersionForRead();
		return ((version != null) && (version.isOld())); 
	}
	catch (RemoteException e) {
		return false;}
}
/**
 * Merge the versions
 */
public void merge(Version aParentVersion, Version aChildVersion)
{
	aParentVersion.setBean(aChildVersion.getBean());
}
/**
 * We have had some new state merged into us.
 * We should signal our isPersistent flag and also signal change across links
 */
public void mergedInto() throws RemoteException {

	//still need to signal the mergedInto event
	this.signalChangeAcrossLinks();
}
/**
 * We have had some new state merged into us.
 * We should signal our isPersistent flag ( which might change when data
 * is merged into the shared version ) as well as execute the mergedInto method )
 */
public void mergedIntoReadOnly() throws RemoteException {

	//still need to signal isPersistent event
	this.mergedInto();
}
/**
 */
public void postInitializeFrom(Version anOldVersion, Version aNewVersion) {

	//Do nothing
}
/**
 * Answer the EJBObject's bean.
 * WARNING! To be used only during a new object creation.
 */
public EntityBean primGetBean()
{
	return this.getBom().primGetBean();
}
/**
 * Remove the object
 */
public void remove() throws RemoteException, RemoveException
{
	this.secondaryRemove();
}
/* For the property change event support
this is handled by the version */
public void removePropertyChangeListener(PropertyChangeListener aListener) throws RemoteException
{
	this.getBom().removePropertyChangeListener(aListener);
}
/* For the property change event support
this is handled by the version
Try to resume the transaction tx before removing aListener
all exceptions must be handled.*/
public synchronized void removePropertyChangeListener(PropertyChangeListener aListener, Transaction tx) throws RemoteException
{
	Transaction current;
	
	current = Transaction.getCurrent();
	try {
		tx.resume();}
	catch (VapTransactionRequiredException ivjExc) {}
	try {
		getBom().removePropertyChangeListener(aListener);}
	catch(Throwable ex) {}
	current.resume();
}
/**
 * Remove the object
 */
public void secondaryRemove() throws RemoteException, RemoveException
{
	this.getBom().markRemoved();
}
/**
* Set the business object manager
*/
public void setBom(BOManager aBom)
{
	bom = aBom;
}
/**
 * Tell all of our links that we have changed.
 * Be very careful not to hyrdate anything that not already been hydrates
 */
public void signalChangeAcrossLinks() throws RemoteException {

	java.util.Enumeration e;
	AbstractLink next;
	
	e = getBom().getUnrealizedVersionForRead().getLinks().elements();
	while (e.hasMoreElements()) {
		next = (AbstractLink)e.nextElement();
		next.changeSignalledForTarget(this);
	}
}
/**
 * Signal the events on the receiver based on the fact that the argument
 * version has merged its data into the receiver
 * This could be following a commit() of a transaction where the child version
 * merges its data with the parent version
 */
public void signalEvents(Version aVersion) { }
/**
 * Return the OID for this object.
 */

public OID toOid() throws RemoteException {

	return new OID((VapHome) getEJBHome(), (Key) getPrimaryKey());
}
public String toString()
{
	try {
		Key myKey = this.getKeyFor(this.getBom().getUnrealizedVersionForRead().getBean());
		String result = com.ibm.vap.common.ClassShortName.name(this);
		if (myKey != null)
			result = result + "{" + myKey + "}";
		return result;	}
	catch (Throwable any) {
		return "could not print: " + any; };}
}