package com.ibm.vap.Transactions;

import java.util.Vector;
import java.util.Enumeration;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import com.ibm.vap.common.VapReadFailureException;
import com.ibm.vap.Persistence.PersistentHomeCollection;
import com.ibm.vap.swing.table.VapSwingElement;

/**
 * This type was created in VisualAge.
 */
public class VapSwingCollectionShell implements VapCollectionShell {

	private Vector source = new Vector();
	private VapCollectionShellSignaller signaller = new VapCollectionShellSignaller(this);
	private PersistentHomeCollection home;
/**
 * VapSwingCollectionShell constructor comment.
 */
public VapSwingCollectionShell() {
	super();
}
/**
 * VapSwingCollectionShell constructor comment.
 */
public VapSwingCollectionShell(VapActionListener aListener) {
	super();
	this.addActionListener(aListener);
}
/**
 * VapSwingCollectionShell constructor comment.
 */
public VapSwingCollectionShell(Vector aVector) {

	this.setSource(aVector);
}
/* 
 * Forward this method to the signaller
 */
public synchronized void addActionListener(VapActionListener listener){
	signaller.addActionListener(listener);
}
/* 
 * Add ourself as a propertyChangeListener to anObject
 */
private void addAsPropertyChangeListenerTo(Object anObject) {

	try {
		if ((anObject != null) && (anObject instanceof VapSwingElement))
			((VapSwingElement)anObject).addPropertyChangeListener((PropertyChangeListener)this);
	} catch (RemoteException e) { }
		
}
/* 
 * Add ourself as a propertyChangeListener to anObject
 */
private void addAsPropertyChangeListenerTo(Vector aVector) {

	Enumeration e = aVector.elements();
	while (e.hasMoreElements()) {
		this.addAsPropertyChangeListenerTo(e.nextElement());
	}
		
}
/**
 * Forward to source
 */
public void addElement(Object anObject) {
	
	source.addElement(anObject);
	addAsPropertyChangeListenerTo(anObject);
}
/**
 * Forward to source
 */
public boolean contains(Object anObject) {
	return source.contains(anObject);
}
/**
 * Forward to source
 */
public Object elementAt(int index) {
	
	return source.elementAt(index);
}
/**
 * Forward to source
 */
public Enumeration elements() {
	
	return source.elements();
}
/**
 * Forward to source
 */
public Object firstElement() {
	
	return source.firstElement();
}
/**
 * Return the source.
 */
public Vector getSource() {
	
	if (source == null)
		source = new Vector();
	return source;
}
/**
 * Forward to source
 */
public int indexOf(Object anObject) {
	
	return source.indexOf(anObject);
}
/**
 * Forward to source
 */
public void insertElementAt(Object anObject, int index) {
	
	source.insertElementAt(anObject, index);
}
/**
 * Return the source.
 */
public boolean isEmpty() {
	
	return (source == null) ? true : source.isEmpty();
}
/**
 * Forward to source
 */
public Object lastElement() {
	
	return source.lastElement();
}
/**
 * Method to handle events for the PropertyChangeListener interface.
 * @param evt java.beans.PropertyChangeEvent
 */

public void propertyChange(java.beans.PropertyChangeEvent evt) {

	int index = this.indexOf(evt.getSource());
	this.signalObjectChangedEvent(index);
	
}
/**
 * Set the home.
 */
public void queryHome() {

	setHome(home);
}
/* 
 * Forward this method to the signaller
 */
public synchronized void removeActionListener(VapActionListener listener){
	signaller.removeActionListener(listener);
}
/**
 * Forward to source
 */
public void removeAllElements() {

	Object anObject = null;
	Vector copy = (Vector)source.clone();
	Enumeration e = copy.elements();
	while (e.hasMoreElements()) {
		anObject = e.nextElement();
		this.removeElement(anObject);
	}
}
/* 
 * Remove ourself as a propertyChangeListener to anObject
 */
private void removeAsPropertyChangeListenerFrom(Object anObject) {

	try {
		if ((anObject != null) && (anObject instanceof VapSwingElement))
			((VapSwingElement)anObject).removePropertyChangeListener((PropertyChangeListener)this);
	} catch (RemoteException e) { }		
}
/* 
 * Remove ourself as a propertyChangeListener for all elements.
 */
public void removeAsPropertyChangeListenerFromAll() {

	
	Enumeration e = elements();
	while (e.hasMoreElements()) {
		this.removeAsPropertyChangeListenerFrom(e.nextElement());
	}

		
}
/**
 * Forward to source
 */
public boolean removeElement(Object anObject) {
	
	boolean result;
	
	result = source.removeElement(anObject);
	removeAsPropertyChangeListenerFrom(anObject);
	return result;
}
/**
 * Forward to source
 */
public void removeElementAt(int index) {

	this.removeAsPropertyChangeListenerFrom(elementAt(index));
	source.removeElementAt(index);
}
/**
 * Forward to source
 */
public void setElementAt(Object anObject, int index) {

	Object old = source.elementAt(index);
	if (old != null)
		removeAsPropertyChangeListenerFrom(old);
	
	source.setElementAt(anObject, index);

	if (anObject != null)
		addAsPropertyChangeListenerTo(anObject);
	
	
}
/**
 * Set the home.
 */
public void setHome(PersistentHomeCollection aHome) {

	Vector data = null;
	
	home = aHome;
	if (aHome == null) {
		data = new Vector(0);
	} else {
		try {
			data = aHome.allInstances();
		}
		catch (RemoteException e) { }
		catch (VapReadFailureException e) { }
	}

	this.setSource(data);
		
	
}
/**
 * Set the source.
 */
public void setSource(Vector aVector) {
	
	if (source != null)
		this.removeAsPropertyChangeListenerFromAll();

	source = (aVector == null) ? new Vector(0) : aVector;

	if (source != null)
		this.addAsPropertyChangeListenerTo(source);
	
}
/**
 * Forward signal to the signaller
 */
public void signalObjectChangedEvent(int index) {

	signaller.signalObjectChangedEvent(index);
}
/**
 * Forward to source
 */
public int size() {
	
	return source.size();
}
}