package com.ibm.vap.swing.table;

import com.ibm.vap.swing.list.VapJListElement;

/**
 * This type was created in VisualAge.
 */
public class VapColumnIdentifier implements VapJListElement, Cloneable, java.io.Serializable {

	public String identifier;
	public Class type;
	public Boolean editable = new Boolean(true);
	protected transient java.beans.PropertyChangeSupport propertyChange;
/**
 * VapColumnIdentifier constructor comment.
 */
public VapColumnIdentifier() {
	super();
}
/**
 * VapColumnIdentifier constructor comment.
 */
public VapColumnIdentifier(String[] values) {
	setIdentifier(values[0]);
	try {
		setType(Class.forName(values[1]));
	} catch (ClassNotFoundException e) {}
	setEditable(Boolean.valueOf(values[2]));
}
/**
 * VapColumnIdentifier constructor comment.
 */
public VapColumnIdentifier(String identifier) {
	setIdentifier(identifier);
}
/**
 * VapColumnIdentifier constructor comment.
 */
public VapColumnIdentifier(String identifier, Class classType) {
	setIdentifier(identifier);
	setType(classType);
}
/**
 * The addPropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().addPropertyChangeListener(listener);
}
/**
 * Returns a clone of this object.
 */
public synchronized Object clone() {
try { 
	VapColumnIdentifier v = (VapColumnIdentifier)super.clone();
	return v;
} catch (CloneNotSupportedException e) { 
	// this shouldn't happen, since we are Cloneable
	throw new InternalError();
}
}
/**
 * This method was created in VisualAge.
 */
public static VapColumnIdentifier createNew() {
	return new VapColumnIdentifier();
}
/**
 * This method was created in VisualAge.
 */
public String displayString() {

	StringBuffer buffer = new StringBuffer();

	buffer.append(getIdentifier());
	buffer.append(" {Type:  ");
	buffer.append(getType().getName());
	buffer.append("  Editable:  ");
	buffer.append(getEditable());
	buffer.append("}");

	return buffer.toString();
}
/**
 * The firePropertyChange method was generated to support the propertyChange field.
 */
public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
}
/**
 * This method was created in VisualAge.
 */
public Boolean getEditable() {
	return editable;
}
/**
 * This method was created in VisualAge.
 */
public String getIdentifier() {
	if (identifier == null)
		identifier = "New";
	return identifier;
}
/**
 * Accessor for the propertyChange field.
 */
protected java.beans.PropertyChangeSupport getPropertyChange() {
	if (propertyChange == null) {
		propertyChange = new java.beans.PropertyChangeSupport(this);
	};
	return propertyChange;
}
/**
 * This method was created in VisualAge.
 */
public Class getType() {
	return type;
}
/**
 * This method was created in VisualAge.
 */
public Class getTypeForSetterMethod() {

	Class aClass = getType();
	
	if (aClass.isPrimitive()) {
		aClass = getWrapperForPrimitive(aClass);
	}
	
	return aClass;
}
/**
 *	Return the Object wrapper class for the primitive type primType
 */
private Class getWrapperForPrimitive(Class primType) {

	if (primType == int.class)
		return Integer.class;
	if (primType == boolean.class)
		return Boolean.class;
	if (primType == byte.class)
		return Byte.class;
	if (primType == short.class)
		return Short.class;
	if (primType == long.class)
		return Long.class;
	if (primType == float.class)
		return Float.class;
	if (primType == double.class)
		return Double.class;

	return null;
		
}
/**
 * This method was created in VisualAge.
 */
public Boolean isEditable() {
	return editable;
}
/**
 * The removePropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().removePropertyChangeListener(listener);
}
/**
 * This method was created in VisualAge.
 */
public void setEditable(Boolean aBoolean) {
	Boolean oldValue = editable;
	editable = aBoolean;
	firePropertyChange("editable", oldValue, editable);
}
/**
 * This method was created in VisualAge.
 */
public void setIdentifier(String aString) {
	identifier = aString;
}
/**
 * This method was created in VisualAge.
 */
public void setType(Class aClass) {
	type = aClass;
}
/**
 * This method was created in VisualAge.
 */
public String toString() {

	StringBuffer buffer = new StringBuffer();

	buffer.append(getIdentifier());
	buffer.append(" ");
	buffer.append(getType().getName());
	buffer.append(" ");
	buffer.append(getEditable());

	return buffer.toString();
}
}