package com.ibm.vap.Isolation;

/**
 * TransactionIsolationPolicy
 *
 * Licensed Material - Property of IBM 
 * IBM(R) VisualAge(TM) for Java(TM) Version 2.0 
 * (C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved. 
 * US Government Users Restricted Rights - Use, duplication or disclosure 
 * restricted by GSA ADP Schedule Contract with IBM Corp. 
 *
 */

import javax.ejb.EJBObject;
import java.rmi.RemoteException;
import java.util.Vector; 
import com.ibm.vap.Transactions.Transaction;
import com.ibm.vap.Transactions.Version;
import com.ibm.vap.Transactions.Key;
import com.ibm.vap.Transactions.VapEJBObject;
import com.ibm.vap.Transactions.VapEJBHome;
import com.ibm.vap.common.VapReadFailureException;
import com.ibm.vap.common.VapObjectLockedException;
import com.ibm.vap.common.VapTransactionRequiredException;

public class TransactionIsolationPolicy extends java.lang.Object
{
	protected TransactionLockingPolicy onReadPolicy = null;
	protected TransactionLockingPolicy onUpdatePolicy = null;
	private static final java.lang.String copyright  = "(c) Copyright International Business Machines Corporation, 1998";
/**
 * TransactionIsolationPolicy constructor
 */
public TransactionIsolationPolicy(TransactionLockingPolicy aReadPolicy, TransactionLockingPolicy anUpdatePolicy)
{
	this.setOnReadPolicy(aReadPolicy);
	this.setOnUpdatePolicy(anUpdatePolicy);
}
/**
 * Read all instances from a home
 */
public Vector allInstancesFrom(VapEJBHome aHome) throws RemoteException, VapReadFailureException
{
	if (Transaction.getCurrent().isShared())
		throw new VapTransactionRequiredException();

	return this.getOnReadPolicy().allInstancesFrom(aHome);
}
/**
 * Answer a copy of the isolation policy
 */
public TransactionIsolationPolicy createCopy()
{
	return new TransactionIsolationPolicy(
		this.getOnReadPolicy(),
		this.getOnUpdatePolicy());
}
/**
 * Answer a new isolation policy that allows dirty reads
 */
public static TransactionIsolationPolicy createDirtyReadPolicy()
{
	return new TransactionIsolationPolicy(
		TransactionPassiveLockingPolicy.getSingleton(),
		null);
}
/**
 * Answer a new instance of a isolation policy that acquires a share lock on access and
 * a write lock on update
 */
public static TransactionIsolationPolicy createRepeatableReadPolicy()
{
	return new TransactionIsolationPolicy(
		TransactionPessimisticLockingPolicy.getSingleton(),
		null);
}
/**
 * Answer a new instance of a isolation policy that acquires no locks on access and
 * a write lock on update
 */
public static TransactionIsolationPolicy createUnrepeatableReadPolicy()
{
	return new TransactionIsolationPolicy(
		TransactionPassiveLockingPolicy.getSingleton(),
		TransactionPessimisticLockingPolicy.getSingleton());
}
/**
 * Execute the query named aQueryName
 */
public Vector customQueryFrom(VapEJBHome aHome, String aQueryName, Object[] args) throws RemoteException, VapReadFailureException
{
	if (Transaction.getCurrent().isShared())
		throw new VapTransactionRequiredException();

	return this.getOnReadPolicy().customQueryFrom(aHome, aQueryName, args);
}
/**
 * Read an instance from a home
 */
public VapEJBObject findByPrimaryKey(Key aKey, VapEJBHome aHome) throws RemoteException, VapReadFailureException
{
	if (Transaction.getCurrent().isShared())
		throw new VapTransactionRequiredException();

	return this.getOnReadPolicy().findByPrimaryKey(aKey,aHome);
}
/**
 * Answer the lock policy for read
 */
public TransactionLockingPolicy getOnReadPolicy()
{
	return onReadPolicy;
}
/**
 * Answer the lock policy for update
 */
public TransactionLockingPolicy getOnUpdatePolicy()
{
	return onUpdatePolicy;
}
/**
 * If the transaction supports read stability, initialize the child version with a copy
 * of parent's data. Otherwise share the parent's data.
 */
public void initializeVersion(Version aChildVersion, Version aParentVersion) throws RemoteException
{
	this.getOnReadPolicy().initializeVersion(aChildVersion,aParentVersion);
}
/**
 * The version is read first time
 */
public void notifyFirstReadFor(Version aVersion) throws RemoteException, VapObjectLockedException
{
	this.getOnReadPolicy().notifyFirstAccessFor(aVersion);
}
/**
 * The version is updated first time
 */
public void notifyFirstUpdateFor(Version aVersion) throws RemoteException, VapObjectLockedException
{
	TransactionLockingPolicy policy;

	if ((policy = this.getOnUpdatePolicy()) != null)
		policy.notifyFirstAccessFor(aVersion);
}
/**
 * The version is registered into a view
 */
public void notifyRegistrationFor(Version aVersion) throws RemoteException, VapObjectLockedException
{
	this.getOnReadPolicy().notifyRegistrationFor(aVersion);
}
/**
 * Set the lock policy for read
 */
public void setOnReadPolicy(TransactionLockingPolicy aPolicy)
{
	onReadPolicy = aPolicy;
}
/**
 * Set the lock policy for update
 */
public void setOnUpdatePolicy(TransactionLockingPolicy aPolicy)
{
	onUpdatePolicy = aPolicy;
}
/**
 * Answer true if the policy supports repeatable reads
 */
public boolean supportsRepeatableReads()
{
	return this.getOnReadPolicy().supportsRepeatableReads();
}
}