package com.ibm.vap.swing.list;

import java.util.Enumeration;
import java.util.Vector;
import java.rmi.RemoteException;
import javax.ejb.RemoveException;
import com.ibm.vap.common.ArrayVectorTransform;
import com.ibm.vap.Transactions.LinkCollectionShell;
import com.ibm.vap.Transactions.VapEJBObject;
import com.ibm.vap.Transactions.VapEvent;
import com.ibm.vap.Transactions.VapTransactionalEvent;
import com.ibm.vap.Transactions.Transaction;

/**
 * This type was created in VisualAge.
 */
 
public class VapDefaultRelationshipListModel extends VapAbstractListModel {
	private LinkCollectionShell delegate;
	protected boolean acceptEvents = true;
/**
 * VapDefaultRelationshipListModel constructor comment.
 */
public VapDefaultRelationshipListModel() {
	super();
}
private void acceptEvents() {
	acceptEvents = true;
}
/**
 * This is the callback that one of our dependents has signalled an event
 */
public void actionPerformed(VapEvent event) {

	if (acceptEvents == false) return;

	if ((event.getSource() == delegate) && (event.getEventName() == "addedItems")) {
		fireIntervalAdded(event);
		return ;
	}

	if ((event.getSource() == delegate) && (event.getEventName() == "removedItems")) {
		fireIntervalRemoved(event);
		return ;
	}

	if ((event.getSource() == delegate) && (event.getEventName() == "objectChanged")) {
		fireContentAtIndexChanged(event);
		return ;
	}

	if ((event.getSource() == delegate) && (event.getEventName() == "replacedItems")) {
		fireContentsChanged(event);
		return ;
	}
}
private void addElement(VapEJBObject anEJBObject) {

	Transaction current = cacheCurrentAndResumeTransaction();
	
	try {
		int index = delegate.size();
		delegate.addElement(anEJBObject);
	} catch(RemoteException e) {handleException(e);}

	resumeTransaction(current);
	
}
public void addElement(Object anObject) {

	this.addElement((VapEJBObject) anObject);
	
}
public void addElements(Vector aVector) {
	int index = aVector.size() - 1;
	Enumeration e = aVector.elements();
	while (e.hasMoreElements())
		this.addElement(e.nextElement());
	
}
private void doNotAcceptEvents() {
	acceptEvents = false;
}
/**
 * Inform the list of the changed element from a VapEvent.
 */
protected void fireContentsChanged(VapEvent event) {

	int first, last;
	Vector data, indices;
	
	if ((transaction == null) || (transaction == ((VapTransactionalEvent)event).getTransaction())) {
		data = (Vector)event.getEventData();
		indices = (Vector)data.lastElement();
		first = ((Integer)indices.firstElement()).intValue();
		last = ((Integer)indices.lastElement()).intValue();
			
		fireContentsChanged(this, first, last);
	}
}
/**
 * Inform the list of the added elements from a VapEvent.
 */
protected void fireIntervalAdded(VapEvent event) {

	int first, last;
	Vector data, indices;

	if ((transaction == null) || (transaction == ((VapTransactionalEvent)event).getTransaction())) {
		data = (Vector)event.getEventData();
		indices = (Vector)data.lastElement();
		first = ((Integer)indices.firstElement()).intValue();
		last = ((Integer)indices.lastElement()).intValue();
	
		fireIntervalAdded(this, first, last);
	}
}
/**
 * Inform the list of the removed elements from a VapEvent.
 */
protected void fireIntervalRemoved(VapEvent event) {

	int first, last;
	Vector data, indices;

	if ((transaction == null) || (transaction == ((VapTransactionalEvent)event).getTransaction())) {
		data = (Vector)event.getEventData();
		indices = (Vector)data.lastElement();
		first = ((Integer)indices.firstElement()).intValue();
		last = ((Integer)indices.lastElement()).intValue();
	
		fireIntervalRemoved(this, first, last);
	}
}
public Object getElementAt(int index) {

	Object result = null;
	
	Transaction current = cacheCurrentAndResumeTransaction();
	try {
		result = delegate.elementAt(index);
	} catch (RemoteException e) { }

	this.resumeTransaction(current);
	return result;
	
}
/**
 * Return an Enumeration of the delegate's elements.
 */

public Enumeration getElements() {

	Enumeration enum = null;
	Transaction current = cacheCurrentAndResumeTransaction();
	try {
		enum = delegate.elements();
	} catch (RemoteException e) {handleException(e);}
	this.resumeTransaction(current);
	return enum;
}
public int getSize() {
	int size = 0;
	Transaction current = cacheCurrentAndResumeTransaction();
	try {
		size = (delegate == null) ? 0 : delegate.size();
	} catch (RemoteException e) {size = 0;}
	this.resumeTransaction(current);
	return size;
}
private int indexOf(VapEJBObject elem) {

	int index = -1;
	Transaction current = cacheCurrentAndResumeTransaction();
	try {
		index = delegate.indexOf(elem);
	} catch (RemoteException e) {
		handleException(e);
	}
	this.resumeTransaction(current);
	return index;
}
public int indexOf(Object elem) {

	return this.indexOf((VapEJBObject) elem);
}
/*
 * Do nothing since a LinkCollectionShell cannot insert at a particular point.
 */

public void insertElementAt(Object obj, int index) {
	return ;
}
public boolean isEmpty() {

	boolean answer = true;
	Transaction current = cacheCurrentAndResumeTransaction();
	try {
		answer = delegate.isEmpty();
	} catch (RemoteException e) { }
	this.resumeTransaction(current);
	return answer;
}
/**
 * Reset the relationship to be the delegate.
 */
protected void newTransactionObtained() {

	if (delegate != null && !delegate.isConnected())
		delegate = null ;
	/*The transaction has been committed or rolledback without the
	delegate being set to null, so set it to null before proceeding.*/
	setRelationship(delegate);
}
/**
 * Remove the object at index from the relationship.
 * Return the object at index.
 * The object is not markedRemoved().
 */

protected Object primRemove(int index) {

	Object rv = null;
	Transaction current = cacheCurrentAndResumeTransaction();
	try {
		rv = delegate.elementAt(index);
		delegate.removeElement((VapEJBObject) rv);
	} catch (RemoteException e) {handleException(e);}
	this.resumeTransaction(current);
	return rv;
}
/**
 * Remove all elements from the relationship.
 * The elements are not markedRemoved().
 */

public void removeAllElements() {
	
	int index1 = -1;
	this.clearSelection();
	if (delegate == null) return;
	doNotAcceptEvents();
	
	Transaction current = cacheCurrentAndResumeTransaction();
	try {
		index1 = delegate.size()-1;
		Enumeration enum = delegate.elements();
		while (enum.hasMoreElements()) {
			delegate.removeElement((VapEJBObject) enum.nextElement());
		}
	} catch (RemoteException e) {}
	if (index1 >= 0) {
	    fireIntervalRemoved(this, 0, index1); 
	} 
	this.resumeTransaction(current);
	acceptEvents();
}
/**
 * Remove anEJBObject from the relationship.
 * True is returned if the object was successfully removed.
 * The object is not markedRemoved().
 */

private boolean removeElement(VapEJBObject anEJBObject) {

	boolean ok = false;
	Transaction current = cacheCurrentAndResumeTransaction();
	try {
		int index = delegate.indexOf(anEJBObject);
		ok = delegate.removeElement(anEJBObject);
		fireIntervalRemoved(this, index, index);
	} catch (RemoteException e) {handleException(e);}
	this.resumeTransaction(current);
	return ok;
}
/**
 * Remove the object at index from the relationship.
 * True is returned if the object was successfully removed.
 * The object is not markedRemoved().
 */

public boolean removeElement(Object anObject) {

	return removeElement((VapEJBObject) anObject);
}
public void removeElementAt(int index) {

	this.remove(index);
}
public void removeRange(int fromIndex, int toIndex) {

	doNotAcceptEvents();
	
	for(int i = toIndex; i >= fromIndex; i--) {
	    this.primRemove(i);
	}
	fireIntervalRemoved(this, fromIndex, toIndex);

	acceptEvents();
}
/**
 * This method was created in VisualAge.
 */
public void setRelationship(LinkCollectionShell aRelationship) {

	int index = 0;
	LinkCollectionShell oldValue = delegate;
	if (delegate != null) {
		delegate.removeActionListener(this);
		delegate.removeAsPropertyChangeListenerFromAll();
	}
	delegate = aRelationship;
	if (aRelationship != null) {
		delegate.addActionListener(this);
		try {
			index = delegate.size() - 1;
		} catch (RemoteException e) {}
		index = (index == -1) ? 0 : index;
	}
	this.clearSelection();
	fireIntervalAdded(this, 0, index);

}
public String toString() {
	return delegate.toString();
}
}