package com.ibm.vap.swing.table;

import java.util.Enumeration;
import java.util.Vector;
import com.sun.java.swing.event.TableModelEvent;
import java.rmi.RemoteException;
import com.ibm.vap.common.VapReadFailureException;
import com.ibm.vap.Persistence.PersistentHomeCollection;
import com.ibm.vap.Transactions.Transaction;
import com.ibm.vap.Transactions.VapEvent;
import com.ibm.vap.Transactions.VapSwingCollectionShell;

/**
 * This type was created in VisualAge.
 */
public class VapDefaultTableModel extends VapAbstractTableModel {

	/** The Vector of Vector of Object values */
	protected VapSwingCollectionShell dataVector;
	protected PersistentHomeCollection home;
	private java.lang.String[] fieldColumnIds = new String[1];
	public boolean shouldQueryAfterMergedIntoEvent = true;
/**
 * VapDefaultTableModel constructor comment.
 */
public VapDefaultTableModel() {
	super();
}
/**
 * This is the callback that one of our dependents has signalled an event
 */
public void actionPerformed(VapEvent event) {

	if ((event.getSource() == dataVector) && (event.getEventName() == "objectChanged")) {
		fireTableRowUpdated(event);
		return ;
	}

	if ((event.getSource() == dataVector) && (event.getEventName() == "replacedItems")) {
		fireTableRowsUpdated(event);
		return ;
	}

	if ((event.getSource() == transaction) && (event.getEventName() == "mergedInto")) {
		this.executeForMergedIntoEvent();
		return ;
	}
}
/**
 *  Add anObject to the dataVector.
 */
protected void addElement(Object anObject) {
	getDataVector().addElement(anObject);
}
/**
 *
 */
protected void executeForMergedIntoEvent() {

	if (shouldQueryAfterMergedIntoEvent == true)
		this.queryHome();
}
/**
 * Inform the table of the removed rows from a VapEvent.
 */
protected void fireTableRowsUpdated(VapEvent event) {

	int first, last;
	Vector data, indices;
	
	data = (Vector)event.getEventData();
	indices = (Vector)data.lastElement();
	first = ((Integer)indices.firstElement()).intValue();
	last = ((Integer)indices.lastElement()).intValue();

	fireTableRowsUpdated(first, last);
}
/**
 * Inform the table of the removed row from a VapEvent.
 */
protected void fireTableRowUpdated(VapEvent event) {

	int index = ((Integer)event.getEventData()).intValue();
	fireTableRowsUpdated(index, index);

}
/**
 *  Add anObject to the dataVector.
 */
public VapSwingCollectionShell getDataVector() {
	
	if (dataVector == null) {
		dataVector = new VapSwingCollectionShell();
		dataVector.addActionListener(this);
	}

	return dataVector;
		
}
/**
 * Return the object within the dataVector at the index aRow.
 */
public Object getElementAt(int aRow) {

	Object result;
	Transaction current = cacheCurrentAndResumeTransaction();
	result = getDataVector().elementAt(aRow);
	this.resumeTransaction(current);
	return result;
}
/**
 * Return an Enumeration of the model's data collection.
 */
protected Enumeration getElements() {
	return getDataVector().elements();
}
/**
 * Return the index of anObject within the model.
 */
protected int getIndexOf(Object anObject) {
	return getDataVector().indexOf(anObject);
}
//
// Implementing the TableModel interface
//

/**
 * @return the number of rows in the model.
 */
public int getRowCount() {
	
	return getDataVector().size();
}

public boolean getShouldQueryAfterMergedIntoEvent() {

	return shouldQueryAfterMergedIntoEvent;
		
}
/**
 *  Insert a row at <i>row</i> in the model. Notification
 *  of the row being added will be generated.
 */
public void insertRow(int row, Object anObject) {
	if (anObject == null)
		return ;

	getDataVector().insertElementAt(anObject, row);
	
	// Generate notification
	fireTableRowsInserted(row, row);
}
	/**
	 *  Moves one or more rows starting at <i>startIndex</i> to <i>endIndex</i>
	 *  in the model to the <i>toIndex</i>.    This method will send a
	 *  tableChanged() notification message to all the listeners. <p>
	 *
	 *  Examples of moves:<p>
	 *  1. moveRow(1,3,5);<p>
	 *          a|B|C|D|e|f|g|h|i|j|k   - before
	 *          a|e|f|B|C|D|g|h|i|j|k   - after
	 *  2. moveRow(6,7,1);<p>
	 *          a|b|c|d|e|f|G|H|i|j|k   - before
	 *          a|G|H|b|c|d|e|f|i|j|k   - after
	 *
	 * @param   startIndex       the starting row index to be moved
	 * @param   endIndex         the ending row index to be moved
	 * @param   toIndex          the destination of the rows to be moved
	 * @exception  ArrayIndexOutOfBoundsException  if any of the indices are out of
	 *                           range.  Or if endIndex is less than startIndex.
	 */
	public void moveRow(int startIndex, int endIndex, int toIndex) {
		if ((startIndex < 0) || (startIndex >= getRowCount()))
			throw new ArrayIndexOutOfBoundsException(startIndex);
		if ((endIndex < 0) || (endIndex >= getRowCount()))
			throw new ArrayIndexOutOfBoundsException(endIndex);
		if (startIndex > endIndex)
			throw new ArrayIndexOutOfBoundsException();

		if ((startIndex <= toIndex) && (toIndex <= endIndex))
			return;                     // Nothing to move

		boolean shift = toIndex < startIndex;

		// Do the move by first removing the row, then reinserting it
		for (int i = startIndex; i <= endIndex; i++) {
			Object aRow = dataVector.elementAt(i);
			dataVector.removeElementAt(i);
			dataVector.insertElementAt(aRow, toIndex);

			if (shift)
				toIndex++;
		}

		// Generate notification
		fireTableDataChanged();
	}
/**
 * Query the home.
 */
protected void newTransactionObtained() {
	this.queryHome();
}
/**
 *  Requery the home that is set with the dataVector.
 */
protected void queryHome() {

	clearSelection();
	getDataVector().queryHome();
	fireTableDataChanged();
}
/**
 * Remove anObject from the model's data collection.
 */
protected void removeElement(Object anObject) {

	getDataVector().removeElement(anObject);
}
/**
 * Remove the element at aRow from the model's data collection.
 */
protected void removeElementAt(int aRow) {
	getDataVector().removeElementAt(aRow);
}
/**
 *  Set the rowVector to be allInstances from aHome.
 */
public void setHome(PersistentHomeCollection aHome) {
	
	getDataVector().setHome(aHome);

	//force the table to repaint itself
	table.repaint();
	clearSelection();
	// Make all the new rows the right length and generate a notification.
	fireTableRowsInserted(0, getRowCount()-1);
		
}
	/**
	 *  This replaces the current dataVector instance variable with the
	 *  new Vector of rows, <i>newData</i>. <i>columnIdentifiers</i> are the names
	 *  of the new columns.  The first name in <i>columnIdentifiers</i> is
	 *  mapped to column 0 in <i>newData</i>. Each row in <i>newData</i>
	 *  is adjusted to match the number of columns in <i>columnIdentifiers</i>
	 *  either by truncating the Vector if it is too long, or adding
	 *  null values if it is too short.
	 *  <p>
	 *
	 * @param   newData         	The new data vector
	 * @param   columnIdentifiers   The identifiers of the columns
	 * @see #newDataAvailable()
	 * @see #getDataVector()
	 */
	public void setRowVector(Vector newData) {
		Vector newVector = null;
		newVector = (newData == null) ? new Vector(0) : newData;
		
		// Add the new rows.
		getDataVector().setSource(newVector);

		//force the table to repaint itself
		table.repaint();
		clearSelection();
		// Make all the new rows the right length and generate a notification.
		fireTableRowsInserted(0, getRowCount()-1);
		
	}

public void setShouldQueryAfterMergedIntoEvent(boolean aBoolean) {

	shouldQueryAfterMergedIntoEvent = aBoolean;
		
}
/**
 * set the transaction
 */
public void setTransaction(Transaction aTransaction) {
	
	if (transaction != null)
		transaction.removeActionListener(this);
		
	super.setTransaction(aTransaction);

	if (aTransaction != null)
		aTransaction.addActionListener(this);
}
public String toString() {
	return dataVector.toString();
}
}