/*****************************************************************************/
/*                                                                           */
/*                           OCO SOURCE MATERIALS                            */
/*                             IBM CONFIDENTIAL                              */
/*                                    OR                                     */
/*                        IBM CONFIDENTIAL RESTRICTED                        */
/*            WHEN COMBINED WITH THE AGGREGATED OCO SOURCE MODULES           */
/*                           FOR THIS PROGRAM PRODUCT                        */
/*                                                                           */
/*      VisualAge Generator Server for OS/2, AIX, HP-UX, and Windows NT      */
/*                          Version 3.0  5697-C28                            */
/*                    (C) COPYRIGHT IBM CORP. 1994,1997                      */
/*                                                                           */
/*****************************************************************************/
#ifndef FCWPARM_H
#define FCWPARM_H

// *********************************************************************
// Base for all objects that can be passed as call parms
// *********************************************************************

// For RPC
#define RPCNORMAL   0
#define RPCSQL      1
#define RPCMAP      2
#define RPCEZEDLPSB 3

struct RPCParm
{
  long     length;
  ItemType type;
  int      specialType;
  int      occurs;
  int      level;
  int      group;
  int      offset;
  long     numberOfFields;          /* Used to build data format descriptor*/
  short    RLIflag;
  short    NOIflag;
};
class LitParm;
class PDescriptor;

class Parameter
{
   public:
      Parameter();
      virtual ~Parameter();

      virtual long ParmSize() = 0;
      virtual char* ParmData() = 0;
      virtual Bool  isFileRecord() { return False; };

      virtual LIST(RPCParm*)& RPCList() = 0;
      virtual int& fNumberOfRPCEntries() = 0;
      virtual void SetupRpc() = 0;

      virtual ItemType  itemType() const { return tCHA; };
      virtual int       Decimals() const { return 0; };
      virtual int       Occurs()   const { return 1; };

      PDescriptor*      getDescriptor();

   private:
      PDescriptor*   _pDescriptor;
      void* pData;
};

// For RPC
#define MAX_PARMS 30
struct FCWCallRPCBlock
{
  struct
  {
    Parameter *parmPtr;
  } parm[MAX_PARMS];
};

/**********************************************************************/
/* Parameter Descriptor - This is used for callable functions         */
/**********************************************************************/
class Item;
class PDescriptor : public Parameter
{
  public:
    PDescriptor( Parameter* );
    ~PDescriptor();

    int&              fNumberOfRPCEntries();
    LIST(RPCParm*)&   RPCList();
    void              SetupRpc();
    long              ParmSize();
    char*             ParmData();

  private:
    int            ParmType( Parameter* );

    int            numberOfRPCEntries;
    LIST(RPCParm*) LRPCParm;                           /* List of RPC Parms*/

    Parameter*     item;
    void*          pData;

};

#endif
