/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.oa;

import com.ibm.CORBA.iiop.ThreadPool;
import com.ibm.ejs.EJSException;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.oa.EJSORBImpl;
import com.ibm.ejs.oa.EJSRootOAImpl;
import com.ibm.ejs.oa.LocationService;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ByteArray;
import com.ibm.websphere.management.AdminServiceFactory;
import java.util.Map;
import java.util.Properties;

class EJSServerORBImpl
extends EJSORBImpl {
    private static final int UUID_LENGTH = 16;
    private String serverName = null;
    private boolean isClone = false;
    private String modelName = null;
    private long cloneId = -1L;
    private static final TraceComponent tc = Tr.register(EJSServerORBImpl.class, "ObjectAdapter", "com.ibm.ws.runtime.runtime");
    private static final String REGISTER_WITH_LSD_PROPERTY_KEY = "com.ibm.websphere.management.registerServerIORWithLSD";

    EJSServerORBImpl(String string, String string2, String string3, int n, ThreadPool threadPool, Properties properties) throws EJSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{string, string2, string3, new Integer(n), properties});
        }
        if (string != null) {
            this.setModelName(string);
        }
        Properties properties2 = new Properties(defaultProperties);
        if (properties != null) {
            properties2.putAll((Map<?, ?>)properties);
        }
        EJSRootOAImpl eJSRootOAImpl = new EJSRootOAImpl();
        properties2.put("com.ibm.CORBA.ObjectResolver", eJSRootOAImpl);
        this.serverName = string2;
        properties2.put("com.ibm.CORBA.ServerName", string2);
        ByteArray byteArray = new ByteArray(string2.getBytes());
        int n2 = byteArray.hashCode();
        properties2.put("com.ibm.CORBA.ServerId", String.valueOf(n2 & Integer.MAX_VALUE));
        if (properties2.get("com.ibm.CORBA.ServerUUID") == null) {
            properties2.put("com.ibm.CORBA.ServerUUID", this.getUuid(byteArray.hashCode64()));
        }
        this.initializeORB(null, string3, n, properties2);
        eJSRootOAImpl.init(this.orb, null, string2);
        eJSRootOAImpl.setModelName(string);
        LocationService locationService = null;
        if (!EJSPlatformHelper.isZOS() && AdminServiceFactory.getAdminService().getProcessType().equals("ManagedProcess")) {
            boolean bl = true;
            String string4 = this.orb.getProperty("com.ibm.CORBA.ListenerPort");
            if (string4 != null) {
                try {
                    int n3 = Integer.parseInt(string4);
                    if (n3 > 0) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug(tc, "The ORB ListenerPort is set to a fixed port=" + n3);
                        }
                        String string5 = null;
                        string5 = System.getProperty(REGISTER_WITH_LSD_PROPERTY_KEY);
                        if (string5 == null) {
                            string5 = properties2.getProperty(REGISTER_WITH_LSD_PROPERTY_KEY);
                        }
                        if (string5 != null) {
                            if (string5.equalsIgnoreCase("false")) {
                                bl = false;
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "com.ibm.websphere.management.registerServerIORWithLSD=" + string5 + " - will not register with the LSD");
                                }
                            } else if (string5.equalsIgnoreCase("true")) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug(tc, "com.ibm.websphere.management.registerServerIORWithLSD=" + string5 + " - registering with the LSD");
                                }
                            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug(tc, "'" + string5 + "' is not valid for " + REGISTER_WITH_LSD_PROPERTY_KEY + " - ignored. " + "Choices are: 'true', 'false'.");
                            }
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (bl) {
                LocationService.initClient();
                locationService = LocationService.getLocationService();
                if (locationService != null) {
                    locationService.register(this.orb);
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                        Tr.exit(tc, "initialize");
                    }
                    throw new EJSException("Could not obtain LocationService instance.");
                }
            }
        }
        this.orb.setThreadPool(threadPool);
        if (locationService != null) {
            locationService.setThreadPool(threadPool);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    void terminate() {
        if (!EJSPlatformHelper.isZOS() && LocationService.getLocationService() != null) {
            LocationService.getLocationService().unregister();
        }
        if (this.orb != null) {
            this.orb.shutdown(false);
        }
    }

    final String getServerName() {
        return this.serverName;
    }

    final void setModelName(String string) {
        this.modelName = string;
        this.isClone = true;
    }

    final String getModelName() {
        return this.modelName;
    }

    final long getCloneId() {
        return this.cloneId;
    }

    final boolean isServerAClone() {
        return this.isClone;
    }

    protected String getUuid(long l) {
        String string = Long.toHexString(l);
        if (string.length() < 16) {
            for (int i = 16 - string.length(); i > 0; --i) {
                string = string + "0";
            }
        }
        return string;
    }
}

