/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ras;

import com.ibm.ras.RASIEvent;
import com.ibm.ras.RASTraceEvent;
import com.ibm.ras.RASTraceFormatter;

public class RASEnhancedTraceFormatter
extends RASTraceFormatter {
    private static final String S = "(C) Copyright IBM Corp. 1998.";
    private static final long serialVersionUID = 6797520221459165451L;
    private static final String SPACE = "  ";
    private static final String TIME = "Time:     ";
    private static final String CLASS_NAME = "Class:    ";
    private static final String METHOD_NAME = "Method:   ";
    private static final String THREAD_ID = "Thread ID:";
    private static final String LOGGER = "Logger:   ";

    public String format(RASIEvent rASIEvent) {
        StringBuffer stringBuffer = new StringBuffer(256);
        RASTraceEvent rASTraceEvent = (RASTraceEvent)rASIEvent;
        long l = rASTraceEvent.getTimeStamp();
        stringBuffer.append("Time:       " + this.getTime(l) + this.lineSep);
        Object object = rASTraceEvent.getAttribute("loggingClass");
        if (object != null) {
            stringBuffer.append("Class:      " + object + this.lineSep);
        }
        if ((object = rASTraceEvent.getAttribute("loggingMethod")) != null) {
            stringBuffer.append("Method:     " + object + this.lineSep);
        }
        if ((object = rASTraceEvent.getAttribute("threadID")) != null) {
            stringBuffer.append("Thread ID:  " + object + this.lineSep);
        }
        if ((object = rASTraceEvent.getAttribute("logger")) != null) {
            stringBuffer.append("Logger:     " + object + this.lineSep);
        }
        stringBuffer.append(SPACE + this.getText(rASTraceEvent));
        return stringBuffer.toString();
    }
}

