/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ssl;

import java.util.Map;
import java.util.Properties;

public class SSLConfigChangeEvent {
    private String selectionType;
    private String sslAlias;
    private String sslState;
    private Properties originalSSLConfig;
    private Properties changedSSLConfig;
    private Map connectionInfo;

    public SSLConfigChangeEvent(String string, Properties properties, String string2, Map map) {
        this.sslAlias = string;
        this.originalSSLConfig = properties;
        this.selectionType = string2;
        this.connectionInfo = map;
    }

    public String getSelectionType() {
        return this.selectionType;
    }

    public Map getConnectionInfo() {
        return this.connectionInfo;
    }

    public String getAlias() {
        return this.sslAlias;
    }

    public String getClientCertificateAlias() {
        if (this.originalSSLConfig != null) {
            return this.originalSSLConfig.getProperty("com.ibm.ssl.keyStoreClientAlias");
        }
        return null;
    }

    public String getServerCertificateAlias() {
        if (this.originalSSLConfig != null) {
            return this.originalSSLConfig.getProperty("com.ibm.ssl.keyStoreServerAlias");
        }
        return null;
    }

    public String getState() {
        return this.sslState;
    }

    public Properties getOriginalSSLConfig() {
        return this.originalSSLConfig;
    }

    public Properties getChangedSSLConfig() {
        return this.changedSSLConfig;
    }

    public void setChangedSSLConfig(Properties properties) {
        this.changedSSLConfig = properties;
    }

    public void setState(String string) {
        this.sslState = string;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SSLConfigChangeEvent: selectionType=");
        stringBuffer.append(this.selectionType);
        stringBuffer.append(", sslAlias=");
        stringBuffer.append(this.sslAlias);
        stringBuffer.append(", sslState=");
        stringBuffer.append(this.sslState);
        return stringBuffer.toString();
    }
}

