/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.buffermgmt.impl;

import com.ibm.nws.ejs.ras.Tr;
import com.ibm.nws.ejs.ras.TraceComponent;
import com.ibm.nws.ffdc.FFDCFilter;
import com.ibm.ws.buffermgmt.impl.PooledWsByteBufferImpl;
import com.ibm.ws.buffermgmt.impl.WsByteBufferPoolManagerImpl;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public class WsByteBufferImpl
implements WsByteBuffer,
Externalizable {
    private static final long serialVersionUID = 3794216509672320032L;
    protected ByteBuffer oByteBuffer = null;
    public ByteBuffer oWsBBDirect = null;
    private static final String CLASS_NAME = "com.ibm.ws.buffermgmt.impl.WsByteBufferImpl";
    protected boolean booleanReleaseCalled = false;
    private WsByteBufferPoolManagerImpl oWsByteBufferPoolManager = null;
    private boolean isDirectPool = false;
    private boolean readOnly = false;
    private boolean trusted;
    private boolean removedFromLeakDetection = false;
    private String ownerID = null;
    private long lastAccessTime = 0L;
    private static final TraceComponent tc = Tr.register(WsByteBufferImpl.class, "WsByteBuffer", "com.ibm.ws.buffermgmt.resources.wsbytebuffermessages");
    protected PooledWsByteBufferImpl wsBBRoot = null;

    public WsByteBufferImpl() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Created WsByteBufferImpl");
        }
    }

    public PooledWsByteBufferImpl getWsBBRoot() {
        return this.wsBBRoot;
    }

    public void setWsBBRoot(PooledWsByteBufferImpl pooledWsByteBufferImpl) {
        this.wsBBRoot = pooledWsByteBufferImpl;
    }

    public byte[] array() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "array(): returns oByteBuffer.array()", this.oByteBuffer);
        }
        return this.oByteBuffer.array();
    }

    public int arrayOffset() {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "arrayOffset(): returns oByteBuffer.arrayOffset()=" + this.oByteBuffer.arrayOffset());
        }
        return this.oByteBuffer.arrayOffset();
    }

    public WsByteBuffer compact() {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "compact(): before oByteBuffer.compact()", this);
        }
        this.oByteBuffer.compact();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "compact(): after oByteBuffer.compact()", this);
        }
        return this;
    }

    public int compareTo(Object object) {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.oByteBuffer.compareTo((Object)((WsByteBuffer)object).getWrappedByteBuffer());
    }

    public char getChar() {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.oByteBuffer.getChar();
    }

    public char getChar(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.oByteBuffer.getChar(n);
    }

    public WsByteBuffer putChar(char c) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.putChar(c);
        return this;
    }

    public WsByteBuffer putChar(int n, char c) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.putChar(n, c);
        return this;
    }

    public WsByteBuffer putChar(char[] cArray) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        return this.putChar(cArray, 0, cArray.length);
    }

    public WsByteBuffer putChar(char[] cArray, int n, int n2) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        if (n + n2 > cArray.length) {
            throw new IllegalArgumentException("Invalid Parameters: off=" + n + ", len=" + n2 + ", values.length=" + cArray.length);
        }
        for (int i = n; i < n + n2; ++i) {
            this.oByteBuffer.putChar(cArray[i]);
        }
        return this;
    }

    public double getDouble() {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.oByteBuffer.getDouble();
    }

    public double getDouble(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.oByteBuffer.getDouble(n);
    }

    public WsByteBuffer putDouble(double d) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.putDouble(d);
        return this;
    }

    public WsByteBuffer putDouble(int n, double d) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.putDouble(n, d);
        return this;
    }

    public float getFloat() {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.oByteBuffer.getFloat();
    }

    public float getFloat(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.oByteBuffer.getFloat(n);
    }

    public WsByteBuffer putFloat(float f) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.putFloat(f);
        return this;
    }

    public WsByteBuffer putFloat(int n, float f) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.putFloat(n, f);
        return this;
    }

    public int getInt() {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.oByteBuffer.getInt();
    }

    public int getInt(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.oByteBuffer.getInt(n);
    }

    public WsByteBuffer putInt(int n) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.putInt(n);
        return this;
    }

    public WsByteBuffer putInt(int n, int n2) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.putInt(n, n2);
        return this;
    }

    public long getLong() {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.oByteBuffer.getLong();
    }

    public long getLong(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.oByteBuffer.getLong(n);
    }

    public WsByteBuffer putLong(long l) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.putLong(l);
        return this;
    }

    public WsByteBuffer putLong(int n, long l) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.putLong(n, l);
        return this;
    }

    public short getShort() {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.oByteBuffer.getShort();
    }

    public short getShort(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.oByteBuffer.getShort(n);
    }

    public WsByteBuffer putShort(short s) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.putShort(s);
        return this;
    }

    public WsByteBuffer putShort(int n, short s) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.putShort(n, s);
        return this;
    }

    public WsByteBuffer putString(String string) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.put(string.getBytes());
        return this;
    }

    public boolean hasArray() {
        return this.oByteBuffer.hasArray();
    }

    public ByteOrder order() {
        return this.oByteBuffer.order();
    }

    public WsByteBuffer order(ByteOrder byteOrder) {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.order(byteOrder);
        return this;
    }

    public WsByteBuffer clear() {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.clear();
        return this;
    }

    public int capacity() {
        return this.oByteBuffer.capacity();
    }

    public WsByteBuffer flip() {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.flip();
        return this;
    }

    public byte get() {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.oByteBuffer.get();
    }

    public int position() {
        return this.oByteBuffer.position();
    }

    public WsByteBuffer position(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.position(n);
        return this;
    }

    public WsByteBuffer limit(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.limit(n);
        return this;
    }

    public int limit() {
        return this.oByteBuffer.limit();
    }

    public int remaining() {
        return this.oByteBuffer.remaining();
    }

    public WsByteBuffer mark() {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.mark();
        return this;
    }

    public WsByteBuffer reset() {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.reset();
        return this;
    }

    public WsByteBuffer rewind() {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.rewind();
        return this;
    }

    public boolean isReadOnly() {
        return this.oByteBuffer.isReadOnly();
    }

    public boolean hasRemaining() {
        return this.oByteBuffer.hasRemaining();
    }

    public WsByteBuffer get(byte[] byArray) {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.get(byArray);
        return this;
    }

    public WsByteBuffer get(byte[] byArray, int n, int n2) {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer.get(byArray, n, n2);
        return this;
    }

    public byte get(int n) {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.oByteBuffer.get(n);
    }

    public boolean isDirect() {
        return this.oByteBuffer.isDirect();
    }

    public WsByteBuffer put(byte by) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.put(by);
        return this;
    }

    public WsByteBuffer put(byte[] byArray) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.put(byArray);
        return this;
    }

    public WsByteBuffer put(byte[] byArray, int n, int n2) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.put(byArray, n, n2);
        return this;
    }

    public WsByteBuffer put(int n, byte by) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.put(n, by);
        return this;
    }

    public WsByteBuffer put(ByteBuffer byteBuffer) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.put(byteBuffer);
        return this;
    }

    public WsByteBuffer put(WsByteBuffer wsByteBuffer) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        this.oByteBuffer.put(wsByteBuffer.getWrappedByteBuffer());
        return this;
    }

    public WsByteBuffer put(WsByteBuffer[] wsByteBufferArray) {
        if (!this.trusted) {
            this.checkValidity();
            this.checkReadOnly();
        }
        for (int i = 0; i < wsByteBufferArray.length && wsByteBufferArray[i] != null; ++i) {
            this.put(wsByteBufferArray[i]);
        }
        return this;
    }

    public ByteBuffer getWrappedByteBuffer() {
        if (!this.trusted) {
            this.checkValidity();
        }
        return this.oByteBuffer;
    }

    public WsByteBuffer duplicate() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "duplicate");
        }
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.oWsByteBufferPoolManager != null) {
            return this.oWsByteBufferPoolManager.duplicate(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Did not find pool manager, returning null");
        }
        return null;
    }

    public void updateDuplicate(WsByteBufferImpl wsByteBufferImpl) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.readOnly) {
            wsByteBufferImpl.setReadOnly(true);
        }
        wsByteBufferImpl.setByteBuffer(this.oByteBuffer.duplicate());
    }

    public WsByteBuffer slice() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry(tc, "slice");
        }
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.oWsByteBufferPoolManager != null) {
            return this.oWsByteBufferPoolManager.slice(this);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug(tc, "Did not find pool manager, returning null");
        }
        return null;
    }

    public void updateSlice(WsByteBufferImpl wsByteBufferImpl) {
        if (!this.trusted) {
            this.checkValidity();
        }
        if (this.readOnly) {
            wsByteBufferImpl.setReadOnly(true);
        }
        wsByteBufferImpl.setByteBuffer(this.oByteBuffer.slice());
    }

    public void resetReleaseCalled() {
        this.booleanReleaseCalled = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Throwable throwable = null;
        StackTraceElement[] stackTraceElementArray = null;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && (stackTraceElementArray = (throwable = new Throwable()).getStackTrace()).length >= 2) {
            if (this.wsBBRoot == null) {
                Tr.debug(tc, "BUFFER RELEASED: Calling Element: " + stackTraceElementArray[1] + " Main ID: none");
            } else {
                Tr.debug(tc, "BUFFER RELEASED: Calling Element: " + stackTraceElementArray[1] + " Main ID: " + this.wsBBRoot.getID());
            }
        }
        if (this.wsBBRoot == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Released WsByteBuffer that was not allocated from the pool.It was either created from a wrapped buffer, or was larger than the pool.");
                String string = new String();
                for (int i = 0; i < stackTraceElementArray.length; ++i) {
                    string = string.concat(stackTraceElementArray[i].toString());
                }
            }
            return;
        }
        PooledWsByteBufferImpl pooledWsByteBufferImpl = this.wsBBRoot;
        synchronized (pooledWsByteBufferImpl) {
            if (this.booleanReleaseCalled) {
                Tr.event(tc, "Attempt to release WsByteBuffer that was already released");
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug(tc, "Attempt to release WsByteBuffer that was already released.  ");
                    Tr.debug(tc, "WsByteBuffer ID: " + this.wsBBRoot.getID());
                    String string = new String();
                    for (int i = 0; i < stackTraceElementArray.length; ++i) {
                        string = string.concat(stackTraceElementArray[i].toString());
                    }
                    Tr.debug(tc, "Stack Trace of extra release:\n" + string);
                }
                return;
            }
            if (this.oWsByteBufferPoolManager.getLeakDetectionInterval() > -1) {
                Object object = this.oWsByteBufferPoolManager.getLeakDetectionSyncObject();
                synchronized (object) {
                    this.booleanReleaseCalled = true;
                    --this.wsBBRoot.intReferenceCount;
                    this.releaseFromLeakDetection();
                    if (this.wsBBRoot.intReferenceCount == 0) {
                        this.oWsByteBufferPoolManager.release(this.wsBBRoot, this.isDirectPool, this.wsBBRoot.pool);
                    }
                }
            } else {
                this.booleanReleaseCalled = true;
                --this.wsBBRoot.intReferenceCount;
                if (this.wsBBRoot.intReferenceCount == 0) {
                    this.oWsByteBufferPoolManager.release(this.wsBBRoot, this.isDirectPool, this.wsBBRoot.pool);
                }
            }
        }
    }

    private void releaseFromLeakDetection() {
        if (this.wsBBRoot != null) {
            this.wsBBRoot.removeWsByteBuffer(this);
        }
        if (this.ownerID != null) {
            this.wsBBRoot.removeOwner(this.ownerID);
        }
    }

    public void setIsDirectPool(boolean bl) {
        this.isDirectPool = bl;
    }

    public boolean getIsDirectPool() {
        return this.isDirectPool;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public boolean getReadOnly() {
        return this.readOnly;
    }

    public void setOwnerID(String string) {
        this.ownerID = string;
        this.lastAccessTime = System.currentTimeMillis();
    }

    public String getOwnerID() {
        return this.ownerID;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public void setPoolManagerRef(WsByteBufferPoolManagerImpl wsByteBufferPoolManagerImpl) {
        this.oWsByteBufferPoolManager = wsByteBufferPoolManagerImpl;
        this.trusted = this.oWsByteBufferPoolManager.isTrustedUsers();
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        if (!this.trusted) {
            this.checkValidity();
        }
        this.oByteBuffer = byteBuffer;
    }

    private void checkReadOnly() {
        if (this.readOnly) {
            String string = "none";
            if (this.wsBBRoot != null) {
                string = this.wsBBRoot.getID().toString();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to update a read only WsByteBuffer.\nWsByteBuffer: ID: " + string + "\nBuffer: " + this.oByteBuffer);
            }
            ReadOnlyBufferException readOnlyBufferException = new ReadOnlyBufferException();
            FFDCFilter.processException((Throwable)readOnlyBufferException, "com.ibm.ws.buffermgmt.impl.WsByteBufferImpl.checkReadOnly", "1", this);
            throw readOnlyBufferException;
        }
    }

    private void checkValidity() {
        if (this.booleanReleaseCalled) {
            String string = "none";
            if (this.wsBBRoot != null) {
                string = this.wsBBRoot.getID().toString();
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Attempt to access WsByteBuffer that was already released.\nWsByteBuffer: ID: " + string + " Sub ID: " + this.oByteBuffer);
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid call to WsByteBuffer method.  Buffer has already been released.\nWsByteBuffer: ID: " + string + "\nBuffer: " + this.oByteBuffer);
            FFDCFilter.processException((Throwable)illegalArgumentException, "com.ibm.ws.buffermgmt.impl.WsByteBufferImpl.checkValidity", "1", this);
            throw illegalArgumentException;
        }
        if (this.ownerID != null) {
            this.lastAccessTime = System.currentTimeMillis();
        }
    }

    public void copyToDirectBuffer() {
        if (this.oByteBuffer.isDirect()) {
            this.oWsBBDirect = this.oByteBuffer;
            return;
        }
        if (this.oWsBBDirect == null) {
            this.oWsBBDirect = ByteBuffer.allocateDirect(this.oByteBuffer.capacity());
        }
        int n = this.oByteBuffer.position();
        int n2 = this.oByteBuffer.limit();
        int n3 = this.oByteBuffer.arrayOffset();
        this.oWsBBDirect.position(n);
        this.oWsBBDirect.limit(n2);
        this.oWsBBDirect.put(this.oByteBuffer.array(), n + n3, n2 - n);
        this.oWsBBDirect.position(n);
    }

    public void copyFromDirectBuffer(int n) {
        int n2 = this.oWsBBDirect.position();
        int n3 = this.oByteBuffer.position();
        this.oWsBBDirect.position(n3);
        if (n == -1) {
            this.oWsBBDirect.get(this.oByteBuffer.array(), n3 + this.oByteBuffer.arrayOffset(), this.oByteBuffer.remaining());
        } else if (n > 0) {
            this.oWsBBDirect.get(this.oByteBuffer.array(), n3 + this.oByteBuffer.arrayOffset(), n);
        }
        this.oByteBuffer.position(n2);
    }

    public void setParmsToDirectBuffer() {
        if (this.oByteBuffer.isDirect()) {
            this.oWsBBDirect = this.oByteBuffer;
            return;
        }
        if (this.oWsBBDirect == null) {
            this.oWsBBDirect = ByteBuffer.allocateDirect(this.oByteBuffer.capacity());
        }
        this.oWsBBDirect.position(this.oByteBuffer.position());
        this.oWsBBDirect.limit(this.oByteBuffer.limit());
    }

    public void setParmsFromDirectBuffer() {
        this.oByteBuffer.position(this.oWsBBDirect.position());
    }

    public String toString() {
        if (null == this.oByteBuffer) {
            return "[null]";
        }
        return this.oByteBuffer.toString();
    }

    public void removeFromLeakDetection() {
        if (this.ownerID != null) {
            this.releaseFromLeakDetection();
            if (this.wsBBRoot != null && this.wsBBRoot.pool != null) {
                this.wsBBRoot.pool.removeFromInUse(this.wsBBRoot);
            }
        }
        this.removedFromLeakDetection = true;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (!this.removedFromLeakDetection && TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event(tc, "Buffer being serialized but removeFromLeakDetection has not been called: " + this);
        }
        if (this.oByteBuffer.isDirect()) {
            objectOutput.writeObject("D");
        } else {
            objectOutput.writeObject("ND");
        }
        if (this.oByteBuffer.order() == ByteOrder.BIG_ENDIAN) {
            objectOutput.writeObject("B");
        } else {
            objectOutput.writeObject("L");
        }
        int n = this.oByteBuffer.position();
        int n2 = this.oByteBuffer.limit();
        this.oByteBuffer.position(0);
        this.oByteBuffer.limit(this.oByteBuffer.capacity());
        if (this.oByteBuffer.hasArray() && this.oByteBuffer.arrayOffset() == 0) {
            objectOutput.writeObject(this.oByteBuffer.array());
        } else {
            byte[] byArray = new byte[this.oByteBuffer.limit()];
            this.oByteBuffer.get(byArray);
            objectOutput.writeObject(byArray);
        }
        this.oByteBuffer.position(n);
        this.oByteBuffer.limit(n2);
        objectOutput.writeObject(Integer.toString(n));
        objectOutput.writeObject(Integer.toString(n2));
        if (this.readOnly) {
            objectOutput.writeObject("R");
        } else {
            objectOutput.writeObject("RW");
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        String string = (String)objectInput.readObject();
        String string2 = (String)objectInput.readObject();
        byte[] byArray = (byte[])objectInput.readObject();
        if (string.equals("ND")) {
            this.oByteBuffer = ByteBuffer.wrap(byArray);
            if (string2.equals("B")) {
                this.oByteBuffer.order(ByteOrder.BIG_ENDIAN);
            } else {
                this.oByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
        } else {
            this.oByteBuffer = ByteBuffer.allocateDirect(byArray.length);
            if (string2.equals("B")) {
                this.oByteBuffer.order(ByteOrder.BIG_ENDIAN);
            } else {
                this.oByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
            }
            this.oByteBuffer.put(byArray);
        }
        this.oByteBuffer.position(Integer.parseInt((String)objectInput.readObject()));
        this.oByteBuffer.limit(Integer.parseInt((String)objectInput.readObject()));
        String string3 = (String)objectInput.readObject();
        this.readOnly = string3.equals("R");
        this.oWsByteBufferPoolManager = (WsByteBufferPoolManagerImpl)WsByteBufferPoolManagerImpl.getRef();
        this.trusted = this.oWsByteBufferPoolManager.isTrustedUsers();
        this.removedFromLeakDetection = true;
    }
}

