/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloader;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.ws.classloader.ClassGraphState;
import com.ibm.ws.classloader.ClassLoaderManager;
import com.ibm.ws.classloader.ClassLoaderUtils;
import com.ibm.ws.classloader.JarClassLoader;
import com.ibm.ws.classloader.ReloadableClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.policy.DynamicPolicy;
import com.ibm.ws.security.policy.DynamicPolicyFactory;
import com.ibm.ws.util.PathUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleRef;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveWrappedException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.RuntimeClasspathEntry;
import org.eclipse.jst.j2ee.jca.Connector;

public class ClassGraph {
    private static TraceComponent tc = Tr.register(ClassGraph.class.getName(), "Websphere ClassLoader", null);
    protected ArrayList moduleNodes = new ArrayList();
    protected HashMap modulePathMap = new HashMap();
    protected ArrayList dependentPaths = new ArrayList();
    protected ClassLoader parent = null;
    protected JarClassLoader dependencyLoader = null;
    protected boolean singleWarClassLoader;
    protected boolean libDelegationMode = true;
    protected Map sharedLibClassPathMap = new HashMap();
    protected Map sharedLibNativeLibPathMap = new HashMap();
    protected ArrayList serverPaths = new ArrayList();

    public ClassGraph(ClassLoader classLoader, String[] stringArray, boolean bl, boolean bl2) {
        this(classLoader, bl, bl2);
        String[] stringArray2 = PathUtils.expandPaths((String[])stringArray);
        stringArray2 = ClassLoaderUtils.addDependentJars(stringArray2);
        this.sharedLibClassPathMap.put(null, stringArray2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>", this);
        }
    }

    public ClassGraph(ClassGraphState classGraphState) {
        this(classGraphState.parent, classGraphState.sharedLibClassPathMap, classGraphState.sharedLibNativeLibPathMap, classGraphState.libDelegationMode, classGraphState.singleWarClassLoader);
        this.dependencyLoader = classGraphState.previousDependencyLoader;
        this.serverPaths = classGraphState.previousServerPaths;
    }

    public ClassGraph(ClassLoader classLoader, String[] stringArray, String[] stringArray2, boolean bl, boolean bl2) {
        this(classLoader, stringArray, bl, bl2);
        this.sharedLibNativeLibPathMap.put(null, stringArray2);
    }

    public ClassGraph(ClassLoader classLoader, boolean bl, boolean bl2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{"parent=" + classLoader, "delegationMode=" + bl, "singleWarClassLoader=" + bl2});
        }
        this.parent = classLoader;
        this.libDelegationMode = bl;
        this.singleWarClassLoader = bl2;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>");
        }
    }

    public ClassGraph(ClassLoader classLoader, Map map, Map map2, boolean bl, boolean bl2) {
        this(classLoader, bl, bl2);
        Iterator iterator = map.keySet().iterator();
        String[] stringArray = null;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            stringArray = (String[])map.get(string);
            stringArray = PathUtils.expandPaths((String[])stringArray);
            stringArray = ClassLoaderUtils.addDependentJars(stringArray);
            this.sharedLibClassPathMap.put(string, stringArray);
        }
        this.sharedLibNativeLibPathMap.putAll(map2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "<init>", this);
        }
    }

    public ClassGraph(ClassLoader classLoader) {
        this(classLoader, new String[0], ClassLoaderManager.getDefaultDelegationMode(), true);
    }

    public void addModule(ModuleRef moduleRef) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addModule", moduleRef);
        }
        boolean bl = tc.isDebugEnabled();
        ModuleNode moduleNode = new ModuleNode();
        moduleNode.moduleRef = moduleRef;
        this.moduleNodes.add(moduleNode);
        ModuleFile moduleFile = moduleRef.getModuleFile();
        if (bl) {
            Tr.debug(tc, "adding module: " + moduleFile.getURI() + " isEJBJarFile=" + moduleFile.isEJBJarFile() + " isWARFile=" + moduleFile.isWARFile());
        }
        if (moduleFile.isApplicationClientFile()) {
            if (bl) {
                Tr.debug(tc, "module: " + moduleFile.getURI() + " is an application client module. skipping...");
            }
            return;
        }
        RuntimeClasspathEntry[] runtimeClasspathEntryArray = moduleFile.getLocalRuntimeClassPath();
        for (int i = 0; i < runtimeClasspathEntryArray.length; ++i) {
            String string = this.normalizePath(runtimeClasspathEntryArray[i].getAbsolutePath());
            if (bl) {
                Tr.debug(tc, "module: " + moduleFile.getURI() + " local path: " + string);
            }
            this.dependentPaths.remove(string);
            if (bl) {
                Tr.debug(tc, "module: " + moduleFile.getURI() + " adding " + string + " as a module path.");
            }
            this.modulePathMap.put(string, moduleNode);
            PathUtils.listAddNoDup((List)moduleNode.paths, (Object)string);
            PathUtils.listAddNoDup((List)moduleNode.localPaths, (Object)string);
        }
        RuntimeClasspathEntry[] runtimeClasspathEntryArray2 = moduleFile.getDependencyClassPath();
        for (int i = 0; i < runtimeClasspathEntryArray2.length; ++i) {
            String string = this.normalizePath(runtimeClasspathEntryArray2[i].getAbsolutePath());
            if (bl) {
                Tr.debug(tc, "module: " + moduleFile.getURI() + " dependency path: " + string);
            }
            PathUtils.listAddNoDup((List)moduleNode.paths, (Object)string);
            if (this.modulePathMap.get(string) != null) continue;
            PathUtils.listAddNoDup((List)this.dependentPaths, (Object)string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addModule", moduleRef);
        }
    }

    public JarClassLoader getDependencyClassLoader() {
        return this.dependencyLoader;
    }

    public void addUtilityJars(String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addUtilityJars", PathUtils.arrayToString((String[])stringArray));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = this.normalizePath(stringArray[i]);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "utility path: " + string);
            }
            if (this.modulePathMap.get(string) != null) continue;
            PathUtils.listAddNoDup((List)this.dependentPaths, (Object)string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addUtilityJars");
        }
    }

    public ClassLoader calculate(EARFile eARFile, String string) {
        return this.createClassLoaders(eARFile, string, true, null);
    }

    public void updateClassLoaders(EARFile eARFile, String string, ClassLoader classLoader) {
        this.createClassLoaders(eARFile, string, false, classLoader);
    }

    public void dispose() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "dispose", this);
        }
        this.moduleNodes.clear();
        this.modulePathMap.clear();
        this.dependentPaths.clear();
        this.sharedLibClassPathMap.clear();
        this.sharedLibNativeLibPathMap.clear();
        this.parent = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "dispose", this);
        }
    }

    protected String normalizePath(String string) {
        File file = new File(string);
        try {
            file = file.getCanonicalFile();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.classloader.ClassGraph.normalizePath", "200", this);
        }
        return file.getPath();
    }

    public ReloadableClassLoader lookupClassLoader(ModuleRef moduleRef) {
        for (int i = 0; i < this.moduleNodes.size(); ++i) {
            ModuleNode moduleNode = (ModuleNode)this.moduleNodes.get(i);
            if (moduleNode == null || moduleNode.moduleRef != moduleRef) continue;
            return moduleNode.classLoader;
        }
        return this.dependencyLoader;
    }

    private void processWARModule(EARFile eARFile, ClassLoader classLoader, JarClassLoader jarClassLoader, ModuleRef moduleRef, String[] stringArray, ModuleNode moduleNode, DynamicPolicy dynamicPolicy, String string, ArrayList arrayList) {
        StringBuffer stringBuffer;
        boolean bl = tc.isDebugEnabled();
        JarClassLoader jarClassLoader2 = null;
        if (bl) {
            Tr.debug(tc, "creating WarClassLoader paths=" + PathUtils.arrayToString((String[])stringArray));
        }
        String[] stringArray2 = new String[2];
        try {
            stringBuffer = new StringBuffer(moduleRef.getModuleFile().getBinariesPath());
            stringBuffer.append("/WEB-INF/");
            int n = stringBuffer.length();
            stringArray2[0] = stringBuffer.append("classes").toString();
            stringBuffer.setLength(n);
            stringArray2[1] = stringBuffer.append("lib").toString();
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException(fileNotFoundException, this.getClass().getName(), "232");
        }
        stringBuffer = new DynamicPolicy.Module("web", stringArray2, moduleRef.getUri(), null);
        String[] stringArray3 = (String[])this.sharedLibClassPathMap.get(moduleRef.getUri());
        if (bl) {
            Tr.debug(tc, "adding module shared library classpaths: " + PathUtils.arrayToString((String[])stringArray3));
        }
        String[] stringArray4 = (String[])this.sharedLibNativeLibPathMap.get(moduleRef.getUri());
        if (bl) {
            Tr.debug(tc, "adding native library paths: " + PathUtils.arrayToString((String[])stringArray4));
        }
        if (jarClassLoader == null) {
            moduleNode.classLoader = jarClassLoader2 = new JarClassLoader(stringArray, classLoader, ClassLoaderManager.getDefaultDelegationMode());
            if (stringArray3 != null) {
                jarClassLoader2.addPaths(stringArray3);
            }
            if (stringArray4 != null) {
                jarClassLoader2.addNativeLibPaths(stringArray4);
            }
            if (dynamicPolicy != null) {
                Map map = this.generateApplicationCodeSource(dynamicPolicy, eARFile, string, jarClassLoader2.getCodeSourcePermissions(), (DynamicPolicy.Module)stringBuffer);
                jarClassLoader2.setCodeSourcePermissions(map);
            }
        } else {
            jarClassLoader.addPaths(stringArray);
            this.addToServerPaths(stringArray);
            if (stringArray3 != null) {
                jarClassLoader.addPaths(stringArray3);
                this.addToServerPaths(stringArray3);
            }
            if (stringArray4 != null) {
                jarClassLoader.addNativeLibPaths(stringArray4);
            }
            moduleNode.classLoader = jarClassLoader;
            arrayList.add(stringBuffer);
        }
    }

    private void processEJBModule(ModuleRef moduleRef, String[] stringArray, ModuleNode moduleNode, ArrayList arrayList) {
        boolean bl = tc.isDebugEnabled();
        if (bl) {
            Tr.debug(tc, "adding EJB paths to dependencyLoader paths=" + PathUtils.arrayToString((String[])stringArray));
        }
        this.dependencyLoader.addPaths(stringArray);
        this.addToServerPaths(stringArray);
        moduleNode.classLoader = this.dependencyLoader;
        arrayList.add(new DynamicPolicy.Module("ejb", stringArray, moduleRef.getUri(), null));
    }

    protected ClassLoader createClassLoaders(EARFile eARFile, String string, boolean bl, ClassLoader classLoader) {
        Object object;
        String[] stringArray;
        String[] stringArray2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createClassLoaders", new Object[]{eARFile, string});
        }
        boolean bl2 = tc.isDebugEnabled();
        ClassLoader classLoader2 = null;
        JarClassLoader jarClassLoader = null;
        ArrayList<DynamicPolicy.Module> arrayList = new ArrayList<DynamicPolicy.Module>(this.moduleNodes.size());
        if (bl) {
            classLoader2 = this.parent;
            if (ClassLoaderManager.getSingleServerClassLoader()) {
                if (this.singleWarClassLoader) {
                    this.dependencyLoader = jarClassLoader = ClassLoaderManager.serverClassLoader;
                } else {
                    this.dependencyLoader = ClassLoaderManager.serverClassLoader;
                    classLoader2 = this.dependencyLoader;
                }
            } else {
                this.dependencyLoader = new JarClassLoader(new String[0], this.parent, this.libDelegationMode);
                if (this.singleWarClassLoader) {
                    jarClassLoader = this.dependencyLoader;
                } else {
                    classLoader2 = this.dependencyLoader;
                }
            }
        } else {
            classLoader2 = classLoader;
        }
        if (bl2) {
            Tr.debug(tc, "dependencyLoader=" + this.dependencyLoader);
            Tr.debug(tc, "warParent=" + classLoader2);
            Tr.debug(tc, "warGroup=" + jarClassLoader);
        }
        DynamicPolicy dynamicPolicy = DynamicPolicyFactory.getInstance();
        for (int i = 0; i < this.moduleNodes.size(); ++i) {
            stringArray2 = (String[])this.moduleNodes.get(i);
            stringArray = new String[stringArray2.localPaths.size()];
            stringArray2.localPaths.toArray(stringArray);
            object = stringArray2.moduleRef;
            if (object.isEJB()) {
                this.processEJBModule((ModuleRef)object, stringArray, (ModuleNode)stringArray2, arrayList);
                continue;
            }
            if (object.isWeb()) {
                this.processWARModule(eARFile, classLoader2, jarClassLoader, (ModuleRef)object, stringArray, (ModuleNode)stringArray2, dynamicPolicy, string, arrayList);
                continue;
            }
            if (object.isConnector()) {
                stringArray = PathUtils.expandPaths((String[])stringArray);
                this.dependencyLoader.addPaths(stringArray);
                this.addToServerPaths(stringArray);
                stringArray2.classLoader = this.dependencyLoader;
                try {
                    Connector connector = (Connector)object.getDeploymentDescriptor();
                    arrayList.add(new DynamicPolicy.Module("RARFile", stringArray, object.getUri(), (List)connector.getResourceAdapter().getSecurityPermissions()));
                }
                catch (ArchiveWrappedException archiveWrappedException) {}
                continue;
            }
            if (object.isClient()) {
                this.dependencyLoader.addPaths(stringArray);
                this.addToServerPaths(stringArray);
                stringArray2.classLoader = this.dependencyLoader;
                arrayList.add(new DynamicPolicy.Module("utility", stringArray, object.getUri(), null));
                continue;
            }
            System.out.println("unsupported module type=" + object);
            Thread.dumpStack();
        }
        String[] stringArray3 = this.dependentPaths.toArray(new String[this.dependentPaths.size()]);
        if (bl2) {
            Tr.debug(tc, "adding dependency loader paths: " + PathUtils.arrayToString((String[])stringArray3));
        }
        this.dependencyLoader.addPaths(stringArray3);
        this.addToServerPaths(stringArray3);
        arrayList.add(new DynamicPolicy.Module("utility", stringArray3, null, null));
        stringArray2 = (String[])this.sharedLibClassPathMap.get(null);
        if (bl2) {
            Tr.debug(tc, "adding library paths: " + PathUtils.arrayToString((String[])stringArray2));
        }
        this.dependencyLoader.addPaths(stringArray2);
        this.addToServerPaths(stringArray2);
        stringArray = (String[])this.sharedLibNativeLibPathMap.get(null);
        if (bl2) {
            Tr.debug(tc, "adding native library paths: " + PathUtils.arrayToString((String[])stringArray));
        }
        this.dependencyLoader.addNativeLibPaths(stringArray);
        if (dynamicPolicy != null) {
            object = this.generateApplicationCodeSource(dynamicPolicy, eARFile, string, this.dependencyLoader.getCodeSourcePermissions(), arrayList);
            this.dependencyLoader.setCodeSourcePermissions((Map)object);
            this.generateLibraryCodeSource(dynamicPolicy, this.dependencyLoader.getCodeSourcePermissions(), stringArray2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createClassLoaders", this);
        }
        return classLoader2;
    }

    public String[] getServerPaths() {
        if (ClassLoaderManager.getSingleServerClassLoader()) {
            return this.serverPaths.toArray(new String[0]);
        }
        return null;
    }

    private void addToServerPaths(String[] stringArray) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "addToServerPaths paths='" + PathUtils.arrayToString((String[])stringArray) + "'");
        }
        if (stringArray != null && stringArray.length != 0) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.serverPaths.add(stringArray[i]);
            }
        }
    }

    public String toString() {
        int n;
        int n2;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println(super.toString());
        printWriter.println("singleServerClassLoader: " + ClassLoaderManager.getSingleServerClassLoader());
        printWriter.println("singleWarClassLoader: " + this.singleWarClassLoader);
        printWriter.println("modules          : " + this.moduleNodes.size());
        printWriter.println("dependent paths  : " + this.dependentPaths.size());
        String[] stringArray = this.dependentPaths.iterator();
        while (stringArray.hasNext()) {
            printWriter.println("deppath: " + stringArray.next());
        }
        stringArray = (String[])this.sharedLibClassPathMap.get(null);
        if (stringArray == null) {
            printWriter.println("application shared library classpath: null");
        } else {
            printWriter.println("application shared library classpath size: " + stringArray.length);
            n2 = stringArray.length;
            for (int i = 0; i < n2; ++i) {
                printWriter.println("application shared library classpath: " + stringArray[i]);
            }
        }
        String[] stringArray2 = (String[])this.sharedLibNativeLibPathMap.get(null);
        if (stringArray2 == null) {
            printWriter.println("application shared library native library path: null");
        } else {
            printWriter.println("application shared library native library path size: " + stringArray2.length);
            n = stringArray2.length;
            for (n2 = 0; n2 < n; ++n2) {
                printWriter.println("application shared library native library path: " + stringArray2[n2]);
            }
        }
        n = this.moduleNodes.size();
        for (n2 = 0; n2 < n; ++n2) {
            String[] stringArray3;
            int n3;
            ModuleNode moduleNode = (ModuleNode)this.moduleNodes.get(n2);
            printWriter.println("module: " + moduleNode.moduleRef.getModuleFile().getURI());
            int n4 = moduleNode.localPaths.size();
            for (int i = 0; i < n4; ++i) {
                printWriter.println("   " + moduleNode.localPaths.get(i));
            }
            String[] stringArray4 = (String[])this.sharedLibClassPathMap.get(moduleNode.moduleRef.getUri());
            if (stringArray4 != null) {
                printWriter.println("   module shared library classpath size: " + stringArray4.length);
                n3 = stringArray4.length;
                for (n4 = 0; n4 < n3; ++n4) {
                    printWriter.println("   module shared library classpath: " + stringArray4[n2]);
                }
            }
            if ((stringArray3 = (String[])this.sharedLibNativeLibPathMap.get(moduleNode.moduleRef.getUri())) == null) continue;
            printWriter.println("   module shared library native library path size: " + stringArray3.length);
            int n5 = stringArray3.length;
            for (n3 = 0; n3 < n5; ++n3) {
                printWriter.println("   module shared library native library path: " + stringArray3[n2]);
            }
        }
        printWriter.flush();
        stringWriter.flush();
        return stringWriter.toString();
    }

    private Map generateApplicationCodeSource(DynamicPolicy dynamicPolicy, EARFile eARFile, String string, Map map, DynamicPolicy.Module module) {
        DynamicPolicy.Module[] moduleArray = new DynamicPolicy.Module[]{module};
        return this.generateApplicationCodeSource(dynamicPolicy, eARFile, string, map, moduleArray);
    }

    private Map generateApplicationCodeSource(DynamicPolicy dynamicPolicy, EARFile eARFile, String string, Map map, List list) {
        DynamicPolicy.Module[] moduleArray = new DynamicPolicy.Module[list.size()];
        list.toArray(moduleArray);
        return this.generateApplicationCodeSource(dynamicPolicy, eARFile, string, map, moduleArray);
    }

    private Map generateApplicationCodeSource(DynamicPolicy dynamicPolicy, EARFile eARFile, String string, Map hashMap, DynamicPolicy.Module[] moduleArray) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        try {
            DynamicPolicy.Application application = new DynamicPolicy.Application(eARFile.getBinariesPath(), string, moduleArray);
            HashMap<String, String> hashMap2 = new HashMap<String, String>();
            hashMap2.put("type", "application");
            hashMap2.put("application", (String)application);
            dynamicPolicy.getSecurityPolicy(hashMap2, hashMap);
        }
        catch (FileNotFoundException fileNotFoundException) {
            FFDCFilter.processException(fileNotFoundException, this.getClass().getName(), "356");
        }
        return hashMap;
    }

    private Map generateLibraryCodeSource(DynamicPolicy dynamicPolicy, Map hashMap, String[] stringArray) {
        if (hashMap == null) {
            hashMap = new HashMap();
        }
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("type", "library");
        hashMap2.put("classpath", stringArray);
        dynamicPolicy.getSecurityPolicy(hashMap2, hashMap);
        return hashMap;
    }

    public ClassGraphState getState() {
        return new ClassGraphState(this.parent, this.dependencyLoader, this.serverPaths, this.sharedLibClassPathMap, this.sharedLibNativeLibPathMap, this.libDelegationMode, this.singleWarClassLoader);
    }

    static class ModuleNode {
        ArrayList paths = new ArrayList();
        ArrayList localPaths = new ArrayList();
        JarClassLoader classLoader = null;
        ModuleRef moduleRef;

        ModuleNode() {
        }

        public String toString() {
            return "module: " + this.moduleRef.getModuleFile().getName();
        }
    }
}

