/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.channel;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.cluster.channel.ChannelSelectionAdapterImpl;
import com.ibm.ws.cluster.selection.TargetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.channel.framework.CFEndPoint;
import com.ibm.wsspi.channel.framework.CFEndPointCriteria;
import com.ibm.wsspi.cluster.EndPoint;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.cluster.Target;
import com.ibm.wsspi.cluster.adapter.IdentityMapping;
import com.ibm.wsspi.cluster.adapter.channel.ChannelTarget;
import java.util.HashMap;
import java.util.Map;

public class ChannelTargetImpl
implements ChannelTarget {
    private static final TraceComponent tc = Tr.register(ChannelTargetImpl.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    public static final Map distinction = new HashMap();
    private Target target;
    private CFEndPointCriteria criteria;
    private boolean inRetry = false;
    private EndPoint[] wlmEndPoints = null;
    private CFEndPoint[] cfEndpoints = null;

    public ChannelTargetImpl(Target target, CFEndPointCriteria cFEndPointCriteria) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ChannelTargetImpl", new Object[]{target, cFEndPointCriteria});
        }
        if (target == null) {
            throw new IllegalArgumentException("The Target passed in was null.");
        }
        if (cFEndPointCriteria == null) {
            throw new IllegalArgumentException("The CFEndPointCriteria passed in was null.");
        }
        this.target = target;
        this.criteria = cFEndPointCriteria;
        this.wlmEndPoints = target.matchEndPoints(distinction);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ChannelTargetImpl");
        }
    }

    public Identity getMemberIdentity() {
        return this.target.getMemberIdentity();
    }

    public Identity[] getClusterIdentities() {
        return this.target.getClusterIdentities();
    }

    public CFEndPoint[] getCFEndpoints() {
        if (this.cfEndpoints == null) {
            this.cfEndpoints = new CFEndPoint[this.wlmEndPoints.length];
            for (int i = 0; i < this.wlmEndPoints.length; ++i) {
                this.cfEndpoints[i] = IdentityMapping.getCFEndPoint(this.wlmEndPoints[i].getIdentity());
            }
        }
        return this.cfEndpoints;
    }

    public EndPoint[] getEndpoints() {
        return this.wlmEndPoints;
    }

    public CFEndPointCriteria getCFEndPointCriteria() {
        return this.criteria;
    }

    public CFEndPoint getCFEndPoint() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCFEndPoint");
        }
        CFEndPoint cFEndPoint = null;
        if (ChannelSelectionAdapterImpl.cfService == null) {
            Tr.error(tc, "NLSKEY_CFS_UNAVAILABLE");
            throw new IllegalStateException("The ChannelFrameworkService is not available for determining the best end point.");
        }
        cFEndPoint = ChannelSelectionAdapterImpl.cfService.determineBestEndPoint(this.getCFEndpoints(), this.criteria);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCFEndPoint", cFEndPoint);
        }
        return cFEndPoint;
    }

    public boolean isMemberInProcess() {
        boolean bl;
        block3: {
            bl = false;
            try {
                TargetImpl targetImpl = (TargetImpl)this.target;
                if (targetImpl != null) {
                    bl = targetImpl.isTargetInProcess();
                }
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, ChannelTargetImpl.class.getName() + ".isMemberInProcess", "193", this);
                if (!tc.isEventEnabled()) break block3;
                Tr.debug(tc, "unexpected", classCastException);
            }
        }
        return bl;
    }

    public boolean isMemberInHost() {
        boolean bl;
        block4: {
            bl = false;
            try {
                TargetImpl targetImpl = (TargetImpl)this.target;
                if (targetImpl != null) {
                    bl = targetImpl.isTargetInHost();
                }
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, ChannelTargetImpl.class.getName() + ".isMemberInHost", "215", this);
                if (!tc.isEventEnabled()) break block4;
                Tr.debug(tc, "unexpected", classCastException);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isMemberInHost: " + bl);
        }
        return bl;
    }

    public boolean isMemberInServer() {
        boolean bl;
        block3: {
            bl = false;
            try {
                TargetImpl targetImpl = (TargetImpl)this.target;
                if (targetImpl != null) {
                    bl = targetImpl.isTargetInServer();
                }
            }
            catch (ClassCastException classCastException) {
                FFDCFilter.processException((Throwable)classCastException, ChannelTargetImpl.class.getName() + ".isMemberInServer", "236", this);
                if (!tc.isEventEnabled()) break block3;
                Tr.debug(tc, "unexpected", classCastException);
            }
        }
        return bl;
    }

    static {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "version : ", "1.26 ");
        }
        distinction.put("TYPE", "CHANNEL");
        distinction.put("COMPONENT", "CF");
    }
}

