/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cluster.topography;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cluster.topography.Contract;
import com.ibm.websphere.cluster.topography.Description;
import com.ibm.websphere.cluster.topography.DescriptionCallback;
import com.ibm.websphere.cluster.topography.DescriptionKey;
import com.ibm.ws.cluster.topography.DescriptionManagerA;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;

public class FileSystemDescriptionManager
extends DescriptionManagerA {
    private static final TraceComponent tc = Tr.register(FileSystemDescriptionManager.class, "WLM", "com.ibm.ws.wlm.resources.WLMNLSMessages");
    private static final String TOP_DIRECTORY = "com.ibm.wsspi.cluster.shared-file";
    private Map fileList = new WeakHashMap();
    private File top = null;
    private String id = "local";

    public void setIdentifier(String string) {
        if (tc.isEventEnabled()) {
            Tr.event(tc, "setIdentifier", string);
        }
        this.id = string;
    }

    public void setTopDirectory(String string) {
        File file;
        if (tc.isEventEnabled()) {
            Tr.event(tc, "setTopDirectory", string);
        }
        if (!(file = new File(string)).exists()) {
            file.mkdir();
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("The directory given by com.ibm.wsspi.cluster.shared-file must be a directory.  " + file);
        }
        this.top = file;
    }

    public FileSystemDescriptionManager() {
        this(null);
    }

    public FileSystemDescriptionManager(String string) {
        this.top = string == null ? new File(System.getProperty(TOP_DIRECTORY, File.separator + "tmp" + File.separator + "cluster-data")) : new File(string);
        if (!this.top.exists()) {
            this.top.mkdir();
        }
        if (!this.top.isDirectory()) {
            throw new IllegalArgumentException("The directory given by com.ibm.wsspi.cluster.shared-file must be a directory.  " + this.top);
        }
        if (tc.isEventEnabled()) {
            Tr.event(tc, "<init>", new Object[]{this.top, this.id});
        }
        Thread thread = new Thread(new FileModifiedNotifier(10000L));
        thread.setDaemon(true);
        thread.start();
    }

    public synchronized Description getDescription(DescriptionKey descriptionKey, String string) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Description description = this.getDescription(descriptionKey);
        if (description == null) {
            description = super.getDescription(descriptionKey, string);
            String string2 = this.keyToString(descriptionKey);
            this.fileList.put(string2, new FileDescriptor());
        }
        return description;
    }

    public void lookupClusterCallback(String string, Contract contract, URL uRL, DescriptionCallback descriptionCallback, Object object) {
    }

    public boolean publish(String string, byte[] byArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "publish", string);
        }
        File file = null;
        boolean bl = true;
        try {
            file = this.getFile(string);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.flush();
            fileOutputStream.close();
            this.update(file.getParentFile());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            bl = false;
        }
        catch (IOException iOException) {
            System.err.println(string.length() + " " + string + "\n" + file);
            iOException.printStackTrace();
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "publish", file);
        }
        return bl;
    }

    private void update(File file) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "update", file);
        }
        try {
            String string = file.getName();
            File[] fileArray = new File[]{file};
            if (file.isDirectory()) {
                fileArray = file.listFiles();
            }
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i].length() == 0L) continue;
                FileInputStream fileInputStream = new FileInputStream(fileArray[i]);
                byte[][] byArray = new byte[1][0];
                do {
                    byte[] byArray2 = new byte[fileInputStream.available() + byArray[0].length];
                    System.arraycopy(byArray[0], 0, byArray2, 0, byArray[0].length);
                    fileInputStream.read(byArray2);
                    byArray[0] = byArray2;
                } while (fileInputStream.available() > 0);
                fileInputStream.close();
                this.update(string, byArray);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "update");
        }
    }

    private File getFile(String string) throws IOException {
        File file;
        File file2 = this.top;
        File file3 = new File(file2, string);
        if (!file3.exists()) {
            file3.mkdir();
        }
        if (!(file = new File(file3, this.id)).exists()) {
            file.createNewFile();
        }
        return file;
    }

    private final class FileDescriptor {
        private long lastModified = -1L;

        private FileDescriptor() {
        }
    }

    private final class FileModifiedNotifier
    implements Runnable {
        private final long interval;

        private FileModifiedNotifier(long l) {
            this.interval = l;
        }

        public void run() {
            File[] fileArray = FileSystemDescriptionManager.this.top.listFiles();
            while (true) {
                fileArray = FileSystemDescriptionManager.this.top.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    FileDescriptor fileDescriptor = (FileDescriptor)FileSystemDescriptionManager.this.fileList.get(fileArray[i].getName());
                    if (fileDescriptor == null) continue;
                    File[] fileArray2 = fileArray[i].listFiles();
                    if (fileArray2 != null) {
                        boolean bl = false;
                        for (int j = 0; j < fileArray2.length; ++j) {
                            long l = fileArray2[i].lastModified();
                            if (fileDescriptor.lastModified >= l) continue;
                            fileDescriptor.lastModified = l;
                            bl = true;
                        }
                        if (!bl) continue;
                        FileSystemDescriptionManager.this.update(fileArray[i]);
                        continue;
                    }
                    fileArray[i].delete();
                }
                try {
                    Thread.sleep(this.interval);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

