/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.genericbnf.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.genericbnf.impl.GenericUtils;
import com.ibm.ws.genericbnf.impl.QuickGenericMatcher;
import com.ibm.wsspi.genericbnf.GenericKeys;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BinaryHeaderNode {
    private static final TraceComponent tc = Tr.register(BinaryHeaderNode.class, "GenericBNF", "com.ibm.ws.genericbnf.resources.genericbnfMessages");
    protected char myChar;
    private int minSize = 100000;
    private int maxSize = 0;
    private List stringCollection = new ArrayList();
    private Map keyMap = new HashMap();
    private char[][] charMap;
    private Object[] values;
    private byte[][] byteMap;
    private boolean isNull = false;
    private boolean initialized = false;
    private boolean isCaseSensitive = true;
    private boolean makeAllLower = true;

    public BinaryHeaderNode(char c, boolean bl) {
        this.myChar = c;
        this.isCaseSensitive = false;
        this.makeAllLower = bl;
    }

    public BinaryHeaderNode(char c) {
        this.myChar = c;
        this.isCaseSensitive = true;
    }

    public boolean add(GenericKeys genericKeys) {
        if (this.initialized) {
            throw new RuntimeException("Error in the order of setting this thing up");
        }
        String string = genericKeys.getName();
        if (!this.isCaseSensitive) {
            string = this.makeAllLower ? string.toLowerCase() : string.toUpperCase();
        }
        this.stringCollection.add(string);
        this.keyMap.put(string, genericKeys);
        return this.stringCollection.contains(string);
    }

    public boolean add(String string, Object object) {
        if (this.initialized) {
            throw new RuntimeException("Error in the order of setting this thing up");
        }
        if (!this.isCaseSensitive) {
            string = this.makeAllLower ? string.toLowerCase() : string.toUpperCase();
        }
        this.stringCollection.add(string);
        this.keyMap.put(string, object);
        return this.stringCollection.contains(string);
    }

    public void init() {
        this.initialized = true;
        if (this.stringCollection.size() <= 0) {
            this.isNull = true;
            this.stringCollection = null;
            this.keyMap = null;
            return;
        }
        int n = this.stringCollection.size();
        String[] stringArray = new String[n];
        this.stringCollection.toArray(stringArray);
        this.stringCollection = null;
        this.values = new Object[n];
        this.byteMap = new byte[n][];
        this.charMap = new char[n][];
        for (int i = 0; i < n; ++i) {
            if (null == stringArray[i]) {
                throw new RuntimeException("String is null for key");
            }
            this.values[i] = this.keyMap.get(stringArray[i]);
            if (null == this.values[i]) {
                throw new RuntimeException("values entry is be null");
            }
            this.byteMap[i] = GenericUtils.getEnglishBytes(stringArray[i]);
            this.charMap[i] = stringArray[i].toCharArray();
            if (stringArray[i].length() < this.minSize) {
                this.minSize = stringArray[i].length();
            }
            if (stringArray[i].length() <= this.maxSize) continue;
            this.maxSize = stringArray[i].length();
        }
        this.keyMap = null;
    }

    public Object match(byte[] byArray) {
        return this.match(byArray, 0, byArray.length);
    }

    public Object match(byte[] byArray, int n, int n2) {
        if (this.isNull || n2 < this.minSize || n2 > this.maxSize) {
            return null;
        }
        int n3 = n + n2 - 1;
        for (int i = 0; i < this.values.length; ++i) {
            byte[] byArray2 = this.byteMap[i];
            if (byArray2.length != n2 || !this.isEqual(byArray[n3], byArray2[byArray2.length - 1])) continue;
            boolean bl = true;
            int n4 = byArray2.length - 2;
            int n5 = n3 - 1;
            while (n5 > n) {
                if (!this.isEqual(byArray[n5], byArray2[n4])) {
                    bl = false;
                    break;
                }
                --n5;
                --n4;
            }
            if (!bl) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Byte value [" + GenericUtils.getEnglishString(byArray, n, n + n2) + "] matches key: " + this.values[i]);
            }
            return this.values[i];
        }
        return null;
    }

    public Object match(char[] cArray) {
        return this.match(cArray, 0, cArray.length);
    }

    public Object match(char[] cArray, int n, int n2) {
        if (this.isNull || n2 < this.minSize || n2 > this.maxSize) {
            return null;
        }
        int n3 = n + n2 - 1;
        for (int i = 0; i < this.values.length; ++i) {
            char[] cArray2 = this.charMap[i];
            if (cArray2.length != n2 || !this.isEqual(cArray[n3], cArray2[cArray2.length - 1])) continue;
            boolean bl = true;
            int n4 = cArray2.length - 2;
            int n5 = n3 - 1;
            while (n5 > n) {
                if (!this.isEqual(cArray[n5], cArray2[n4])) {
                    bl = false;
                    break;
                }
                --n5;
                --n4;
            }
            if (!bl) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug(tc, "Char value [" + new String(cArray, n, n2) + "] matches key: " + this.values[i]);
            }
            return this.values[i];
        }
        return null;
    }

    private boolean isEqual(byte by, byte by2) {
        return by == by2 || !this.isCaseSensitive && this.isEqualCaseInsensitive(by, by2);
    }

    private boolean isEqual(char c, char c2) {
        return c == c2 || !this.isCaseSensitive && this.isEqualCaseInsensitive(c, c2);
    }

    private boolean isEqualCaseInsensitive(int n, int n2) {
        int n3 = this.makeAllLower ? QuickGenericMatcher.normalizeToLower(n) : QuickGenericMatcher.normalizeToUpper(n);
        return n3 == n2;
    }
}

