/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.logging.object;

import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.LevelConstants;
import com.ibm.ws.logging.object.WsLogRecord;
import com.ibm.ws.logging.object.WsLogRecordFactory;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.events.cbe.impl.EventFactoryImpl;
import org.eclipse.hyades.logging.events.cbe.util.EventFormatter;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class WsLogRecordHelper {
    private static final int svClassVersion = 3;

    public static void writeEventToStream(LogRecord logRecord, DataOutputStream dataOutputStream) throws IOException {
        WsLogRecordHelper.writeEventToStreamInCBEFormat(logRecord, dataOutputStream);
    }

    public static WsLogRecord readEventFromStream(DataInputStream dataInputStream) throws IOException {
        return WsLogRecordHelper.readEventFromStreamInCBEFormat(dataInputStream);
    }

    private static WsLogRecord readEventFromStreamInCBEFormat(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n < 3) {
            return WsLogRecordHelper.readLegacyEventFromStream(dataInputStream, n);
        }
        CommonBaseEventLogRecord commonBaseEventLogRecord = null;
        try {
            String string = dataInputStream.readUTF();
            CommonBaseEvent commonBaseEvent = EventFormatter.eventFromCanonicalXML(string);
            commonBaseEventLogRecord = new CommonBaseEventLogRecord(commonBaseEvent);
        }
        catch (Exception exception) {
            commonBaseEventLogRecord = null;
        }
        return WsLogRecordFactory.getWsLogRecordIfConvertible(commonBaseEventLogRecord);
    }

    private static void writeEventToStreamInCBEFormat(LogRecord logRecord, DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(3);
        CommonBaseEventLogRecord commonBaseEventLogRecord = WsLogRecordFactory.convertToCBELogRecord(logRecord);
        CommonBaseEvent commonBaseEvent = commonBaseEventLogRecord.getCommonBaseEvent();
        String string = EventFormatter.toCanonicalXMLString(commonBaseEvent, false);
        dataOutputStream.writeUTF(string);
    }

    static WsLogRecord readLegacyEventFromStream(DataInputStream dataInputStream, int n) throws IOException {
        WsLogRecord wsLogRecord;
        int n2;
        String string = dataInputStream.readUTF();
        String string2 = dataInputStream.readUTF();
        String string3 = dataInputStream.readUTF();
        String string4 = dataInputStream.readUTF();
        String string5 = dataInputStream.readUTF();
        String string6 = dataInputStream.readUTF();
        String string7 = dataInputStream.readUTF();
        String string8 = dataInputStream.readUTF();
        String string9 = dataInputStream.readUTF();
        String string10 = dataInputStream.readUTF();
        String string11 = dataInputStream.readUTF();
        String string12 = dataInputStream.readUTF();
        String string13 = dataInputStream.readUTF();
        long l = dataInputStream.readLong();
        Level level = WsLogRecordHelper.mapTypeToLevel(dataInputStream.readInt());
        int n3 = dataInputStream.readInt();
        Object[] objectArray = null;
        if (n3 != 0) {
            objectArray = new String[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                objectArray[n2] = dataInputStream.readUTF();
            }
        }
        n2 = dataInputStream.readInt();
        byte[] byArray = null;
        if (n2 != 0) {
            byArray = new byte[n2];
            dataInputStream.read(byArray, 0, n2);
        }
        String string14 = null;
        if (n == 2) {
            string14 = dataInputStream.readUTF();
        }
        if ((wsLogRecord = WsLogRecordFactory.createWsLogRecord(EventFactoryImpl.getInstance(), level, string10, objectArray, string14, string6, string11, null, null, string, string2, string3, null, Level.ALL.intValue(), string5)) == null) {
            return null;
        }
        wsLogRecord.setVersion(string4);
        try {
            wsLogRecord.setThreadID(Integer.parseInt(string7, 16));
        }
        catch (Throwable throwable) {
            wsLogRecord.setThreadID(-1);
        }
        wsLogRecord.setProcessId(string8);
        wsLogRecord.setProcessName(string9);
        wsLogRecord.setStackTrace(string12);
        wsLogRecord.setCorrelationId(string13);
        wsLogRecord.setMillis(l);
        if (byArray != null) {
            wsLogRecord.setRawData(byArray);
        }
        return wsLogRecord;
    }

    private static Level mapTypeToLevel(int n) {
        if (n < 0 || n >= WsLogRecordFactory.LevelTypesForRASEventTypes.length) {
            n = 8;
        }
        return WsLevel.LEVELS[LevelConstants.DISTINCT_LEVELS[WsLogRecordFactory.LevelTypesForRASEventTypes[n]]];
    }
}

