/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.repository;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.websphere.management.repository.DocumentContentSource;
import com.ibm.websphere.management.repository.DocumentDigest;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.repository.ConfigStructureHelper;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

class AppInfo {
    private static TraceComponent tc = Tr.register(AppInfo.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    String name = null;
    String earName = null;
    boolean distribute = true;
    String deploymentURI = null;
    DocumentDigest prevDigest = null;
    ConfigRepository repository = null;

    AppInfo(String string, String string2) {
        this.name = string2;
        this.deploymentURI = "cells/" + string + "/applications/" + string2 + "/deployment.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        InputStream inputStream = null;
        ApplicationDeployment applicationDeployment = null;
        try {
            Object object;
            if (this.repository == null) {
                this.repository = ConfigRepositoryFactory.getConfigRepository();
            }
            if (!(object = this.repository.getDigest(this.deploymentURI)).equals(this.prevDigest)) {
                DocumentContentSource documentContentSource = this.repository.extract(this.deploymentURI);
                inputStream = documentContentSource.getSource();
                applicationDeployment = this.loadDeployment(inputStream);
                this.earName = ConfigStructureHelper.getEarName(applicationDeployment.getBinariesURL());
                this.distribute = applicationDeployment.isEnableDistribution();
                this.prevDigest = documentContentSource.getDocument().getDigest();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this.deploymentURI);
                    Tr.debug(tc, "EAR name is " + this.earName);
                    Tr.debug(tc, "distribution is " + this.distribute);
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.AppInfo.loadDeployment", "88", this);
        }
        finally {
            if (applicationDeployment != null) {
                Resource resource = applicationDeployment.eResource();
                ResourceSet resourceSet = resource.getResourceSet();
                EList eList = resourceSet.getResources();
                eList.remove(resource);
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.AppInfo.loadDeployment", "101", this);
            }
        }
    }

    private ApplicationDeployment loadDeployment(InputStream inputStream) {
        ApplicationDeployment applicationDeployment = null;
        try {
            WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
            URI uRI = URI.createURI("deployment.xml");
            Resource resource = wASResourceSetImpl.createResource(uRI);
            HashMap hashMap = new HashMap();
            resource.load(inputStream, hashMap);
            Deployment deployment = (Deployment)resource.getContents().get(0);
            if (deployment == null) {
                throw new AdminException("Unable to load deployment document");
            }
            applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.management.repository.AppInfo.loadDeployment", "119", this);
        }
        return applicationDeployment;
    }

    public boolean getDistribute() {
        return this.distribute;
    }

    public String getEarName() {
        return this.earName;
    }

    public String getName() {
        return this.name;
    }
}

