/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.management.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;

public class ConfigLimits {
    private static TraceComponent _tc = Tr.register(ConfigLimits.class, "Admin", null);
    private static final String CONFIG_LIMITS_FILE_PATH = "properties" + File.separator + "cctl.dat";
    private static final int CURRENT_FILE_VERSION = 0;
    private static final byte[] FILE_HEADER = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int DEFAULT_CLUSTER_LIMIT = -1;
    private static final int DEFAULT_CLUSTER_MEMBER_LIMIT = -1;
    private static final Object _configLimitsLock = new Object();
    private static ConfigLimits _configLimits = null;
    private String _fileName;
    private byte[] _fileHeader = new byte[FILE_HEADER.length];
    private short _fileVersion;
    private short _maxNumberOfClusters;
    private short _maxNumberOfClusterMembers;
    private long _checksum;
    private boolean _haveData = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigLimits createConfigLimits() throws AdminException {
        Object object = _configLimitsLock;
        synchronized (object) {
            if (_configLimits == null) {
                _configLimits = new ConfigLimits();
            }
        }
        return _configLimits;
    }

    ConfigLimits() throws AdminException {
        String string = System.getProperty("was.install.root");
        if (string == null) {
            AdminException adminException = new AdminException("The property, was.install.root, is not set as a System property.");
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "ConfigLimits(): was.install.root property not set.", adminException);
            }
            FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.util.ConfigLimits.ConfigLimits()", "122", this);
            throw adminException;
        }
        this._fileName = string + File.separator + CONFIG_LIMITS_FILE_PATH;
        this.readInData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readInData() throws AdminException {
        ConfigLimits configLimits = this;
        synchronized (configLimits) {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "readInData");
            }
            try {
                block14: {
                    File file = new File(this._fileName);
                    if (file.exists()) {
                        if (!file.isDirectory()) {
                            FileInputStream fileInputStream = new FileInputStream(file);
                            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                            dataInputStream.read(this._fileHeader);
                            this.verifyHeader();
                            this._fileVersion = dataInputStream.readShort();
                            this._maxNumberOfClusters = dataInputStream.readShort();
                            this._maxNumberOfClusterMembers = dataInputStream.readShort();
                            this._checksum = dataInputStream.readLong();
                            long l = this.createChecksum();
                            if (l != this._checksum) {
                                AdminException adminException = new AdminException("Config limits data is corrupted.");
                                if (_tc.isDebugEnabled()) {
                                    Tr.debug(_tc, "readInData: Config limits data is corrupted.", adminException);
                                }
                                FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.util.ConfigLimits.readInData", "118", this);
                                throw adminException;
                            }
                            fileInputStream.close();
                            break block14;
                        } else {
                            AdminException adminException = new AdminException("File " + this._fileName + " is a directory.");
                            if (_tc.isEventEnabled()) {
                                Tr.event(_tc, "readInData: file name resolves to a directory.", adminException);
                            }
                            FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.util.ConfigLimits.readInData", "122", this);
                            throw adminException;
                        }
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "readInData: file does not exist");
                    }
                    System.arraycopy(FILE_HEADER, 0, this._fileHeader, 0, FILE_HEADER.length);
                    this._fileVersion = 0;
                    this._maxNumberOfClusters = (short)-1;
                    this._maxNumberOfClusterMembers = (short)-1;
                    this._checksum = this.createChecksum();
                }
                this._haveData = true;
            }
            catch (AdminException adminException) {
                if (!_tc.isEntryEnabled()) throw adminException;
                Tr.exit(_tc, "readInData: Received AdminException: " + adminException);
                throw adminException;
            }
            catch (EOFException eOFException) {
                AdminException adminException = new AdminException(eOFException, "Reached premature end-of-file when attempting to read config limit data.");
                if (!_tc.isEntryEnabled()) throw adminException;
                Tr.exit(_tc, "readInData: Received EOFException:", eOFException);
                throw adminException;
            }
            catch (Exception exception) {
                AdminException adminException = new AdminException(exception, "Encountered error when attempting to read config limit data.");
                if (!_tc.isEntryEnabled()) throw adminException;
                Tr.exit(_tc, "readInData: Received Exception:", exception);
                throw adminException;
            }
            if (!_tc.isEntryEnabled()) return;
            Tr.exit(_tc, "readInData");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOutData() throws AdminException {
        ConfigLimits configLimits = this;
        synchronized (configLimits) {
            if (_tc.isEntryEnabled()) {
                Tr.entry(_tc, "writeOutData");
            }
            try {
                if (!this._haveData) {
                    AdminException adminException = new AdminException("Config limit data has not yet been read or initialized.");
                    if (_tc.isEntryEnabled()) {
                        Tr.exit(_tc, "writeOutData: Data not read or initialized.", adminException);
                    }
                    throw adminException;
                }
                File file = new File(this._fileName);
                if (file.isDirectory()) {
                    AdminException adminException = new AdminException("File " + this._fileName + " is a directory.");
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "writeOutData: file name resolves to a directory.", adminException);
                    }
                    FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.util.ConfigLimits.writeOutData", "196", this);
                    throw adminException;
                }
                FileOutputStream fileOutputStream = new FileOutputStream(this._fileName, false);
                DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
                dataOutputStream.write(FILE_HEADER, 0, FILE_HEADER.length);
                dataOutputStream.writeShort(this._fileVersion);
                dataOutputStream.writeShort(this._maxNumberOfClusters);
                dataOutputStream.writeShort(this._maxNumberOfClusterMembers);
                this._checksum = this.createChecksum();
                dataOutputStream.writeLong(this._checksum);
                dataOutputStream.flush();
                fileOutputStream.close();
            }
            catch (AdminException adminException) {
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "writeOutData: Received AdminException: " + adminException);
                }
                throw adminException;
            }
            catch (Exception exception) {
                AdminException adminException = new AdminException(exception, "Encountered error when attempting to write config limit data.");
                if (_tc.isEntryEnabled()) {
                    Tr.exit(_tc, "writeOutData: Received Exception.", adminException);
                }
                throw adminException;
            }
            if (_tc.isEntryEnabled()) {
                Tr.exit(_tc, "writeOutData");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getMaxNumberOfClusters() throws AdminException {
        ConfigLimits configLimits = this;
        synchronized (configLimits) {
            if (!this._haveData) {
                AdminException adminException = new AdminException("Config limit data has not yet been read or initialized.");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getMaxNumberOfClusters: Data not read or initialized.", adminException);
                }
                throw adminException;
            }
            return this._maxNumberOfClusters;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getMaxNumberOfClusterMembers() throws AdminException {
        ConfigLimits configLimits = this;
        synchronized (configLimits) {
            if (!this._haveData) {
                AdminException adminException = new AdminException("Config limit data has not yet been read or initialized.");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getMaxNumberOfClusterMembers: Data not read or initialized.", adminException);
                }
                throw adminException;
            }
            return this._maxNumberOfClusterMembers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxNumberOfClusters(short s) throws AdminException {
        ConfigLimits configLimits = this;
        synchronized (configLimits) {
            if (s < -1) {
                AdminException adminException = new AdminException("Value for maxNumberOfClusters is outof range: " + s);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getMaxNumberOfClusters: Value out of range: " + s, adminException);
                }
                throw adminException;
            }
            this._maxNumberOfClusters = s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxNumberOfClusterMembers(short s) throws AdminException {
        ConfigLimits configLimits = this;
        synchronized (configLimits) {
            if (s < -1) {
                AdminException adminException = new AdminException("Value for maxNumberOfClusterMembers is outof range: " + s);
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "getMaxNumberOfClusterMembers: Value out of range: " + s, adminException);
                }
                throw adminException;
            }
            this._maxNumberOfClusterMembers = s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNumberOfClustersWithinLimit(short s) throws AdminException {
        ConfigLimits configLimits = this;
        synchronized (configLimits) {
            boolean bl;
            if (!this._haveData) {
                AdminException adminException = new AdminException("Config limit data has not yet been read or initialized.");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "isNumberOfClustersWithinLimit: Data not read or initialized.", adminException);
                }
                throw adminException;
            }
            boolean bl2 = bl = this._maxNumberOfClusters == -1 || s <= this._maxNumberOfClusters;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "isNumberOfClustersWithinLimit: " + bl, new String[]{"num=" + s, "max=" + this._maxNumberOfClusters});
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNumberOfClusterMembersWithinLimit(short s) throws AdminException {
        ConfigLimits configLimits = this;
        synchronized (configLimits) {
            boolean bl;
            if (!this._haveData) {
                AdminException adminException = new AdminException("Config limit data has not yet been read or initialized.");
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "isNumberOfClusterMembersWithinLimit: Data not read or initialized.", adminException);
                }
                throw adminException;
            }
            boolean bl2 = bl = this._maxNumberOfClusterMembers == -1 || s <= this._maxNumberOfClusterMembers;
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "isNumberOfClusterMembersWithinLimit: " + bl, new String[]{"num=" + s, "max=" + this._maxNumberOfClusterMembers});
            }
            return bl;
        }
    }

    private void verifyHeader() throws AdminException {
        for (int i = 0; i < FILE_HEADER.length; ++i) {
            if (this._fileHeader[i] == FILE_HEADER[i]) continue;
            AdminException adminException = new AdminException("File header incorrect.");
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "verifyHeader: File header incorrect.", adminException);
            }
            FFDCFilter.processException((Throwable)adminException, "com.ibm.ws.management.util.ConfigLimits.verifyHeader", "365", this);
            throw adminException;
        }
    }

    long createChecksum() {
        long l = (long)(Math.pow(this._fileVersion + 4, 3.2) * 11.0 / 3.0) + (long)(Math.pow(Math.abs(this._maxNumberOfClusters + 4) + 4, 7.2) * 17.0 / 3.0) + (long)(Math.pow(Math.abs(this._maxNumberOfClusterMembers + 4) + 3, 6.25) * 11.0 / 6.0);
        return l;
    }
}

