/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordEncodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.SASPropFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropFilePasswordEncoder {
    public static void main(String[] stringArray) {
        Object object;
        Closeable closeable;
        Object object2;
        File file;
        if (stringArray.length != 2 || stringArray[0] == null || stringArray[1] == null) {
            System.out.println("USAGE:  java PropFilePasswordEncoder file_name password_properties_list");
            System.out.println("        java PropFilePasswordEncoder file_name -SAS");
            System.exit(1);
        }
        String string = stringArray[0].trim();
        String string2 = stringArray[1].trim();
        if (string.length() == 0 || string2.length() == 0) {
            System.out.println("USAGE:  java PropFilePasswordEncoder file_name password_properties_list");
            System.out.println("        java PropFilePasswordEncoder file_name -SAS");
            System.exit(1);
        }
        if (!(file = new File(string)).isAbsolute()) {
            file = new File(file.getAbsolutePath());
        }
        if (!file.exists()) {
            System.out.println("ERROR:  invalid target file == " + file.toString());
            System.exit(1);
        }
        Properties properties = null;
        ArrayList<String> arrayList = null;
        FileInputStream fileInputStream = null;
        boolean bl = false;
        if (string2.equalsIgnoreCase("-SAS")) {
            properties = new Properties();
            try {
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "106");
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException2) {
                        FFDCFilter.processException(iOException2, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "115");
                    }
                }
                System.out.println("ERROR:  cannot load properties from target file == " + file.toString());
                System.exit(1);
            }
            try {
                bl = SASPropFile.encodePropPasswords(properties);
            }
            catch (InvalidPasswordEncodingException invalidPasswordEncodingException) {
                FFDCFilter.processException((Throwable)((Object)invalidPasswordEncodingException), "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "131");
                System.out.println("ERROR:  invalid password encoding exception");
                System.exit(1);
            }
        } else {
            if (string2 == null || string2.length() == 0) {
                System.out.println("ERROR:  password properties list is null or empty");
                System.exit(1);
            }
            object2 = null;
            closeable = null;
            arrayList = new ArrayList<String>();
            try {
                fileInputStream = new FileInputStream(file);
                object2 = new InputStreamReader(fileInputStream);
                closeable = new BufferedReader((Reader)object2);
                String string3 = ((BufferedReader)closeable).readLine();
                while (string3 != null) {
                    arrayList.add(string3);
                    string3 = ((BufferedReader)closeable).readLine();
                }
                ((BufferedReader)closeable).close();
                closeable = null;
                ((InputStreamReader)object2).close();
                object2 = null;
                fileInputStream.close();
                fileInputStream = null;
            }
            catch (IOException iOException) {
                FFDCFilter.processException(iOException, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "168");
                try {
                    if (closeable != null) {
                        ((BufferedReader)closeable).close();
                    }
                    if (object2 != null) {
                        ((InputStreamReader)object2).close();
                    }
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                }
                catch (IOException iOException3) {
                    FFDCFilter.processException(iOException3, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "180");
                }
                System.out.println("ERROR:  cannot load properties from target file == " + file.toString());
                System.exit(1);
            }
            boolean bl2 = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (object == null) continue;
                String string4 = ((String)object).trim();
                for (int i = 0; i < arrayList.size(); ++i) {
                    String string5;
                    int n;
                    String string6 = ((String)arrayList.get(i)).trim();
                    if (string6.startsWith("#") && string6.length() == 0 || (n = string6.indexOf(61)) == -1 || !(string5 = string6.substring(0, n).trim()).equals(object)) continue;
                    String string7 = string6.substring(n + 1).trim();
                    bl2 = true;
                    if (string7.length() <= 0) continue;
                    String string8 = PasswordUtil.passwordEncode(string7);
                    if (string8 == null) {
                        System.out.println("ERROR:  invalid password encoding exception");
                        System.exit(1);
                    }
                    if (string8.equals(string7)) continue;
                    bl = true;
                    arrayList.set(i, string5 + "=" + string8);
                }
            }
            if (!bl2) {
                System.out.println("ERROR:  no password properties in specified list were found in target file");
                System.exit(1);
            }
        }
        if (!bl) {
            System.out.println("NOTE:  all specified passwords already encoded in target file == " + file.toString());
            System.exit(0);
        }
        object2 = new File(file.toString() + ".bak");
        try {
            closeable = new FileInputStream(file);
            FileOutputStream fileOutputStream = new FileOutputStream((File)object2);
            int n = ((FileInputStream)closeable).available();
            object = new byte[n];
            ((FileInputStream)closeable).read((byte[])object, 0, n);
            fileOutputStream.write((byte[])object, 0, ((Object)object).length);
            ((FileInputStream)closeable).close();
            fileOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("ERROR:  File not found");
            fileNotFoundException.printStackTrace();
            System.exit(1);
        }
        catch (IOException iOException) {
            System.out.println("File i/o error");
            iOException.printStackTrace();
            System.exit(1);
        }
        if (!((File)object2).exists()) {
            System.out.println("ERROR:  cannot create backup file == " + ((File)object2).toString());
            System.exit(1);
        }
        closeable = null;
        OutputStreamWriter outputStreamWriter = null;
        BufferedWriter bufferedWriter = null;
        try {
            closeable = new FileOutputStream(file);
            if (string2.equalsIgnoreCase("-SAS")) {
                SASPropFile.saveConfig(properties, (FileOutputStream)closeable);
            } else {
                outputStreamWriter = new OutputStreamWriter((OutputStream)closeable);
                bufferedWriter = new BufferedWriter(outputStreamWriter);
                if (arrayList != null) {
                    for (int i = 0; i < arrayList.size(); ++i) {
                        bufferedWriter.write((String)arrayList.get(i) + "\n");
                    }
                }
                bufferedWriter.close();
                bufferedWriter = null;
                outputStreamWriter.close();
                outputStreamWriter = null;
            }
            ((FileOutputStream)closeable).close();
            closeable = null;
        }
        catch (IOException iOException) {
            FFDCFilter.processException(iOException, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "310");
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                if (closeable != null) {
                    ((FileOutputStream)closeable).close();
                }
            }
            catch (IOException iOException4) {
                FFDCFilter.processException(iOException4, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "322");
            }
            System.out.println("ERROR:  cannot save properties to target file == " + file.toString());
            System.exit(1);
        }
        System.exit(0);
    }
}

