/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtension;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtensionFactory;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;

public final class ServerIdentityHelper {
    private static final TraceComponent tc = Tr.register(ServerIdentityHelper.class, "Security", "com.ibm.ejs.resources.security");
    private WSLoginLocalOSExtension _extension;
    private static final ServerIdentityHelper helper = new ServerIdentityHelper();

    public static ServerIdentityHelper getServerIdentityHelper() {
        return helper;
    }

    private ServerIdentityHelper() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        try {
            this._extension = (WSLoginLocalOSExtension)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return WSLoginLocalOSExtensionFactory.getInstance();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.ws.security.util.ServerIdentityHelper.<init>", "81", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to acquire local OS extension helper", privilegedActionException);
            }
            this._extension = null;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public synchronized Object push() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "push");
        }
        Object object = null;
        if (this.isApplicationSyncEnabled()) {
            try {
                object = AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        Subject subject = ServerIdentityHelper.this._extension.getLocalOSOwnSubject();
                        return ServerIdentityHelper.this._extension.setAppLocalOSThreadID(subject);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                SecurityException securityException = new SecurityException("Unable to associate server subject with OS thread");
                securityException.initCause(securityException.getCause());
                FFDCFilter.processException((Throwable)securityException, "com.ibm.ws.security.util.ServerIdentityHelper.push", "118", this);
                throw securityException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "push", object);
        }
        return object;
    }

    public synchronized void pop(final Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "pop", object);
        }
        if (object != null) {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        ServerIdentityHelper.this._extension.restoreAppLocalOSThreadID(object);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                SecurityException securityException = new SecurityException("Unable to disassociate server subject from the OS thread");
                securityException.initCause(securityException.getCause());
                FFDCFilter.processException((Throwable)securityException, "com.ibm.ws.security.util.ServerIdentityHelper.pop", "152", this);
                throw securityException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "pop");
        }
    }

    private boolean isApplicationSyncEnabled() {
        boolean bl;
        boolean bl2 = bl = this._extension != null && this._extension.isThreadLocalApplicationSyncEnabled();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Application sync enabled: " + bl);
        }
        return bl;
    }
}

