/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.channel.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.jsse2.ProtoSSLEngineResult;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.channel.impl.SSLConnectionLink;
import com.ibm.ws.ssl.channel.impl.SSLHandshakeCompletedCallback;
import com.ibm.ws.ssl.channel.impl.SSLUtils;
import com.ibm.wsspi.buffermgmt.WsByteBuffer;

public class SSLQueuedHandshake
implements Runnable {
    private static final String CLASS_NAME = "com.ibm.ws.ssl.channel.imp.SSLQueuedHandshake";
    protected static final TraceComponent tc = Tr.register(SSLUtils.class, "SSLChannel", "com.ibm.ws.ssl.channel.resources.sslchannelmessages");
    private SSLConnectionLink connLink;
    private WsByteBuffer netBuffer;
    private WsByteBuffer decryptedNetBuffer;
    private WsByteBuffer appBuffer;
    private WsByteBuffer encryptedAppBuffer;
    private ProtoSSLEngineResult result;
    private SSLHandshakeCompletedCallback handshakeCallback;

    public SSLQueuedHandshake(SSLConnectionLink sSLConnectionLink, WsByteBuffer wsByteBuffer, WsByteBuffer wsByteBuffer2, WsByteBuffer wsByteBuffer3, WsByteBuffer wsByteBuffer4, ProtoSSLEngineResult protoSSLEngineResult, SSLHandshakeCompletedCallback sSLHandshakeCompletedCallback) {
        this.connLink = sSLConnectionLink;
        this.netBuffer = wsByteBuffer;
        this.decryptedNetBuffer = wsByteBuffer2;
        this.appBuffer = wsByteBuffer3;
        this.encryptedAppBuffer = wsByteBuffer4;
        this.result = protoSSLEngineResult;
        this.handshakeCallback = sSLHandshakeCompletedCallback;
    }

    public void run() {
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Should be off DecoratedCRThread now so doing SSL handshake.");
            }
            SSLUtils.handleHandshake(this.connLink, this.netBuffer, this.decryptedNetBuffer, this.appBuffer, this.encryptedAppBuffer, this.result, this.handshakeCallback, true);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, CLASS_NAME, "507", this.connLink);
        }
    }
}

