/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.engine.components.net;

import com.ibm.ws.webservices.engine.WebServicesProperties;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPSTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.DefaultHTTPTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.SecureTransportClientProperties;
import com.ibm.ws.webservices.engine.components.net.TransportClientProperties;
import java.util.Hashtable;
import org.apache.commons.logging.Log;

public class TransportClientPropertiesFactory {
    protected static Log log = LogFactory.getLog(TransportClientPropertiesFactory.class.getName());
    private static Hashtable factories = new Hashtable();

    public static synchronized TransportClientProperties create(String string) {
        TransportClientProperties transportClientProperties = (TransportClientProperties)factories.get(string);
        if (transportClientProperties == null) {
            if (string.equalsIgnoreCase("http")) {
                transportClientProperties = (TransportClientProperties)WebServicesProperties.newInstance(TransportClientProperties.class);
            } else if (string.equalsIgnoreCase("https")) {
                transportClientProperties = (SecureTransportClientProperties)WebServicesProperties.newInstance(SecureTransportClientProperties.class);
            }
            if (transportClientProperties != null) {
                factories.put(string, transportClientProperties);
            }
        }
        return transportClientProperties;
    }

    static {
        WebServicesProperties.setClassOverrideProperty(TransportClientProperties.class, "webservices.transportClientProperties");
        WebServicesProperties.setClassDefault(TransportClientProperties.class, "com.ibm.ws.webservices.engine.components.net.DefaultHTTPTransportClientProperties");
        WebServicesProperties.setClassOverrideProperty(SecureTransportClientProperties.class, "webservices.securetransportClientProperties");
        WebServicesProperties.setClassDefault(SecureTransportClientProperties.class, "com.ibm.ws.webservices.engine.components.net.DefaultHTTPSTransportClientProperties");
        WebServicesProperties.setClassDefault(TransportClientProperties.class, DefaultHTTPTransportClientProperties.class.getName());
        WebServicesProperties.setClassDefault(SecureTransportClientProperties.class, DefaultHTTPSTransportClientProperties.class.getName());
    }
}

