/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.webservice.wscbnd.ClientBinding;
import com.ibm.etools.webservice.wscext.ComponentScopedRefs;
import com.ibm.etools.webservice.wscext.WsClientExtension;
import com.ibm.ws.exception.ConfigurationError;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.webservices.WebServicesException;
import com.ibm.ws.webservices.configuration.WASEngineConfigurationProvider;
import com.ibm.ws.webservices.configuration.WebServicesEngineConfigurationGenerator;
import com.ibm.ws.webservices.engine.EngineConfiguration;
import com.ibm.ws.webservices.engine.client.ClientEngine;
import com.ibm.ws.webservices.engine.client.ClientEngineFactory;
import com.ibm.ws.webservices.engine.deployment.wsdd.WSDDDeployment;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.metadata.ClientModuleMetaData;
import com.ibm.ws.webservices.metadata.ClientServiceMetaData;
import com.ibm.wsspi.webservices.models.WSModels;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.Reference;
import org.eclipse.jst.j2ee.common.QName;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.eclipse.jst.j2ee.webservice.wsclient.ServiceRef;

public class ClientEntityMetaData {
    private static final TraceComponent _tc = Tr.register(ClientEntityMetaData.class, "WebServices", "com.ibm.ws.webservices.resources.webservicesMessages");
    private String componentName;
    private Map services = new HashMap();
    private ClientModuleMetaData moduleMetaData;
    private WSDDDeployment deployment;
    private EngineConfiguration configuration;
    private ClientEngine engine;

    ClientEntityMetaData(String string, ClientModuleMetaData clientModuleMetaData) {
        this.componentName = string;
        this.moduleMetaData = clientModuleMetaData;
    }

    public void destroy() {
        if (this.services != null) {
            Iterator iterator = this.services.values().iterator();
            while (iterator.hasNext()) {
                ClientServiceMetaData clientServiceMetaData = (ClientServiceMetaData)iterator.next();
                if (clientServiceMetaData == null) continue;
                clientServiceMetaData.destroy();
            }
            this.services.clear();
            this.services = null;
        }
        this.moduleMetaData = null;
        if (this.engine != null) {
            this.engine.destroy();
            this.engine = null;
            this.configuration = null;
            this.deployment = null;
        }
    }

    ClientModuleMetaData getParentMetaData() {
        return this.moduleMetaData;
    }

    private WSDDDeployment getDeployment() {
        if (this.deployment == null) {
            this.deployment = WebServicesEngineConfigurationGenerator.createClientDeployment(this.getPorts());
        }
        return this.deployment;
    }

    public synchronized EngineConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new WASEngineConfigurationProvider(this.getDeployment());
        }
        return this.configuration;
    }

    public synchronized ClientEngine getEngine() {
        if (this.engine == null) {
            this.engine = ClientEngineFactory.getEngine(this.getConfiguration());
        }
        return this.engine;
    }

    public String getName() {
        return this.componentName;
    }

    public ClientServiceMetaData newService(String string) {
        ClientServiceMetaData clientServiceMetaData = new ClientServiceMetaData(string, this);
        this.services.put(clientServiceMetaData.getName(), clientServiceMetaData);
        return clientServiceMetaData;
    }

    public ClientServiceMetaData getService(String string) {
        return (ClientServiceMetaData)this.services.get(string);
    }

    public Map getServices() {
        return this.services;
    }

    public ClientServiceMetaData newService(ServiceRef serviceRef) {
        ClientServiceMetaData clientServiceMetaData = this.newService(serviceRef.getServiceRefName());
        QName qName = serviceRef.getServiceQname();
        if (qName != null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Getting ServiceQName from 109 DD.");
            }
            clientServiceMetaData.setQName(QNameTable.createQName(qName.getNamespaceURI(), qName.getLocalPart()));
        }
        if (serviceRef.getServiceInterface() != null) {
            clientServiceMetaData.setServiceInterface(serviceRef.getServiceInterface().getJavaName());
        }
        clientServiceMetaData.setJaxrpcMappingFileName(serviceRef.getJaxrpcMappingFile());
        if (clientServiceMetaData.getWsdlFileName() == null && serviceRef.getWsdlFile() != null) {
            clientServiceMetaData.setWsdlFileName(serviceRef.getWsdlFile());
        }
        if (serviceRef.getHandlers().size() > 0) {
            clientServiceMetaData.addHandlers(serviceRef.getHandlers());
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Found a service-ref w/name of " + clientServiceMetaData.getName());
            Tr.debug(_tc, "ServiceQName being used: " + clientServiceMetaData.getQName());
            Tr.debug(_tc, "ServiceInterface is: " + clientServiceMetaData.getServiceInterface());
        }
        return clientServiceMetaData;
    }

    protected LoadStrategy getLoadStrategy() {
        return this.moduleMetaData.getLoadStrategy();
    }

    protected ClassLoader getClassLoader() {
        return this.moduleMetaData.getClassLoader();
    }

    public Collection getPorts() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.getServices().values().iterator();
        while (iterator.hasNext()) {
            ClientServiceMetaData clientServiceMetaData = (ClientServiceMetaData)iterator.next();
            arrayList.addAll(clientServiceMetaData.getPorts());
        }
        return arrayList;
    }

    public void bindServiceRefs(Context context) {
        Iterator iterator = this.services.values().iterator();
        while (iterator.hasNext()) {
            ClientServiceMetaData clientServiceMetaData = (ClientServiceMetaData)iterator.next();
            try {
                clientServiceMetaData.bind(context);
            }
            catch (NamingException namingException) {
                FFDCFilter.processException((Throwable)namingException, "com.ibm.ws.webservices.metadata.ClientEntityMetaData.bindServiceRefs", "218", this);
                Tr.error(_tc, "error.binding.service.refs", namingException);
            }
        }
    }

    public void bindBindingsAndExtensions(String string, String string2) throws RuntimeError {
        if (_tc.isDebugEnabled()) {
            Tr.debug(_tc, "Processing Web Services client bindings");
        }
        try {
            ClientBinding clientBinding = WSModels.getWSClientBinding(this.getLoadStrategy(), string);
            WsClientExtension wsClientExtension = WSModels.getWSClientExtension(this.getLoadStrategy(), string2);
            if (clientBinding != null || wsClientExtension != null) {
                if (this.componentName == null) {
                    this.extendServiceRefs(clientBinding == null ? null : clientBinding.getServiceRefs(), wsClientExtension == null ? null : wsClientExtension.getServiceRefs());
                } else {
                    Object[] objectArray;
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "Bindings for Service Refs for Component w/name=" + this.componentName);
                    }
                    com.ibm.etools.webservice.wscbnd.ComponentScopedRefs componentScopedRefs = ClientEntityMetaData.getComponentBinding(clientBinding, this.componentName);
                    ComponentScopedRefs componentScopedRefs2 = ClientEntityMetaData.getComponentExtension(wsClientExtension, this.componentName);
                    if (componentScopedRefs == null) {
                        objectArray = new Object[]{"ClientBinding", string};
                        Tr.warning(_tc, "notContain.componentScopedRefs", (Object)objectArray);
                    }
                    if (componentScopedRefs2 == null) {
                        objectArray = new Object[]{"WsClientExtension", string};
                        Tr.warning(_tc, "notContain.componentScopedRefs", (Object)objectArray);
                    }
                    this.extendServiceRefs(componentScopedRefs == null ? null : componentScopedRefs.getServiceRefs(), componentScopedRefs2 == null ? null : componentScopedRefs2.getServiceRefs());
                }
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.ws.webservices.client.ClientEntityMetaData.bindBindingsAndExtensions", "269", this);
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "Exception: ", exception);
            }
            throw new RuntimeError(exception);
        }
    }

    public void loadNow() {
        Iterator iterator = this.getServices().values().iterator();
        while (iterator.hasNext()) {
            ClientServiceMetaData clientServiceMetaData = (ClientServiceMetaData)iterator.next();
            clientServiceMetaData.getWsdlDoc();
            clientServiceMetaData.getSeiToPortTypeMapping();
        }
    }

    public ClientServiceMetaData getClientServiceMetaData(Reference reference) throws WebServicesException {
        String string = ClientServiceMetaData.getServiceName(reference);
        ClientServiceMetaData clientServiceMetaData = this.getService(string);
        if (clientServiceMetaData == null) {
            String string2 = "ClientServiceMetaData for service " + string + " is not available";
            Tr.error(_tc, "internal.error", string2);
            throw new WebServicesException(string2);
        }
        return clientServiceMetaData;
    }

    private static com.ibm.etools.webservice.wscbnd.ComponentScopedRefs getComponentBinding(ClientBinding clientBinding, String string) {
        com.ibm.etools.webservice.wscbnd.ComponentScopedRefs componentScopedRefs = null;
        if (clientBinding != null) {
            int n = clientBinding.getComponentScopedRefs().size();
            for (int i = 0; i < n; ++i) {
                com.ibm.etools.webservice.wscbnd.ComponentScopedRefs componentScopedRefs2 = (com.ibm.etools.webservice.wscbnd.ComponentScopedRefs)clientBinding.getComponentScopedRefs().get(i);
                String string2 = componentScopedRefs2.getComponentNameLink();
                if (!string2.equals(string)) continue;
                componentScopedRefs = componentScopedRefs2;
                if (!_tc.isDebugEnabled()) break;
                Tr.debug(_tc, "Found client binding info for ComponentScopedRef " + string);
                break;
            }
        }
        return componentScopedRefs;
    }

    private static ComponentScopedRefs getComponentExtension(WsClientExtension wsClientExtension, String string) {
        ComponentScopedRefs componentScopedRefs = null;
        if (wsClientExtension != null) {
            int n = wsClientExtension.getComponentScopedRefs().size();
            for (int i = 0; i < n; ++i) {
                ComponentScopedRefs componentScopedRefs2 = (ComponentScopedRefs)wsClientExtension.getComponentScopedRefs().get(i);
                String string2 = componentScopedRefs2.getComponentNameLink();
                if (!string2.equals(string)) continue;
                componentScopedRefs = componentScopedRefs2;
                if (!_tc.isDebugEnabled()) break;
                Tr.debug(_tc, "Found client extension info for ComponentScopedRef " + string);
                break;
            }
        }
        return componentScopedRefs;
    }

    private void extendServiceRefs(List list, List list2) throws NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, ConfigurationError {
        Iterator iterator = this.getServices().values().iterator();
        while (iterator.hasNext()) {
            ClientServiceMetaData clientServiceMetaData = (ClientServiceMetaData)iterator.next();
            com.ibm.etools.webservice.wscbnd.ServiceRef serviceRef = ClientEntityMetaData.getServiceRefBinding(list, clientServiceMetaData.getName());
            com.ibm.etools.webservice.wscext.ServiceRef serviceRef2 = ClientEntityMetaData.getServiceRefExtension(list2, clientServiceMetaData.getName());
            clientServiceMetaData.extendServiceRef(serviceRef, serviceRef2);
        }
    }

    private static com.ibm.etools.webservice.wscbnd.ServiceRef getServiceRefBinding(List list, String string) {
        com.ibm.etools.webservice.wscbnd.ServiceRef serviceRef = null;
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                com.ibm.etools.webservice.wscbnd.ServiceRef serviceRef2 = (com.ibm.etools.webservice.wscbnd.ServiceRef)list.get(i);
                if (!string.equals(serviceRef2.getServiceRefLink())) continue;
                serviceRef = serviceRef2;
                if (!_tc.isDebugEnabled()) break;
                Tr.debug(_tc, "Found client binding info for ServiceRef " + string);
                break;
            }
        }
        return serviceRef;
    }

    private static com.ibm.etools.webservice.wscext.ServiceRef getServiceRefExtension(List list, String string) {
        com.ibm.etools.webservice.wscext.ServiceRef serviceRef = null;
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                com.ibm.etools.webservice.wscext.ServiceRef serviceRef2 = (com.ibm.etools.webservice.wscext.ServiceRef)list.get(i);
                if (!string.equals(serviceRef2.getServiceRefLink())) continue;
                serviceRef = serviceRef2;
                if (!_tc.isDebugEnabled()) break;
                Tr.debug(_tc, "Found client extension info for ServiceRef " + string);
                break;
            }
        }
        return serviceRef;
    }
}

