/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.fromJava.description;

import com.ibm.ws.webservices.engine.InternalException;
import com.ibm.ws.webservices.engine.components.logger.LogFactory;
import com.ibm.ws.webservices.engine.encoding.TypeMapping;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.engine.utils.ClassUtils;
import com.ibm.ws.webservices.engine.utils.JavaUtils;
import com.ibm.ws.webservices.engine.utils.QNameTable;
import com.ibm.ws.webservices.engine.utils.bytecode.ParamNameExtractor;
import com.ibm.ws.webservices.wsdl.fromJava.Emitter;
import com.ibm.ws.webservices.wsdl.fromJava.Utils;
import com.ibm.ws.webservices.wsdl.fromJava.description.FaultDesc;
import com.ibm.ws.webservices.wsdl.fromJava.description.OperationDesc;
import com.ibm.ws.webservices.wsdl.fromJava.description.ParameterDesc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaVisibilityKind;
import org.eclipse.jem.java.Method;

public class PortDesc {
    protected static Log log = LogFactory.getLog(PortDesc.class.getName());
    private String name = null;
    private JavaClass implClass = null;
    private ArrayList operations = new ArrayList();
    private List namespaceMappings = null;
    private String wsdlFileName = null;
    private String endpointURL = null;
    private HashMap properties = null;
    private ArrayList stopClasses = null;
    private ArrayList methodNames = null;
    private HashMap name2OperationsMap = null;
    private HashMap qname2OperationsMap = null;
    private HashMap method2OperationMap = new HashMap();
    private ArrayList completedNames = new ArrayList();
    private TypeMapping tm = null;
    private boolean introspectionComplete = false;
    private Emitter emitter = null;
    private int paramMangle = 0;
    private HashMap paramList2Method = new HashMap();
    private HashMap method2ParamList = new HashMap();
    private boolean uniqueParamNames = false;

    public PortDesc(Emitter emitter) {
        this.emitter = emitter;
    }

    public String getWSDLFile() {
        return this.wsdlFileName;
    }

    public void setWSDLFile(String string) {
        this.wsdlFileName = string;
    }

    public JavaClass getImplClass() {
        return this.implClass;
    }

    public void setImplClass(JavaClass javaClass) {
        if (this.implClass != null) {
            throw new IllegalArgumentException(Messages.getMessage("implAlreadySet"));
        }
        this.implClass = javaClass;
    }

    public TypeMapping getTypeMapping() {
        return this.tm;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.tm = typeMapping;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public ArrayList getStopClasses() {
        return this.stopClasses;
    }

    public void setStopClasses(ArrayList arrayList) {
        this.stopClasses = arrayList;
    }

    public ArrayList getMethods() {
        return this.methodNames;
    }

    public void setMethods(ArrayList arrayList) {
        this.methodNames = arrayList;
    }

    public void addOperationDesc(OperationDesc operationDesc) {
        String string;
        ArrayList<OperationDesc> arrayList;
        this.operations.add(operationDesc);
        operationDesc.setParent(this);
        if (this.name2OperationsMap == null) {
            this.name2OperationsMap = new HashMap();
        }
        if ((arrayList = (ArrayList<OperationDesc>)this.name2OperationsMap.get(string = operationDesc.getName())) == null) {
            arrayList = new ArrayList<OperationDesc>();
            this.name2OperationsMap.put(string, arrayList);
        }
        arrayList.add(operationDesc);
    }

    public ArrayList getOperations() {
        this.loadPortDescByIntrospection();
        return this.operations;
    }

    public OperationDesc[] getOperationsByName(String string) {
        this.getSyncedOperationsForName(this.implClass, string);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList arrayList = (ArrayList)this.name2OperationsMap.get(string);
        if (arrayList == null) {
            return null;
        }
        OperationDesc[] operationDescArray = new OperationDesc[arrayList.size()];
        return arrayList.toArray(operationDescArray);
    }

    public OperationDesc getOperationByName(String string) {
        this.getSyncedOperationsForName(this.implClass, string);
        if (this.name2OperationsMap == null) {
            return null;
        }
        ArrayList arrayList = (ArrayList)this.name2OperationsMap.get(string);
        if (arrayList == null) {
            return null;
        }
        return (OperationDesc)arrayList.get(0);
    }

    private synchronized void initQNameMap() {
        if (this.qname2OperationsMap == null) {
            this.loadPortDescByIntrospection();
            this.qname2OperationsMap = new HashMap();
            Iterator iterator = this.operations.iterator();
            while (iterator.hasNext()) {
                OperationDesc operationDesc = (OperationDesc)iterator.next();
                ArrayList<OperationDesc> arrayList = (ArrayList<OperationDesc>)this.qname2OperationsMap.get(operationDesc.getElementQName());
                if (arrayList == null) {
                    arrayList = new ArrayList<OperationDesc>();
                    this.qname2OperationsMap.put(operationDesc.getElementQName(), arrayList);
                }
                arrayList.add(operationDesc);
            }
        }
    }

    private void syncOperationToClass(OperationDesc operationDesc, JavaClass javaClass) {
        Object object;
        if (operationDesc.getMethod() != null) {
            return;
        }
        EList eList = javaClass.getMethods();
        for (int i = 0; i < eList.size(); ++i) {
            EList eList2;
            object = (Method)eList.get(i);
            if (!object.getName().equals(operationDesc.getName()) || object.getJavaVisibility() != JavaVisibilityKind.PUBLIC_LITERAL || object.isStatic() || (eList2 = object.getParameters()).size() != operationDesc.getNumParams()) continue;
            for (int j = 0; j < eList2.size(); ++j) {
                ParameterDesc parameterDesc;
                QName qName;
                JavaParameter javaParameter = (JavaParameter)eList2.get(j);
                JavaHelpers javaHelpers = javaParameter.getJavaType();
                JavaHelpers javaHelpers2 = Utils.getHolderValueType(javaHelpers, this.emitter.getToolEnv().getClassFactory());
                if (javaHelpers2 == null) {
                    javaHelpers2 = javaHelpers;
                }
                if ((qName = (parameterDesc = operationDesc.getParameter(j)).getTypeQName()) == null) {
                    qName = Utils.getTypeQName(javaHelpers2, this.tm, this.emitter.getCustomRegistry(), this.emitter.getToolEnv().getClassFactory());
                    parameterDesc.setTypeQName(qName);
                }
                parameterDesc.setJavaType(javaHelpers, this.emitter);
            }
            JavaHelpers javaHelpers = object.getReturnType();
            if (javaHelpers.getJavaName().equals("void")) {
                operationDesc.setReturnClass(javaHelpers, this.emitter);
            }
            this.createFaultMetadata((Method)object, operationDesc);
            operationDesc.setMethod((Method)object);
            this.method2OperationMap.put(object, operationDesc);
            return;
        }
        JavaClass javaClass2 = javaClass.getSupertype();
        if (!(javaClass2 == null || javaClass2.getJavaName().startsWith("java.") || javaClass2.getJavaName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(javaClass2.getJavaName()))) {
            this.syncOperationToClass(operationDesc, javaClass2);
        }
        if (operationDesc.getMethod() == null) {
            object = new InternalException(Messages.getMessage("serviceDescOperSync00", operationDesc.getName(), javaClass.getJavaName()));
            throw object;
        }
    }

    public void loadPortDescByIntrospection() {
        this.loadPortDescByIntrospection(this.implClass);
        this.completedNames = null;
    }

    public void loadPortDescByIntrospection(JavaClass javaClass) {
        if (this.introspectionComplete || javaClass == null) {
            return;
        }
        this.implClass = javaClass;
        this.loadPortDescByIntrospectionRecursive(javaClass);
        Iterator iterator = this.operations.iterator();
        while (iterator.hasNext()) {
            OperationDesc operationDesc = (OperationDesc)iterator.next();
            if (operationDesc.getMethod() != null) continue;
            throw new InternalException(Messages.getMessage("badWSDDOperation", operationDesc.getName(), "" + operationDesc.getNumParams()));
        }
        this.introspectionComplete = true;
    }

    private void loadPortDescByIntrospectionRecursive(JavaClass javaClass) {
        EList eList = javaClass.getMethods();
        for (int i = 0; i < eList.size(); ++i) {
            Method method = (Method)eList.get(i);
            if (this.methodNames != null && !this.methodNames.contains(method.getName()) || method.getName().equals(javaClass.getName()) || method.getJavaVisibility() != JavaVisibilityKind.PUBLIC_LITERAL || method.isStatic()) continue;
            this.getSyncedOperationsForName(javaClass, method.getName());
        }
        if (javaClass.isInterface()) {
            EList eList2 = javaClass.getImplementsInterfaces();
            for (int i = 0; i < eList2.size(); ++i) {
                JavaClass javaClass2 = (JavaClass)eList2.get(i);
                if (this.stopClasses != null && this.stopClasses.contains(javaClass2.getJavaName())) continue;
                this.loadPortDescByIntrospectionRecursive(javaClass2);
            }
        } else {
            JavaClass javaClass3 = javaClass.getSupertype();
            if (!(javaClass3 == null || javaClass3.getJavaName().startsWith("java.") || javaClass3.getJavaName().startsWith("javax.") || this.stopClasses != null && this.stopClasses.contains(javaClass3.getJavaName()))) {
                this.loadPortDescByIntrospectionRecursive(javaClass3);
            }
        }
    }

    public void loadPortDescByIntrospection(JavaClass javaClass, TypeMapping typeMapping) {
        this.implClass = javaClass;
        this.tm = typeMapping;
        this.loadPortDescByIntrospection();
    }

    private void getSyncedOperationsForName(JavaClass javaClass, String string) {
        ArrayList arrayList;
        if (javaClass == null) {
            return;
        }
        if (this.completedNames == null || this.completedNames.contains(string)) {
            return;
        }
        if (this.name2OperationsMap != null && (arrayList = (ArrayList)this.name2OperationsMap.get(string)) != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                OperationDesc operationDesc = (OperationDesc)iterator.next();
                if (operationDesc.getMethod() != null) continue;
                this.syncOperationToClass(operationDesc, javaClass);
            }
        }
        this.createOperationsForName(javaClass, string);
        this.completedNames.add(string);
    }

    private void createOperationsForName(JavaClass javaClass, String string) {
        EList eList = javaClass.getMethods();
        for (int i = 0; i < eList.size(); ++i) {
            Method method = (Method)eList.get(i);
            if (!method.getName().equals(string) || method.getJavaVisibility() != JavaVisibilityKind.PUBLIC_LITERAL || method.isStatic()) continue;
            this.createOperationForMethod(method);
        }
        JavaClass javaClass2 = javaClass.getSupertype();
        if (javaClass2 != null && !javaClass2.getJavaName().startsWith("java.") && !javaClass2.getJavaName().startsWith("javax.")) {
            this.createOperationsForName(javaClass2, string);
        }
    }

    private void createOperationForMethod(Method method) {
        int n;
        List list;
        Method method2;
        Object object;
        ArrayList arrayList;
        if (this.method2OperationMap.get(method) != null) {
            return;
        }
        EList eList = method.getParameters();
        ArrayList arrayList2 = arrayList = this.name2OperationsMap == null ? null : (ArrayList)this.name2OperationsMap.get(method.getName());
        if (arrayList != null && !arrayList.isEmpty()) {
            for (int i = 0; i < arrayList.size(); ++i) {
                object = (OperationDesc)arrayList.get(i);
                method2 = ((OperationDesc)object).getMethod();
                if (method2 == null) continue;
                list = method2.getParameters();
                if (eList.size() != list.size()) continue;
                n = 1;
                for (int j = 0; j < list.size(); ++j) {
                    if (list.get(j).equals(eList.get(j))) continue;
                    n = 0;
                }
                if (n == 0) continue;
                return;
            }
        }
        OperationDesc operationDesc = new OperationDesc();
        object = "";
        if (this.namespaceMappings != null && !this.namespaceMappings.isEmpty()) {
            object = (String)this.namespaceMappings.get(0);
        }
        operationDesc.setElementQName(QNameTable.createQName((String)object, JavaUtils.java2NCName(method.getName())));
        operationDesc.setMethod(method);
        method2 = method.getReturnType();
        operationDesc.setReturnClass((JavaHelpers)method2, this.emitter);
        list = this.getParamNames(method);
        for (n = 0; n < eList.size(); ++n) {
            JavaParameter javaParameter = (JavaParameter)eList.get(n);
            JavaHelpers javaHelpers = javaParameter.getJavaType();
            ParameterDesc parameterDesc = new ParameterDesc();
            parameterDesc.setName(JavaUtils.java2NCName((String)list.get(n)));
            JavaHelpers javaHelpers2 = Utils.getHolderValueType(javaHelpers, this.emitter.getToolEnv().getClassFactory());
            if (javaHelpers2 != null) {
                parameterDesc.setMode((byte)3);
                parameterDesc.setTypeQName(Utils.getTypeQName(javaHelpers2, this.tm, this.emitter.getCustomRegistry(), this.emitter.getToolEnv().getClassFactory()));
            } else {
                parameterDesc.setMode((byte)1);
                parameterDesc.setTypeQName(Utils.getTypeQName(javaHelpers, this.tm, this.emitter.getCustomRegistry(), this.emitter.getToolEnv().getClassFactory()));
            }
            parameterDesc.setJavaType(javaHelpers, this.emitter);
            operationDesc.addParameter(parameterDesc);
        }
        this.createFaultMetadata(method, operationDesc);
        this.addOperationDesc(operationDesc);
        this.method2OperationMap.put(method, operationDesc);
    }

    private void createFaultMetadata(Method method, OperationDesc operationDesc) {
        EList eList = method.getJavaExceptions();
        for (int i = 0; i < eList.size(); ++i) {
            JavaClass javaClass = (JavaClass)eList.get(i);
            if (javaClass.getJavaName().equals("java.rmi.RemoteException") || javaClass.getJavaName().equals("com.ibm.ws.webservices.engine.WebServicesFault") || javaClass.getJavaName().startsWith("java.") || javaClass.getJavaName().startsWith("javax.")) continue;
            FaultDesc faultDesc = operationDesc.getFaultByClass(javaClass);
            if (faultDesc == null) {
                faultDesc = new FaultDesc();
            }
            faultDesc.setJavaClass(javaClass);
            operationDesc.addFault(faultDesc);
        }
    }

    private List getParamNames(Method method) {
        Method method2;
        if (this.method2ParamList.get(method) != null) {
            return (List)this.method2ParamList.get(method);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        EList eList = method.getParameters();
        if (this.emitter.getToolEnv().isJavaIntrospectionAllowed()) {
            int n;
            java.lang.reflect.Method method3 = null;
            Class clazz = null;
            java.lang.reflect.Method[] methodArray = null;
            try {
                clazz = ClassUtils.forName(this.implClass.getJavaName(), false, this.emitter.getToolEnv().getClassLoader());
                methodArray = clazz.getDeclaredMethods();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (methodArray != null) {
                boolean bl = false;
                for (n = 0; n < methodArray.length; ++n) {
                    if (!methodArray[n].getName().equals(method.getName())) continue;
                    bl = method3 != null;
                    method3 = methodArray[n];
                }
                if (bl) {
                    method3 = null;
                }
            }
            if (method3 != null) {
                try {
                    String[] stringArray = ParamNameExtractor.getParameterNamesFromDebugInfo(method3);
                    if (stringArray != null) {
                        for (n = 0; n < stringArray.length; ++n) {
                            arrayList.add(stringArray[n]);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (arrayList.size() == 0) {
            for (int i = 0; i < eList.size(); ++i) {
                arrayList.add(((JavaParameter)eList.get(i)).getName());
            }
        }
        if (arrayList.size() > 0) {
            boolean bl = true;
            for (int i = 0; i < eList.size() && bl; ++i) {
                if (arrayList.get(i).equals("arg" + i)) continue;
                bl = false;
            }
            if (bl) {
                arrayList.clear();
            }
        }
        if (this.uniqueParamNames && arrayList.size() > 0 && this.paramList2Method.get(arrayList) != null) {
            arrayList.clear();
        }
        if (arrayList.size() == 0) {
            for (int i = 0; i < eList.size(); ++i) {
                arrayList.add("arg_" + i + "_" + this.paramMangle);
            }
            ++this.paramMangle;
        }
        if (this.uniqueParamNames && (method2 = (Method)this.paramList2Method.get(arrayList)) != null) {
            this.emitter.getToolEnv().reportFatalErr(Messages.getMessage("matchingDocLitParams01", method2.getName(), method.getName()));
        }
        this.method2ParamList.put(method, arrayList);
        this.paramList2Method.put(arrayList, method);
        return arrayList;
    }

    public void setNamespaceMappings(List list) {
        this.namespaceMappings = list;
    }

    public String getDefaultNamespace() {
        if (this.namespaceMappings == null || this.namespaceMappings.isEmpty()) {
            return null;
        }
        return (String)this.namespaceMappings.get(0);
    }

    public void setDefaultNamespace(String string) {
        if (this.namespaceMappings == null) {
            this.namespaceMappings = new ArrayList();
        }
        this.namespaceMappings.add(0, string);
    }

    public void setProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(string, object);
    }

    public Object getProperty(String string) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(string);
    }

    public void setUniqueParamNames(boolean bl) {
        this.uniqueParamNames = bl;
    }

    public String getEndpointURL() {
        return this.endpointURL;
    }

    public void setEndpointURL(String string) {
        this.endpointURL = string;
    }

    public String toString() {
        return this.toString("");
    }

    protected String toString(String string) {
        String string2 = "";
        string2 = string2 + string + "name:        " + this.getName() + "\n";
        string2 = string2 + string + "implClass:   " + this.getImplClass() + "\n";
        string2 = string2 + string + "defaultNS:   " + this.getDefaultNamespace() + "\n";
        string2 = string2 + string + "endpointURL: " + this.getEndpointURL() + "\n";
        if (this.operations != null) {
            for (int i = 0; i < this.operations.size(); ++i) {
                string2 = string2 + string + " OperationDesc[" + i + "]:\n";
                string2 = string2 + string + ((OperationDesc)this.operations.get(i)).toString("  ") + "\n";
            }
        }
        return string2;
    }
}

