/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webservices.wsdl.symbolTable;

import com.ibm.ws.webservices.engine.enumtype.Style;
import com.ibm.ws.webservices.engine.enumtype.Use;
import com.ibm.ws.webservices.engine.resources.Messages;
import com.ibm.ws.webservices.wsdl.symbolTable.BindingOperationEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymTabEntry;
import com.ibm.ws.webservices.wsdl.symbolTable.SymbolTable;
import java.util.HashMap;
import java.util.Iterator;
import javax.wsdl.Binding;
import javax.wsdl.Input;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.xml.namespace.QName;

public class BindingEntry
extends SymTabEntry {
    public static final int TYPE_SOAP = 0;
    public static final int TYPE_HTTP_GET = 1;
    public static final int TYPE_HTTP_POST = 2;
    public static final int TYPE_UNKNOWN = 3;
    public static final int TYPE_NONSOAP = 4;
    private Binding binding;
    private int bindingType = 3;
    private Style bindingStyle = Style.DOCUMENT;
    private QName serviceQName = null;
    private HashMap operations = new HashMap();
    public static String BINDING_NAMESPACE = "BindingNamespace";
    public static String SOAP_TRANSPORT_URI = "SOAPTransportURI";

    public BindingEntry(Binding binding, SymbolTable symbolTable) {
        super(binding.getQName(), symbolTable);
        this.binding = binding;
    }

    public Binding getBinding() {
        return this.binding;
    }

    public int getBindingType() {
        return this.bindingType;
    }

    void setBindingType(int n) {
        this.bindingType = n;
    }

    public Style getBindingStyle() {
        return this.bindingStyle;
    }

    void setBindingStyle(Style style) {
        if (style == null || style.equals(Style.WRAPPED)) {
            throw new RuntimeException(Messages.getMessage("error01", "invalid binding style of" + style));
        }
        this.bindingStyle = style;
    }

    public BindingOperationEntry getOperation(Operation operation) {
        Input input = operation.getInput();
        String string = input == null ? null : input.getName();
        Output output = operation.getOutput();
        String string2 = output == null ? null : output.getName();
        OperationKey operationKey = new OperationKey(operation.getName(), string, string2);
        return (BindingOperationEntry)this.operations.get(operationKey);
    }

    void addOperation(Operation operation, BindingOperationEntry bindingOperationEntry) {
        Input input = operation.getInput();
        String string = input == null ? null : input.getName();
        Output output = operation.getOutput();
        String string2 = output == null ? null : output.getName();
        OperationKey operationKey = new OperationKey(operation.getName(), string, string2);
        this.operations.put(operationKey, bindingOperationEntry);
    }

    public Iterator getOperations() {
        return this.operations.values().iterator();
    }

    public boolean hasLiteral() {
        Iterator iterator = this.getOperations();
        while (iterator.hasNext()) {
            BindingOperationEntry bindingOperationEntry = (BindingOperationEntry)iterator.next();
            if (bindingOperationEntry.getInputBodyUse() != Use.LITERAL && bindingOperationEntry.getOutputBodyUse() != Use.LITERAL) continue;
            return true;
        }
        return false;
    }

    public boolean hasMIMETypes() {
        Iterator iterator = this.getOperations();
        while (iterator.hasNext()) {
            BindingOperationEntry bindingOperationEntry = (BindingOperationEntry)iterator.next();
            if (!bindingOperationEntry.hasMIMETypes()) continue;
            return true;
        }
        return false;
    }

    public QName getServiceName() {
        return this.serviceQName;
    }

    public void setServiceName(QName qName) {
        this.serviceQName = qName;
    }

    class OperationKey {
        private String name;
        private String input;
        private String output;

        public OperationKey(String string, String string2, String string3) {
            this.name = string == null ? "" : string;
            this.input = string2 == null ? "" : string2;
            this.output = string3 == null ? "" : string3;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof OperationKey) {
                OperationKey operationKey = (OperationKey)object;
                return this.name.equals(operationKey.name) && this.input.equals(operationKey.input) && this.output.equals(operationKey.output);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.input.hashCode() ^ this.output.hashCode();
        }
    }
}

