/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsaddressing.namespace;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.wsaddressing.EndpointReferenceCreationException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.wsaddressing.Constants;
import com.ibm.ws.wsaddressing.NamespaceHelper;
import com.ibm.ws.wsaddressing.TraceAndMessageConstants;
import com.ibm.ws.wsaddressing.namespace.NamespaceData200408;
import com.ibm.ws.wsaddressing.namespace.NamespaceData200508;
import com.ibm.wsspi.wsaddressing.EndpointReference;
import com.ibm.wsspi.wsaddressing.NamespaceNotSupportedException;
import java.io.Serializable;
import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPHeader;

public abstract class NamespaceData
implements Serializable {
    private static final String CLASSNAME = "com.ibm.ws.wsaddressing.namespace.NamespaceData";
    private static final TraceComponent TRACE_COMPONENT = Tr.register(NamespaceData.class, TraceAndMessageConstants.COMPONENT, TraceAndMessageConstants.MESSAGE_FILE);
    private static NamespaceHelper _nh = new NamespaceHelper();

    public static NamespaceData getDefaultNamespaceInstance() {
        return NamespaceData200508.getInstance();
    }

    public static NamespaceData getInstance(String string) throws NamespaceNotSupportedException {
        if (string == null) {
            return null;
        }
        if (string.equals("http://www.w3.org/2005/08/addressing")) {
            return NamespaceData200508.getInstance();
        }
        if (string.equals("http://schemas.xmlsoap.org/ws/2004/08/addressing")) {
            return NamespaceData200408.getInstance();
        }
        throw new NamespaceNotSupportedException("Namespace  : " + string + " is not supported.");
    }

    public abstract String getNamespace();

    public abstract String getWSDLNamespace();

    public abstract URI getAnonymousURI();

    public abstract URI getNoneURI() throws NamespaceNotSupportedException;

    public abstract URI getFaultActionURI();

    public abstract URI getUnspecifiedMessageURI();

    public abstract URI getReplyRelationshipURI();

    public abstract EndpointReference createAnonymousEPR() throws EndpointReferenceCreationException;

    public abstract Name getwsaEndpointReference();

    public abstract Name getwsaAddress();

    public abstract Name getwsaReferenceParameters();

    public abstract Name getwsaIsReferenceParameter();

    public abstract Name getwsaMetadata();

    public abstract Name getwsaFaultTo();

    public abstract Name getwsaReplyTo();

    public abstract Name getwsaFrom();

    public abstract Name getwsaRelatesTo();

    public abstract Name getwsaRelationshipType();

    public abstract Name getwsaMessageID();

    public abstract Name getwsaAction();

    public abstract Name getwsaTo();

    public abstract Name getwsaProblemHeaderQN();

    public abstract Name getwsaFaultDetailName();

    public abstract Name getwsawInterfaceName();

    public abstract Name getwsawServiceName();

    public abstract Name getwsawEndpointName();

    public abstract QName getMessageAddressingPropertyRequired();

    public abstract QName getActionMismatch();

    public abstract QName getInvalidMessageAddressingProperty();

    public abstract QName getDestinationUnreachable();

    public abstract QName getActionNotSupported();

    public abstract QName getEndpointUnavailable();

    public static NamespaceData addInboundNamespaceDataToContext(SOAPHeader sOAPHeader, MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addInboundNamespaceDataToContext", new Object[]{sOAPHeader, messageContext});
        }
        String string = _nh.updateInboundWSANamespaceForMessageContext(sOAPHeader, messageContext);
        NamespaceData namespaceData = null;
        try {
            namespaceData = NamespaceData.getInstance(string);
        }
        catch (NamespaceNotSupportedException namespaceNotSupportedException) {
            FFDCFilter.processException((Throwable)namespaceNotSupportedException, "com.ibm.ws.wsaddressing.namespace.NamespaceData.addInboundNamespaceDataToContext", "1:198:1.7", string);
            Tr.warning(TRACE_COMPONENT, "NamespaceHelper returned an namespace for which no NamespaceData was available: " + string);
            namespaceData = NamespaceData.getDefaultNamespaceInstance();
        }
        messageContext.setProperty(Constants.WSADDRESSING_NAMESPACE_DATA, namespaceData);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addInboundNamespaceDataToContext", namespaceData);
        }
        return namespaceData;
    }

    public static NamespaceData addOutboundNamespaceDataToContext(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "addOutboundNamespaceDataToContext", messageContext);
        }
        String string = _nh.updateOutboundWSANamespaceForMessageContext(messageContext);
        NamespaceData namespaceData = null;
        try {
            namespaceData = NamespaceData.getInstance(string);
        }
        catch (NamespaceNotSupportedException namespaceNotSupportedException) {
            FFDCFilter.processException((Throwable)namespaceNotSupportedException, "com.ibm.ws.wsaddressing.namespace.NamespaceData.addOutboundNamespaceDataToContext", "1:236:1.7", string);
            Tr.warning(TRACE_COMPONENT, "NamespaceHelper returned an namespace for which no NamespaceData was available: " + string);
            namespaceData = NamespaceData.getDefaultNamespaceInstance();
        }
        messageContext.setProperty(Constants.WSADDRESSING_NAMESPACE_DATA, namespaceData);
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "addOutboundNamespaceDataToContext", namespaceData);
        }
        return namespaceData;
    }

    public static NamespaceData getNamespaceDataFromContext(MessageContext messageContext) {
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.entry(TRACE_COMPONENT, "getNamespaceDataFromContext", messageContext);
        }
        NamespaceData namespaceData = null;
        Object object = messageContext.getProperty(Constants.WSADDRESSING_NAMESPACE_DATA);
        if (object != null && object instanceof NamespaceData) {
            namespaceData = (NamespaceData)object;
        } else {
            namespaceData = NamespaceData.getDefaultNamespaceInstance();
            Tr.debug(TRACE_COMPONENT, "NamespaceData object not found on context. Using default.", namespaceData);
        }
        if (TRACE_COMPONENT.isEntryEnabled()) {
            Tr.exit(TRACE_COMPONENT, "getNamespaceDataFromContext", namespaceData);
        }
        return namespaceData;
    }

    protected static Name createSOAPNameForWSALocalName(String string, SOAPFactory sOAPFactory, String string2) {
        Name name2 = null;
        try {
            name2 = sOAPFactory.createName(string, "wsa", string2);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.wsaddressing.namespace.NamespaceData.createSOAPNameForWSALocalName", "1:307:1.7", string);
        }
        return name2;
    }

    protected static Name createSOAPNameForWSAWLocalName(String string, SOAPFactory sOAPFactory, String string2) {
        Name name2 = null;
        try {
            name2 = sOAPFactory.createName(string, "wsaw", string2);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.wsaddressing.namespace.NamespaceData.createSOAPNameForWSAWLocalName", "1:327:1.7", string);
        }
        return name2;
    }

    protected static Name createNCNameForLocalName(String string, SOAPFactory sOAPFactory) {
        Name name2 = null;
        try {
            name2 = sOAPFactory.createName(string);
        }
        catch (SOAPException sOAPException) {
            FFDCFilter.processException((Throwable)sOAPException, "com.ibm.ws.wsaddressing.namespace.NamespaceData.createNCNameForLocalName", "1:346:1.7", string);
        }
        return name2;
    }
}

