/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.http.channel;

import java.util.Hashtable;
import java.util.Map;

public final class HttpChannelUtils {
    private static final byte[] HEX_BYTES = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final byte[] ZERO_BYTEARRAY = new byte[]{HEX_BYTES[0]};
    private static final int SIZE_MAXINT = 10;

    private HttpChannelUtils() {
    }

    public static byte[] asByteArray(int n) {
        int n2;
        if (0 == n) {
            return ZERO_BYTEARRAY;
        }
        byte[] byArray = new byte[10];
        boolean bl = false;
        if (0 > n) {
            bl = true;
            n = -n;
        }
        for (n2 = 9; 0 <= n2 && 0 != n; n /= 10, --n2) {
            byArray[n2] = HEX_BYTES[n % 10];
        }
        int n3 = 9 - n2;
        if (bl) {
            ++n3;
        }
        byte[] byArray2 = new byte[n3];
        int n4 = n3 - 1;
        int n5 = 9;
        while (0 <= n4) {
            byArray2[n4] = byArray[n5];
            --n4;
            --n5;
        }
        if (bl) {
            byArray2[0] = 45;
        }
        return byArray2;
    }

    public static int asIntValue(byte[] byArray) {
        int n;
        if (null == byArray) {
            return -1;
        }
        int n2 = 0;
        int n3 = 1;
        for (n = byArray.length - 1; 0 <= n; --n) {
            int n4 = byArray[n] - HEX_BYTES[0];
            if (0 > n4 || 9 < n4) {
                if (45 == byArray[n]) break;
                throw new NumberFormatException("Invalid digit: " + byArray[n]);
            }
            n2 += n4 * n3;
            n3 *= 10;
        }
        if (0 <= n && byArray[n] == 45) {
            n2 = -n2;
        }
        return n2;
    }

    public static byte[] getEnglishBytes(String string) {
        if (null == string) {
            return null;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    public static String getEnglishString(byte[] byArray) {
        if (null == byArray) {
            return null;
        }
        char[] cArray = new char[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return new String(cArray);
    }

    public static String getEnglishString(byte[] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (0 >= n3 || null == byArray) {
            return null;
        }
        char[] cArray = new char[n3];
        for (int i = n; i < n2; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return new String(cArray);
    }

    public static byte[] getBytes(StringBuffer stringBuffer) {
        if (null == stringBuffer) {
            return null;
        }
        int n = stringBuffer.length();
        char[] cArray = new char[n];
        stringBuffer.getChars(0, n, cArray, 0);
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        return byArray;
    }

    private static String parseName(char[] cArray, int n, int n2) {
        int n3 = 0;
        char[] cArray2 = new char[n2 - n];
        block4: for (int i = n; i < n2; ++i) {
            switch (cArray[i]) {
                case '+': {
                    cArray2[n3++] = 32;
                    continue block4;
                }
                case '%': {
                    if (i + 2 < n2) {
                        int n4;
                        int n5;
                        if (-1 == (n5 = Character.digit(cArray[++i], 16))) {
                            throw new IllegalArgumentException("" + cArray[i]);
                        }
                        if (-1 == (n4 = Character.digit(cArray[++i], 16))) {
                            throw new IllegalArgumentException("" + cArray[i]);
                        }
                        cArray2[n3++] = (char)(n5 << 4 | n4);
                        continue block4;
                    }
                    while (i < n2) {
                        cArray2[n3++] = cArray[i];
                        ++i;
                    }
                    continue block4;
                }
                default: {
                    cArray2[n3++] = cArray[i];
                }
            }
        }
        return new String(cArray2, 0, n3);
    }

    public static Map parseQueryString(String string, String string2) {
        if (null == string) {
            throw new NullPointerException("query data");
        }
        Hashtable<String, String[]> hashtable = new Hashtable<String, String[]>();
        String[] stringArray = null;
        char[] cArray = string.toCharArray();
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if ('=' != cArray[i]) continue;
            if (i == n) {
                throw new IllegalArgumentException("Missing key name: " + i);
            }
            String string3 = HttpChannelUtils.parseName(cArray, n, i);
            int n2 = ++i;
            while (i < cArray.length && '&' != cArray[i]) {
                ++i;
            }
            if (i > n2) {
                String string4 = HttpChannelUtils.parseName(cArray, n2, i);
                if (hashtable.containsKey(string3)) {
                    String[] stringArray2 = (String[])hashtable.get(string3);
                    stringArray = new String[stringArray2.length + 1];
                    System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length);
                    stringArray[stringArray2.length] = string4;
                } else {
                    stringArray = new String[]{string4};
                }
                hashtable.put(string3, stringArray);
            }
            n = i + 1;
        }
        return hashtable;
    }
}

