/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class ParameterList {
    private Hashtable list = new Hashtable();

    public ParameterList() {
    }

    public ParameterList(String s) throws ParseException {
        HeaderTokenizer h = new HeaderTokenizer(s, "()<>@,;:\\\"\t []/?=");
        while (true) {
            HeaderTokenizer.Token tk;
            int type;
            if ((type = (tk = h.next()).getType()) == -4) {
                return;
            }
            if ((char)type != ';') break;
            tk = h.next();
            if (tk.getType() == -4) {
                return;
            }
            if (tk.getType() != -1) {
                throw new ParseException();
            }
            String name2 = tk.getValue().toLowerCase();
            tk = h.next();
            if ((char)tk.getType() != '=') {
                throw new ParseException();
            }
            tk = h.next();
            type = tk.getType();
            if (type != -1 && type != -2) {
                throw new ParseException();
            }
            this.list.put(name2, tk.getValue());
        }
        throw new ParseException();
    }

    public int size() {
        return this.list.size();
    }

    public String get(String name2) {
        return (String)this.list.get(name2.trim().toLowerCase());
    }

    public void set(String name2, String value2) {
        this.list.put(name2.trim().toLowerCase(), value2);
    }

    public void remove(String name2) {
        this.list.remove(name2.trim().toLowerCase());
    }

    public Enumeration getNames() {
        return this.list.keys();
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int used) {
        StringBuffer sb = new StringBuffer();
        Enumeration e = this.list.keys();
        while (e.hasMoreElements()) {
            String name2 = (String)e.nextElement();
            String value2 = this.quote((String)this.list.get(name2));
            sb.append("; ");
            int len = name2.length() + value2.length() + 1;
            if ((used += 2) + len > 76) {
                sb.append("\r\n\t");
                used = 8;
            }
            sb.append(name2).append('=');
            if ((used += name2.length() + 1) + value2.length() > 76) {
                String s = MimeUtility.fold(used, value2);
                sb.append(s);
                int lastlf = s.lastIndexOf(10);
                if (lastlf >= 0) {
                    used += s.length() - lastlf - 1;
                    continue;
                }
                used += s.length();
                continue;
            }
            sb.append(value2);
            used += value2.length();
        }
        return sb.toString();
    }

    private String quote(String value2) {
        return MimeUtility.quote(value2, "()<>@,;:\\\"\t []/?=");
    }
}

