/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.namespace;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class QName
implements Serializable {
    static final long serialVersionUID = -9120448754896609940L;
    private final String namespaceURI;
    private final String localPart;
    private String prefix;

    public QName(String string, String string2) {
        this(string, string2, "");
    }

    public QName(String string, String string2, String string3) {
        this.namespaceURI = string == null ? "" : string;
        if (string2 == null) {
            throw new IllegalArgumentException("local part cannot be \"null\" when creating a QName");
        }
        this.localPart = string2;
        if (string3 == null) {
            throw new IllegalArgumentException("prefix cannot be \"null\" when creating a QName");
        }
        this.prefix = string3;
    }

    public QName(String string) {
        this("", string, "");
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof QName)) {
            return false;
        }
        QName qName = (QName)object;
        return this.namespaceURI.equals(qName.namespaceURI) && this.localPart.equals(qName.localPart);
    }

    public int hashCode() {
        return this.namespaceURI.hashCode() ^ this.localPart.hashCode();
    }

    public String toString() {
        if (this.namespaceURI.equals("")) {
            return this.localPart;
        }
        return "{" + this.namespaceURI + "}" + this.localPart;
    }

    public static QName valueOf(String string) {
        if (string == null) {
            throw new IllegalArgumentException("cannot create QName from \"null\"");
        }
        if (string.length() == 0) {
            return new QName("");
        }
        if (string.charAt(0) != '{') {
            return new QName("", string, "");
        }
        int n = string.indexOf(125);
        if (n == -1) {
            throw new IllegalArgumentException("cannot create QName from \"" + string + "\", missing closing \"}\"");
        }
        if (n == string.length() - 1) {
            throw new IllegalArgumentException("cannot create QName from \"" + string + "\", missing local part");
        }
        return new QName(string.substring(1, n), string.substring(n + 1), "");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.prefix == null) {
            this.prefix = "";
        }
    }
}

