/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.AbstractArchiveWriterOutputStream;
import com.installshield.archive.ArchiveWriterEntry;
import com.installshield.archive.MediaInf;
import com.installshield.archive.index.ArchiveIndexWriter;
import com.installshield.archive.index.DeflaterOutputStreamWrapper;
import com.installshield.util.FileUtils;
import com.installshield.util.URLUtils;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ArchiveWriterSpanOutputStream
extends AbstractArchiveWriterOutputStream {
    private String currentMediaArchiveName = "";
    private boolean newResource = false;
    private OutputStream out = null;
    private int currentMediaDisk;
    private int currentSpanningMediaDisk;
    private ArchiveEntryLocation currentLocation;
    private String mediaArchiveName;
    private String tempApplicationArchiveName;
    private FileOutputStream zipFileOut = null;
    private ZipOutputStream zipOut = null;
    private ZipEntry currentZipEntry = null;
    private boolean indexSizeAdded;
    private long mediaSize;
    private long blockSize;
    private MediaBytesTable mediaBytes;

    public ArchiveWriterSpanOutputStream(String string, String string2, String string3, String string4, String string5, ArchiveIndexWriter archiveIndexWriter, long l, long l2) {
        super(string, string2, string3, string4, archiveIndexWriter);
        this.mediaArchiveName = string5;
        this.mediaSize = l;
        this.blockSize = l2;
        this.initialize();
    }

    private void addIndexSize() throws IOException {
        if (!this.indexSizeAdded) {
            long l = this.getArchiveIndexWriter().getArchiveIndexSize();
            if (this.mediaBytes.spaceAvailable(1) < l) {
                throw new IOException("Not enough space on application media disk for index.");
            }
            this.mediaBytes.addFileSize(1, l);
            this.indexSizeAdded = true;
        }
    }

    private void closeApplicationArchiveEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        long l;
        Object object;
        if (this.getCurrentZipEntry() != null) {
            object = this.getApplicationArchiveStream();
            ((ZipOutputStream)object).closeEntry();
        }
        object = null;
        ZipEntry zipEntry = this.getCurrentZipEntry();
        if (zipEntry != null && (l = zipEntry.getTime()) >= 0L) {
            object = new Date(l);
        }
        archiveWriterEntry.setDate((Date)object);
        this.setCurrentZipEntry(null);
    }

    private void closeApplicationArchiveStream() throws IOException {
        try {
            try {
                if (this.zipOut != null) {
                    this.closeZipStream(this.zipOut);
                }
            }
            catch (IOException iOException) {
                throw new IOException("Could not close application archive stream");
            }
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                if (this.zipFileOut != null) {
                    this.zipFileOut.close();
                }
            }
            catch (IOException iOException) {}
            this.zipOut = null;
            this.zipFileOut = null;
            throw throwable;
        }
        try {
            if (this.zipFileOut != null) {
                this.zipFileOut.close();
            }
        }
        catch (IOException iOException) {}
        this.zipOut = null;
        this.zipFileOut = null;
    }

    protected void closeExternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        super.closeExternalEntry(archiveWriterEntry);
        if (this.isNewExternalResource()) {
            int n = archiveWriterEntry.getMediaNumber();
            String string = archiveWriterEntry.getId();
            String string2 = this.createArchiveFileName(this.getExternalResourceLocation(), n);
            File file = new File(string2 = FileUtils.createFileName(string2, string));
            if (file.isFile()) {
                if (this.mediaBytes.spaceRequiredForFile(n, file) > 0L) {
                    throw new IOException("Not enough space on media disk (" + n + ") for resource: " + string);
                }
                this.mediaBytes.addFile(n, file);
            }
        } else {
            this.getArchiveIndexWriter().setPostBuildProperties(archiveWriterEntry.getArchiveIndex(), archiveWriterEntry.getMediaNumber(), archiveWriterEntry.getMediaNumber(), archiveWriterEntry.getIndexRef(), true);
        }
    }

    void closeInternalArchive() throws IOException {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer("Exceptions thrown:\n");
        try {
            this.addIndexSize();
        }
        catch (IOException iOException) {
            bl = false;
            stringBuffer.append("Could not add ArchiveIndex size: " + iOException.getMessage() + "\n");
        }
        try {
            this.closeApplicationArchiveStream();
        }
        catch (IOException iOException) {
            bl = false;
            stringBuffer.append("Could not close application archive: " + iOException.getMessage() + "\n");
        }
        try {
            this.closeMediaArchiveStream();
        }
        catch (IOException iOException) {
            bl = false;
            stringBuffer.append("Could not close media archive: " + iOException.getMessage() + "\n");
        }
        if (!bl) {
            throw new IOException(stringBuffer.toString());
        }
    }

    void closeInternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        int n = archiveWriterEntry.getEntryType();
        if (n == 1) {
            this.closeApplicationArchiveEntry(archiveWriterEntry);
        } else if (n == 2 || n == 3) {
            this.closeMediaArchiveEntry(archiveWriterEntry);
        } else {
            throw new IOException("Unknown archive entry type: " + archiveWriterEntry.getId());
        }
    }

    private void closeMediaArchiveEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        this.closeMediaArchiveStream();
        if (this.isNewResource()) {
            Date date = null;
            String string = this.getCurrentMediaArchiveName();
            File file = new File(string);
            if (file.isFile()) {
                date = new Date(file.lastModified());
                if (archiveWriterEntry.isSpannable()) {
                    int n;
                    int n2;
                    if (this.mediaBytes.spaceRequiredForFile(this.currentMediaDisk, file) > 0L) {
                        n2 = this.currentMediaDisk;
                        n = this.splitArchiveEntry(archiveWriterEntry, string, this.currentMediaDisk, this.mediaBytes);
                        this.currentSpanningMediaDisk = this.mediaBytes.isFull(n) ? n + 1 : n;
                    } else {
                        this.mediaBytes.addFile(this.currentMediaDisk, file);
                        n2 = this.currentMediaDisk;
                        n = this.currentMediaDisk;
                        if (this.mediaBytes.isFull(this.currentMediaDisk)) {
                            this.currentSpanningMediaDisk = this.currentMediaDisk + 1;
                        }
                    }
                    this.getArchiveIndexWriter().setPostBuildProperties(archiveWriterEntry.getArchiveIndex(), n2, n);
                } else {
                    if (this.mediaBytes.spaceRequiredForFile(this.currentMediaDisk, file) > 0L) {
                        throw new IOException("Not enough space on media disk (" + this.currentMediaDisk + ") for resource: " + this.getCurrentMediaArchiveName());
                    }
                    this.mediaBytes.addFile(this.currentMediaDisk, file);
                }
            }
            archiveWriterEntry.setDate(date);
        } else if (archiveWriterEntry.isSpannable()) {
            ArchiveEntryLocation archiveEntryLocation = this.getCurrentArchiveEntryLocation();
            this.getArchiveIndexWriter().setPostBuildProperties(archiveWriterEntry.getArchiveIndex(), archiveEntryLocation.getStartMediaDisk(), archiveEntryLocation.getEndMediaDisk(), archiveWriterEntry.getIndexRef(), true);
        }
    }

    private void closeMediaArchiveStream() throws IOException {
        try {
            try {
                if (this.out != null) {
                    this.out.close();
                }
            }
            catch (IOException iOException) {
                throw new IOException("Could not close media output stream: " + this.getCurrentMediaArchiveName());
            }
            Object var2_1 = null;
            this.out = null;
            this.resetDeflater();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.out = null;
            this.resetDeflater();
            throw throwable;
        }
    }

    private void closeZipStream(ZipOutputStream zipOutputStream) throws IOException {
        block2: {
            try {
                zipOutputStream.finish();
                zipOutputStream.close();
            }
            catch (ZipException zipException) {
                if (zipException.getMessage().startsWith("ZIP file must have at least one entry")) break block2;
                throw zipException;
            }
        }
    }

    private String createMediaEntryName(String string, String string2) {
        String string3 = FileUtils.appendSeparator(FileUtils.normalizeFileName(string, File.separatorChar), File.separator);
        String string4 = FileUtils.normalizeFileName(string2, File.separatorChar);
        string3 = string4.startsWith(File.separator) ? String.valueOf(string3) + string4.substring(1) : String.valueOf(string3) + string4;
        return string3;
    }

    protected void createMediaInf(int n) throws IOException {
        String string;
        File file;
        if (this.requireMediaInfs() && !(file = new File(string = FileUtils.createFileName(this.createArchiveFileName("", n), "media.inf"))).exists()) {
            if (file.getParent() != null) {
                this.createDirs(file.getParent());
            }
            MediaInf mediaInf = new MediaInf(n);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            mediaInf.write(fileOutputStream);
            fileOutputStream.close();
            this.mediaBytes.addFile(n, file);
        }
    }

    protected void finalizeFixedResources() throws IOException {
        this.closeApplicationArchiveStream();
        this.mediaBytes.addFile(1, new File(this.getTempApplicationArchiveName()));
        this.fireApplicationArchiveFinished();
        if (this.mediaBytes.isOverFilled(1)) {
            throw new IOException("Not enough space on media disk (1) for application archive.");
        }
    }

    private ArchiveEntryLocation findArchiveEntry(String string, boolean bl) {
        ArchiveEntryLocation archiveEntryLocation = null;
        if (!bl) {
            String string2 = this.createArchiveFileName(string, 1);
            if (new File(string2).exists()) {
                archiveEntryLocation = new ArchiveEntryLocation(1, 1);
            }
        } else {
            int n = 0;
            int n2 = 0;
            boolean bl2 = false;
            int n3 = this.mediaBytes.getFirstMediaDisk();
            while (n3 <= this.mediaBytes.getLastMediaDisk()) {
                String string3 = this.createArchiveFileName(string, n3);
                if (new File(string3).exists()) {
                    if (bl2) {
                        n2 = n3;
                    } else {
                        n = n3;
                        n2 = n3;
                        bl2 = true;
                    }
                }
                ++n3;
            }
            if (bl2) {
                archiveEntryLocation = new ArchiveEntryLocation(n, n2);
            }
        }
        return archiveEntryLocation;
    }

    void flushInternalArchive() throws IOException {
        boolean bl = true;
        StringBuffer stringBuffer = new StringBuffer("Exceptions thrown:\n");
        try {
            if (this.out != null) {
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            bl = false;
            stringBuffer.append("Could not flush media archive: " + iOException.getMessage() + "\n");
        }
        try {
            if (this.zipOut != null) {
                ((FilterOutputStream)this.zipOut).flush();
            }
        }
        catch (IOException iOException) {
            bl = false;
            stringBuffer.append("Could not flush application archive: " + iOException.getMessage() + "\n");
        }
        if (!bl) {
            throw new IOException(stringBuffer.toString());
        }
    }

    public String getApplicationArchiveHome() {
        String string = !this.isFixedFinalized() ? this.getTempApplicationArchiveName() : this.getApplicationArchiveName();
        return string;
    }

    public String getApplicationArchiveName() {
        return this.createArchiveFileName(this.getArchiveName(), 1);
    }

    public long getApplicationArchiveSize() throws IOException {
        long l;
        if (!this.isFixedFinalized()) {
            l = new File(this.getTempApplicationArchiveName()).length();
            l += this.getArchiveIndexWriter().getArchiveIndexSize();
        } else {
            l = new File(this.getApplicationArchiveName()).length();
        }
        return l;
    }

    private ZipOutputStream getApplicationArchiveStream() throws IOException {
        if (this.zipOut == null) {
            String string = FileUtils.createTempFile();
            this.createDirsForArchive(this.getApplicationArchiveName());
            this.createMediaInf(1);
            this.zipFileOut = new FileOutputStream(string);
            this.zipOut = new ZipOutputStream(this.zipFileOut);
            this.setTempApplicationArchiveName(string);
        }
        return this.zipOut;
    }

    private ArchiveEntryLocation getCurrentArchiveEntryLocation() {
        return this.currentLocation;
    }

    private String getCurrentMediaArchiveName() {
        return this.currentMediaArchiveName;
    }

    private ZipEntry getCurrentZipEntry() {
        return this.currentZipEntry;
    }

    public String getMediaArchiveName() {
        return this.mediaArchiveName;
    }

    private OutputStream getMediaArchiveStream() {
        return this.out;
    }

    private String getTempApplicationArchiveName() {
        return this.tempApplicationArchiveName;
    }

    private void initMediaArchiveStream(String string, int n, boolean bl) throws IOException {
        boolean bl2 = true;
        if (this.out != null) {
            throw new IOException("Initialization Error:  Previous archive has not been closed.");
        }
        String string2 = this.createMediaEntryName(this.getMediaArchiveName(), string);
        String string3 = this.createArchiveFileName(string2, n);
        if (string2.endsWith(File.separator)) {
            this.createDirs(string3);
            this.out = new ByteArrayOutputStream();
        } else {
            ArchiveEntryLocation archiveEntryLocation = this.findArchiveEntry(string2, true);
            if (archiveEntryLocation != null) {
                this.out = new AbstractArchiveWriterOutputStream.NoopOutputStream();
                bl2 = false;
            } else {
                this.createDirsForArchive(string3);
                OutputStream outputStream = new FileOutputStream(string3);
                if (bl) {
                    this.resetDeflater();
                    outputStream = new DeflaterOutputStreamWrapper(new DeflaterOutputStream(outputStream, this.getDeflater()));
                }
                this.out = outputStream;
                if (string.equals(this.getArchiveIndexWriter().getIndexName())) {
                    bl2 = false;
                }
            }
            this.setCurrentArchiveEntryLocation(archiveEntryLocation);
        }
        this.createMediaInf(n);
        this.setCurrentMediaArchiveName(string3);
        this.setNewResource(bl2);
    }

    private void initSpanArchiveStream(String string, int n) throws IOException {
        if (this.out != null) {
            throw new IOException("Initialization Error:  Previous archive has not been closed.");
        }
        String string2 = this.createMediaEntryName(this.getMediaArchiveName(), string);
        String string3 = this.createArchiveFileName(string2, n);
        this.createDirsForArchive(string3);
        this.out = new FileOutputStream(string3);
        this.createMediaInf(n);
        this.setCurrentMediaArchiveName(string3);
        this.setNewResource(true);
    }

    private void initialize() {
        this.mediaBytes = new MediaBytesTable(this.mediaSize, this.blockSize);
        this.currentMediaDisk = 1;
        this.currentSpanningMediaDisk = 1;
        this.indexSizeAdded = false;
        this.currentLocation = null;
    }

    private boolean isNewResource() {
        return this.newResource;
    }

    private String normalizeEntryName(String string) {
        String string2 = string;
        string2 = string.replace(File.separatorChar, '/');
        char[] cArray = new char[string2.length()];
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        while (n2 < cArray.length) {
            char c = string2.charAt(n2);
            if (bl |= c != '/') {
                cArray[n++] = c;
                while (n2 < cArray.length - 1 && c == '/' && string2.charAt(n2 + 1) == '/') {
                    ++n2;
                }
            }
            ++n2;
        }
        string2 = new String(cArray, 0, n);
        return string2;
    }

    protected void prepareForArchiveIndex() throws IOException {
        this.zipFileOut = new FileOutputStream(this.getApplicationArchiveName());
        this.zipOut = new ZipOutputStream(this.zipFileOut);
        ZipFile zipFile = new ZipFile(this.getTempApplicationArchiveName());
        InputStream inputStream = null;
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            block7: {
                ZipEntry zipEntry = enumeration.nextElement();
                inputStream = zipFile.getInputStream(zipEntry);
                try {
                    this.zipOut.putNextEntry(zipEntry);
                    FileUtils.copy(inputStream, this.zipOut);
                }
                catch (ZipException zipException) {
                    if (!zipException.getMessage().startsWith("duplicate entry")) {
                        throw zipException;
                    }
                }
                catch (EOFException eOFException) {
                    if (inputStream == null || inputStream.available() <= 0) break block7;
                    throw eOFException;
                }
            }
            inputStream.close();
            this.zipOut.closeEntry();
        }
        try {
            zipFile.close();
            new File(this.getTempApplicationArchiveName()).delete();
        }
        catch (Exception exception) {}
    }

    private void putNextApplicationArchiveEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        if (this.getCurrentZipEntry() != null) {
            throw new IOException("Entry Error:  Previous application archive entry has not been closed.");
        }
        ZipOutputStream zipOutputStream = this.getApplicationArchiveStream();
        String string = this.normalizeEntryName(archiveWriterEntry.getId());
        ZipEntry zipEntry = null;
        if (!string.endsWith("/")) {
            zipEntry = new ZipEntry(string);
            zipOutputStream.putNextEntry(zipEntry);
        }
        this.setCurrentZipEntry(zipEntry);
    }

    protected void putNextExternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        this.addIndexSize();
        super.putNextExternalEntry(archiveWriterEntry);
    }

    void putNextInternalEntry(ArchiveWriterEntry archiveWriterEntry) throws IOException {
        this.addIndexSize();
        int n = archiveWriterEntry.getEntryType();
        if (n == 1) {
            this.putNextApplicationArchiveEntry(archiveWriterEntry);
        } else if (n == 2) {
            this.putNextMediaArchiveEntry(archiveWriterEntry, false);
        } else if (n == 3) {
            this.putNextMediaArchiveEntry(archiveWriterEntry, true);
        } else {
            throw new IOException("Unknown archive entry type: " + archiveWriterEntry.getId());
        }
    }

    private void putNextMediaArchiveEntry(ArchiveWriterEntry archiveWriterEntry, boolean bl) throws IOException {
        this.currentMediaDisk = this.currentSpanningMediaDisk;
        this.initMediaArchiveStream(archiveWriterEntry.getId(), this.currentMediaDisk, bl);
    }

    public void reserveMediaDiskSize(int n, long l) {
        this.mediaBytes.addFileSize(n, l);
    }

    private void setCurrentArchiveEntryLocation(ArchiveEntryLocation archiveEntryLocation) {
        this.currentLocation = archiveEntryLocation;
    }

    private void setCurrentMediaArchiveName(String string) {
        this.currentMediaArchiveName = string;
    }

    private void setCurrentZipEntry(ZipEntry zipEntry) {
        this.currentZipEntry = zipEntry;
    }

    private void setNewResource(boolean bl) {
        this.newResource = bl;
    }

    private void setTempApplicationArchiveName(String string) {
        this.tempApplicationArchiveName = string;
    }

    private int splitArchiveEntry(ArchiveWriterEntry archiveWriterEntry, String string, int n, MediaBytesTable mediaBytesTable) throws IOException {
        String string2 = FileUtils.createTempFile(new URL("ismpfile", "", -1, URLUtils.encode(string)));
        if (!new File(string).delete()) {
            throw new IOException("File split error: Could not delete original file before split: " + string);
        }
        String string3 = archiveWriterEntry.getId();
        int n2 = n;
        int n3 = n;
        long l = new File(string2).length();
        FileInputStream fileInputStream = new FileInputStream(string2);
        int n4 = 0;
        int n5 = 0;
        while (n5 != -1 && (long)n4 < l) {
            this.initSpanArchiveStream(string3, n2);
            long l2 = mediaBytesTable.spaceAvailable(n2);
            n5 = FileUtils.copy(512, fileInputStream, this.getMediaArchiveStream(), (int)l2);
            n4 += n5;
            this.closeMediaArchiveStream();
            File file = new File(this.getCurrentMediaArchiveName());
            mediaBytesTable.addFile(n2, file);
            n3 = n2++;
        }
        try {
            fileInputStream.close();
            FileUtils.deleteTempFile(string2);
        }
        catch (Exception exception) {}
        return n3;
    }

    protected void writeToInternalArchive(ArchiveWriterEntry archiveWriterEntry, byte[] byArray, int n, int n2) throws IOException {
        int n3 = archiveWriterEntry.getEntryType();
        OutputStream outputStream = n3 == 1 ? this.getApplicationArchiveStream() : this.getMediaArchiveStream();
        outputStream.write(byArray, n, n2);
    }

    private class MediaBytesTable {
        private Hashtable mediaDiskBytes = new Hashtable();
        private long mediaSize;
        private long blockSize;
        private int firstMediaDisk;
        private int lastMediaDisk;

        public MediaBytesTable(long l, long l2) {
            this.mediaSize = l;
            this.blockSize = l2;
            this.firstMediaDisk = 1;
            this.lastMediaDisk = 1;
        }

        public void addFile(int n, File file) {
            Integer n2 = new Integer(n);
            long l = this.determineByteSize(file.length());
            this.mediaDiskBytes.put(n2, new Long(l + this.getBytes(n)));
            if (n > this.lastMediaDisk) {
                this.lastMediaDisk = n;
            }
        }

        public void addFileSize(int n, long l) {
            Integer n2 = new Integer(n);
            long l2 = this.determineByteSize(l);
            this.mediaDiskBytes.put(n2, new Long(l2 + this.getBytes(n)));
            if (n > this.lastMediaDisk) {
                this.lastMediaDisk = n;
            }
        }

        private long determineByteSize(long l) {
            int n = (int)(l / this.blockSize);
            int n2 = (int)(l % this.blockSize);
            if (n2 > 0) {
                ++n;
            }
            return (long)n * this.blockSize;
        }

        public long getBytes(int n) {
            Long l = (Long)this.mediaDiskBytes.get(new Integer(n));
            return l != null ? l : 0L;
        }

        public int getFirstMediaDisk() {
            return this.firstMediaDisk;
        }

        public int getLastMediaDisk() {
            return this.lastMediaDisk;
        }

        public boolean isFull(int n) {
            return this.getBytes(n) >= this.mediaSize;
        }

        public boolean isOverFilled(int n) {
            return this.getBytes(n) > this.mediaSize;
        }

        public long spaceAvailable(int n) {
            long l = this.mediaSize - this.getBytes(n);
            return l >= 0L ? l : 0L;
        }

        public long spaceRequiredForFile(int n, File file) {
            long l = this.determineByteSize(file.length());
            long l2 = l + this.getBytes(n) - this.mediaSize;
            return l2 >= 0L ? l2 : 0L;
        }
    }

    private class ArchiveEntryLocation {
        private int startMediaDisk;
        private int endMediaDisk;

        public ArchiveEntryLocation(int n, int n2) {
            this.startMediaDisk = n;
            this.endMediaDisk = n2;
        }

        public int getEndMediaDisk() {
            return this.endMediaDisk;
        }

        public int getStartMediaDisk() {
            return this.startMediaDisk;
        }
    }
}

