/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive.index;

import com.installshield.archive.index.ArchiveIndexReader;
import com.installshield.archive.index.ArchiveIndexWriter;
import com.installshield.util.FileUtils;
import com.installshield.util.TempFileOwner;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;

public class ArchiveIndex {
    public static final String INDEX_NAME = "index";
    private static Hashtable writers = new Hashtable();
    private static Hashtable readers = new Hashtable();

    public static synchronized ArchiveIndexReader getReader(URL uRL) throws IOException {
        ArchiveIndexReader archiveIndexReader = (ArchiveIndexReader)readers.get(uRL.toExternalForm());
        if (archiveIndexReader == null) {
            FileInputStream fileInputStream = new FileInputStream(FileUtils.createTempFile(uRL));
            FileUtils.addTempFileOwner(new TempFileOwner(fileInputStream));
            archiveIndexReader = new ArchiveIndexReader(fileInputStream);
            readers.put(uRL.toExternalForm(), archiveIndexReader);
        }
        return archiveIndexReader;
    }

    public static synchronized ArchiveIndexWriter getWriter(String string) throws IOException {
        ArchiveIndexWriter archiveIndexWriter = (ArchiveIndexWriter)writers.get(string);
        if (archiveIndexWriter == null) {
            String string2 = FileUtils.createTempFile();
            archiveIndexWriter = new ArchiveIndexWriter(string2, string);
            writers.put(string, archiveIndexWriter);
        }
        return archiveIndexWriter;
    }

    public static synchronized void reset() {
        writers.clear();
        readers.clear();
    }
}

