/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.ClassConstants;
import com.installshield.util.attribute_info;
import com.installshield.util.cp_info;
import com.installshield.util.field_info;
import com.installshield.util.method_info;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;

public class ClassFile
extends ClassConstants {
    private int magic = 0;
    private short minor_version = 0;
    private short major_version = 0;
    private Vector constant_pool = new Vector();
    private short access_flags;
    public short this_class;
    private short super_class;
    private Vector interfaces = new Vector();
    private Vector fields = new Vector();
    private Vector methods = new Vector();
    private Vector attributes = new Vector();

    public ClassFile(DataInput dataInput) {
        this.readClass(dataInput);
    }

    public ClassFile(DataInput dataInput, int n) {
        this.readClass(dataInput, n);
    }

    public void addAttribute(String string, byte[] byArray) {
        short s = 0;
        cp_info cp_info2 = new cp_info();
        cp_info2.setTag((byte)1);
        cp_info2.setInfo(string);
        if (!this.constant_pool.contains(cp_info2)) {
            this.constant_pool.addElement(cp_info2);
        }
        s = (short)this.constant_pool.indexOf(cp_info2);
        attribute_info attribute_info2 = new attribute_info(s, byArray);
        this.attributes.addElement(attribute_info2);
    }

    public Vector getConstantPool() {
        return this.constant_pool;
    }

    public Vector getFields() {
        return this.fields;
    }

    public Vector getMethods() {
        return this.methods;
    }

    public void readClass(DataInput dataInput) {
        this.readClass(dataInput, -1);
    }

    public void readClass(DataInput dataInput, int n) {
        try {
            int n2;
            this.magic = dataInput.readInt();
            this.minor_version = dataInput.readShort();
            this.major_version = dataInput.readShort();
            this.constant_pool.addElement(null);
            int n3 = dataInput.readShort();
            int n4 = 1;
            while (n4 < n3) {
                cp_info cp_info2 = new cp_info(dataInput);
                this.constant_pool.addElement(cp_info2);
                n2 = cp_info2.getConstantPoolEntrySize();
                n4 += n2;
                while (n2 > 1) {
                    this.constant_pool.addElement(null);
                    --n2;
                }
            }
            this.access_flags = dataInput.readShort();
            this.this_class = dataInput.readShort();
            this.super_class = dataInput.readShort();
            short s = dataInput.readShort();
            n2 = 0;
            while (n2 < s) {
                this.interfaces.addElement(new Short(dataInput.readShort()));
                ++n2;
            }
            int n5 = dataInput.readShort();
            int n6 = 0;
            while (n6 < n5) {
                field_info field_info2 = new field_info(dataInput);
                this.fields.addElement(field_info2);
                ++n6;
            }
            int n7 = dataInput.readShort();
            int n8 = 0;
            while (n8 < n7) {
                method_info method_info2 = new method_info(dataInput);
                this.methods.addElement(method_info2);
                ++n8;
            }
            int n9 = dataInput.readShort();
            int n10 = 0;
            while (n10 < n9) {
                short s2 = dataInput.readShort();
                int n11 = dataInput.readInt();
                if (n == -1 || n11 <= n) {
                    byte[] byArray = new byte[n11];
                    dataInput.readFully(byArray);
                    this.attributes.addElement(new attribute_info(s2, byArray));
                }
                ++n10;
            }
        }
        catch (IOException iOException) {
            System.out.println("Could not read class.");
        }
    }

    public void removeAttribute(String string) {
        short s = -1;
        int n = this.constant_pool.size() - 1;
        while (n >= 0) {
            cp_info cp_info2 = (cp_info)this.constant_pool.elementAt(n);
            if (cp_info2 != null && cp_info2.getTag() == 1 && cp_info2.getInfo().equals(string)) {
                s = (short)n;
                break;
            }
            --n;
        }
        if (s != -1) {
            int n2 = 0;
            while (n2 < this.attributes.size()) {
                if (((attribute_info)this.attributes.elementAt(n2)).getNameIndex() == s) {
                    this.attributes.removeElementAt(n2);
                    break;
                }
                ++n2;
            }
        }
    }

    public void setClassname(String string) {
        cp_info cp_info2 = (cp_info)this.constant_pool.elementAt(this.this_class);
        short s = (Short)cp_info2.getInfo();
        cp_info cp_info3 = (cp_info)this.constant_pool.elementAt(s);
        cp_info3.setInfo(string);
    }

    public void writeClass(DataOutput dataOutput) {
        try {
            int n;
            dataOutput.writeInt(this.magic);
            dataOutput.writeShort(this.minor_version);
            dataOutput.writeShort(this.major_version);
            int n2 = this.constant_pool.size();
            dataOutput.writeShort(n2);
            int n3 = 1;
            while (n3 < n2) {
                cp_info cp_info2 = (cp_info)this.constant_pool.elementAt(n3);
                cp_info2.write(dataOutput);
                n3 += cp_info2.getConstantPoolEntrySize();
            }
            dataOutput.writeShort(this.access_flags);
            dataOutput.writeShort(this.this_class);
            dataOutput.writeShort(this.super_class);
            int n4 = this.interfaces.size();
            dataOutput.writeShort(n4);
            int n5 = 0;
            while (n5 < n4) {
                n = ((Short)this.interfaces.elementAt(n5)).shortValue();
                dataOutput.writeShort(n);
                ++n5;
            }
            n = this.fields.size();
            dataOutput.writeShort(n);
            int n6 = 0;
            while (n6 < n) {
                field_info field_info2 = (field_info)this.fields.elementAt(n6);
                field_info2.write(dataOutput);
                ++n6;
            }
            int n7 = this.methods.size();
            dataOutput.writeShort(n7);
            int n8 = 0;
            while (n8 < n7) {
                method_info method_info2 = (method_info)this.methods.elementAt(n8);
                method_info2.write(dataOutput);
                ++n8;
            }
            int n9 = this.attributes.size();
            dataOutput.writeShort(n9);
            int n10 = 0;
            while (n10 < n9) {
                attribute_info attribute_info2 = (attribute_info)this.attributes.elementAt(n10);
                attribute_info2.write(dataOutput);
                ++n10;
            }
        }
        catch (IOException iOException) {
            System.out.println("Could not write class file.");
        }
    }
}

