/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard;

import com.installshield.archive.AbstractArchiveWriterOutputStream;
import com.installshield.archive.ArchiveBuilderSupport;
import com.installshield.archive.ArchiveTypeInfo;
import com.installshield.archive.ArchiveWriter;
import com.installshield.archive.ArchiveWriterDirOutputStream;
import com.installshield.archive.ArchiveWriterSpanOutputStream;
import com.installshield.archive.ArchiveWriterZipOutputStream;
import com.installshield.archive.BuildEvent;
import com.installshield.archive.BuildListener;
import com.installshield.archive.index.ArchiveIndex;
import com.installshield.qjml.QJML;
import com.installshield.util.FileUtils;
import com.installshield.util.LogListener;
import com.installshield.util.UID;
import com.installshield.util.URLUtils;
import com.installshield.wizard.UninstallerWizardBuilderSupport;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardException;
import com.installshield.wizard.WizardTree;
import com.installshield.wizard.WizardWriterSupplement;
import com.installshield.wizard.service.DefaultServiceBuilderResolver;
import com.installshield.wizard.service.ServiceBuilderResolver;
import com.installshield.wizard.service.ServicesBuilder;
import com.installshield.wizard.service.ServicesDefinition;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.WizardServicesFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.Vector;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class WizardWriter
implements LogListener,
BuildListener {
    public static final String BUILD_STARTED = "msg1.build.started";
    public static final String BUILD_FINISHED = "msg1.build.finished";
    public static final String BUILD_CANCELED = "err.build.canceled";
    public static final String SECTION_STARTED = "msg1.build.section";
    public static final String ARCHIVE_WRITTEN = "msg1.archive.written";
    public static final int ZIP = 1;
    public static final int DIR = 2;
    public static final int CDROM = 4;
    public static final int CUSTOM = 3;
    private String classPath = System.getProperty("java.class.path");
    private ArchiveTypeInfo archiveTypeInfo = new ArchiveTypeInfo(1);
    private String archiveOutputDir = null;
    private String archiveMediaRootName = null;
    private String archiveName = null;
    private WizardTree wizardTree = null;
    private String wizardTreeSource = null;
    private Wizard wizard = null;
    private String wizardSource = null;
    private Hashtable resources = new Hashtable();
    private Hashtable definitions = new Hashtable();
    private Hashtable resourceBundles = new Hashtable();
    private WizardServices buildtimeServices = null;
    private ServicesDefinition servicesDef = null;
    private String servicesSource = null;
    private String builderHome = null;
    private String builderHomeRes = null;
    private Locale[] selectedLocales = null;
    private Vector supplements = new Vector();
    private Vector logListeners = new Vector();
    private Vector buildListeners = new Vector();
    private boolean stopBuild = false;
    private boolean canceled = false;
    private WizardBuilderSupport currentSupport = null;
    private ArchiveWriter currentWriter = null;
    private String externalResourceLocation = "";
    static /* synthetic */ Class class$com$sun$xml$parser$Parser;
    static /* synthetic */ Class class$com$installshield$wizard$Wizard;
    static /* synthetic */ Class class$com$installshield$wizard$WizardTree;
    static /* synthetic */ Class class$com$installshield$wizard$service$ServicesDefinition;

    public void addBuildListener(BuildListener buildListener) {
        this.buildListeners.addElement(buildListener);
    }

    public void addLogListener(LogListener logListener) {
        this.logListeners.addElement(logListener);
    }

    public void addSupplement(WizardWriterSupplement wizardWriterSupplement) {
        this.supplements.addElement(wizardWriterSupplement);
    }

    public void buildFinished(BuildEvent buildEvent) {
        int n = 0;
        while (n < this.buildListeners.size()) {
            ((BuildListener)this.buildListeners.elementAt(n)).buildFinished(buildEvent);
            ++n;
        }
    }

    public void buildStarted(BuildEvent buildEvent) {
        int n = 0;
        while (n < this.buildListeners.size()) {
            ((BuildListener)this.buildListeners.elementAt(n)).buildStarted(buildEvent);
            ++n;
        }
    }

    public void cancel() {
        this.canceled = true;
        if (this.currentSupport != null) {
            this.currentSupport.setBuildCanceled(true);
        }
        if (this.currentWriter != null) {
            this.currentWriter.cancel();
        }
    }

    private void checkCanceled() throws WizardException {
        if (this.canceled) {
            throw new WizardException(301);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void closeZipStream(ZipOutputStream zipOutputStream) throws IOException {
        block2: {
            try {
                zipOutputStream.finish();
                zipOutputStream.close();
            }
            catch (ZipException zipException) {
                if (zipException.getMessage().startsWith("ZIP file must have at least one entry")) break block2;
                throw zipException;
            }
        }
    }

    private String createArchiveName() {
        String string = FileUtils.createFileName(this.getArchiveOutputDir(), String.valueOf(this.getArchiveMediaRootName()) + "1");
        string = FileUtils.createFileName(string, this.getArchiveName());
        return string;
    }

    protected String createArchiveName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        int n = 0;
        while (n < string.length()) {
            if (Character.isLetterOrDigit(string.charAt(n))) {
                stringBuffer.append(string.charAt(n));
                bl = false;
            } else if (!bl) {
                stringBuffer.append('_');
                bl = true;
            }
            ++n;
        }
        return String.valueOf(stringBuffer.toString()) + ".jar";
    }

    private InputStream createManifest() throws IOException {
        return Wizard.createManifest().getInputStream();
    }

    private InputStream createRunInf() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.println("START_CLASS: com.installshield.wizard.Wizard");
        printWriter.println();
        printWriter.flush();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    private static URL createURL(String string) throws MalformedURLException {
        File file = new File(string);
        if (file.isAbsolute()) {
            String string2 = file.isDirectory() ? FileUtils.appendSeparator(file.getAbsolutePath()) : string;
            return new URL("ismpfile", "", -1, URLUtils.encode(string2));
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            String string3 = new File("").getAbsolutePath();
            string3 = FileUtils.appendSeparator(string3);
            URL uRL = new URL("ismpfile", "", -1, URLUtils.encode(string3));
            return new URL(uRL, URLUtils.encode(string));
        }
    }

    protected WizardBuilderSupport createWizardBuilderSupport(ArchiveWriter archiveWriter, Locale[] localeArray, Wizard wizard, ServicesDefinition servicesDefinition) {
        return new UninstallerWizardBuilderSupport(archiveWriter, localeArray, wizard, servicesDefinition);
    }

    private InputStream createWizardInf() throws IOException {
        return this.wizard.getWizardInf().getInputStream();
    }

    private WizardServices createWizardServices(ServicesDefinition servicesDefinition) throws MalformedURLException {
        return WizardServicesFactory.createLocalWizardServices("", "", servicesDefinition, null, null);
    }

    public void eventLogged(Object object, String string, Object object2) {
        if (string.equals("err")) {
            this.stopBuild = true;
        }
        if (this.logListeners.size() == 0) {
            System.out.println(String.valueOf(this.getEventDesc(string)) + ": " + object2 + " (" + object.getClass().getName() + ")");
            if (object2 instanceof Throwable) {
                ((Throwable)object2).printStackTrace();
            }
        } else {
            int n = 0;
            while (n < this.logListeners.size()) {
                ((LogListener)this.logListeners.elementAt(n)).eventLogged(object, string, object2);
                ++n;
            }
        }
    }

    public String getArchiveMediaRootName() {
        return this.archiveMediaRootName;
    }

    public String getArchiveName() {
        return this.archiveName;
    }

    public String getArchiveOutputDir() {
        return this.archiveOutputDir;
    }

    public ArchiveTypeInfo getArchiveTypeInfo() {
        return this.archiveTypeInfo;
    }

    public WizardServices getBuildtimeServices() {
        return this.buildtimeServices;
    }

    public String getClassPath() {
        return this.classPath;
    }

    protected String getEventDesc(String string) {
        if (string.equals("err")) {
            return "ERROR";
        }
        if (string.equals("wrn")) {
            return "WARNING";
        }
        if (string.equals("msg1") || string.equals("msg2")) {
            return "MESSAGE";
        }
        return string;
    }

    public String getExternalResourceLocation() {
        return this.externalResourceLocation;
    }

    public Locale[] getSelectedLocales() {
        return this.selectedLocales;
    }

    public ServicesDefinition getServicesDefinition() {
        return this.servicesDef;
    }

    public String getServicesSource() {
        return this.servicesSource;
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public String getWizardSource() {
        return this.wizardSource;
    }

    public WizardTree getWizardTree() {
        return this.wizardTree;
    }

    public String getWizardTreeSource() {
        return this.wizardTreeSource;
    }

    public void load(Properties properties) {
        block32: {
            String string;
            if (properties.getProperty("wizard") != null) {
                this.setWizardSource(properties.getProperty("wizard"));
            }
            if (properties.getProperty("java.class.path") != null) {
                this.setClassPath(properties.getProperty("java.class.path"));
            }
            if (properties.getProperty("archive.type") != null) {
                ArchiveTypeInfo archiveTypeInfo = new ArchiveTypeInfo();
                String string2 = properties.getProperty("archive.type");
                if (string2.equals("zip")) {
                    archiveTypeInfo = new ArchiveTypeInfo(1);
                } else if (string2.equals("dir")) {
                    archiveTypeInfo = new ArchiveTypeInfo(2);
                } else if (string2.equals("cdrom")) {
                    archiveTypeInfo = new ArchiveTypeInfo(4);
                } else if (string2.equals("custom")) {
                    if (properties.getProperty("archive.media.size") != null && properties.getProperty("archive.block.size") != null) {
                        try {
                            long l = Long.parseLong(properties.getProperty("archive.media.size").trim());
                            long l2 = Long.parseLong(properties.getProperty("archive.block.size").trim());
                            archiveTypeInfo = new ArchiveTypeInfo(3);
                            archiveTypeInfo.setMediaSize(l);
                            archiveTypeInfo.setBlockSize(l2);
                        }
                        catch (Exception exception) {
                            System.err.println("WARNING: invalid entry for archive sizes");
                        }
                    } else {
                        System.err.println("WARNING: missing info for custom archive type");
                    }
                } else {
                    System.err.println("WARNING: invalid entry for archive type");
                }
                this.setArchiveTypeInfo(archiveTypeInfo);
            } else {
                System.err.println("WARNING: missing entry for archive type");
            }
            if (properties.getProperty("archive.name") != null) {
                this.setArchiveName(properties.getProperty("archive.name"));
            }
            if (properties.getProperty("archive.output.dir") != null) {
                this.setArchiveOutputDir(properties.getProperty("archive.output.dir"));
            }
            if (properties.getProperty("archive.media.root.name") != null) {
                this.setArchiveMediaRootName(properties.getProperty("archive.media.root.name"));
            }
            if (properties.getProperty("wizard.tree") != null) {
                this.setWizardTreeSource(properties.getProperty("wizard.tree"));
            }
            if (properties.getProperty("services") != null) {
                this.setServicesSource(properties.getProperty("services"));
            }
            if (properties.getProperty("resource.count") != null) {
                try {
                    int n = Integer.parseInt(properties.getProperty("resource.count"));
                    int n2 = 1;
                    while (n2 <= n) {
                        String string3 = properties.getProperty("resource." + n2 + ".source");
                        string = properties.getProperty("resource." + n2 + ".name");
                        if (string3 == null || string == null) {
                            System.err.println("WARNING: missing complete resource entry for item " + n2);
                        } else {
                            this.putResource(string, string3);
                        }
                        ++n2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("WARNING: invalid value for image.count property");
                }
            }
            if (properties.getProperty("definition.count") == null) break block32;
            try {
                int n = Integer.parseInt(properties.getProperty("definition.count"));
                int n3 = 1;
                while (n3 <= n) {
                    String string4 = properties.getProperty("definition." + n3 + ".source");
                    string = properties.getProperty("definition." + n3 + ".name");
                    if (string4 == null || string == null) {
                        System.err.println("WARNING: missing complete definition entry for item " + n3);
                    } else {
                        this.putDefinition(string, string4);
                    }
                    ++n3;
                }
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("WARNING: invalid value for image.count property");
            }
        }
    }

    public static void main(String[] stringArray) {
        block5: {
            if (stringArray.length != 1) {
                System.err.println("use: WizardBuild <properties file>");
                System.exit(-1);
            }
            QJML.setParserClass((class$com$sun$xml$parser$Parser != null ? class$com$sun$xml$parser$Parser : (class$com$sun$xml$parser$Parser = WizardWriter.class$("com.sun.xml.parser.Parser"))).getName());
            WizardWriter wizardWriter = new WizardWriter();
            try {
                Properties properties = new Properties();
                properties.load(new FileInputStream(stringArray[0]));
                wizardWriter.load(properties);
            }
            catch (IOException iOException) {
                System.err.println("The following error occurred: " + iOException);
            }
            try {
                wizardWriter.write();
            }
            catch (Exception exception) {
                System.err.println("The following error occurred: " + exception);
                if (System.getProperty("is.debug") == null) break block5;
                exception.printStackTrace();
            }
        }
        FileUtils.deleteTempFiles();
    }

    public void putDefinition(String string, String string2) {
        if (string != null) {
            this.definitions.put(string, string2);
        } else {
            this.definitions.remove(string);
        }
    }

    public void putResource(String string, String string2) {
        if (string != null) {
            this.resources.put(string, string2);
        } else {
            this.resources.remove(string);
        }
    }

    public void putResourceBundles(String string) {
        this.resourceBundles.put(string, new Object());
    }

    public void putResourceBundles(String string, Locale[] localeArray) {
        if (localeArray != null) {
            this.resourceBundles.put(string, localeArray);
        } else {
            this.resourceBundles.remove(string);
        }
    }

    public void removeBuildListener(BuildListener buildListener) {
        this.buildListeners.removeElement(buildListener);
    }

    public void removeLogListener(LogListener logListener) {
        this.logListeners.removeElement(logListener);
    }

    public void removeSupplement(WizardWriterSupplement wizardWriterSupplement) {
        this.supplements.removeElement(wizardWriterSupplement);
    }

    public void setArchiveMediaRootName(String string) {
        this.archiveMediaRootName = string;
    }

    public void setArchiveName(String string) {
        this.archiveName = string;
    }

    public void setArchiveOutputDir(String string) {
        this.archiveOutputDir = string;
    }

    public void setArchiveTypeInfo(ArchiveTypeInfo archiveTypeInfo) {
        this.archiveTypeInfo = archiveTypeInfo;
    }

    public void setBuildtimeServices(WizardServices wizardServices) {
        this.buildtimeServices = wizardServices;
    }

    public void setClassPath(String string) {
        this.classPath = string;
    }

    public void setExternalResourceLocation(String string) {
        this.externalResourceLocation = string;
    }

    public void setSelectedLocales(Locale[] localeArray) {
        this.selectedLocales = localeArray;
    }

    public void setServicesDefinition(ServicesDefinition servicesDefinition) {
        this.servicesDef = servicesDefinition;
    }

    public void setServicesSource(String string) {
        this.servicesSource = string;
    }

    public void setWizard(Wizard wizard) {
        this.wizard = wizard;
    }

    public void setWizardSource(String string) {
        this.wizardSource = string;
    }

    public void setWizardTree(WizardTree wizardTree) {
        this.wizardTree = wizardTree;
    }

    public void setWizardTreeSource(String string) {
        this.wizardTreeSource = string;
    }

    public void write() throws WizardException, IOException {
        BuildEvent buildEvent;
        ArchiveBuilderSupport archiveBuilderSupport;
        boolean bl;
        DateFormat dateFormat;
        long l;
        block43: {
            if (this.archiveName == null) {
                throw new WizardException(300, "archive.name must be specified");
            }
            if (this.archiveOutputDir == null) {
                throw new WizardException(300, "archive.output.dir must be specified");
            }
            if (this.archiveMediaRootName == null) {
                throw new WizardException(300, "archive.media.root.name must be specified");
            }
            l = System.currentTimeMillis();
            dateFormat = DateFormat.getDateTimeInstance();
            dateFormat.setTimeZone(TimeZone.getDefault());
            this.eventLogged(this, BUILD_STARTED, "Started build at " + dateFormat.format(Calendar.getInstance().getTime()));
            this.eventLogged(this, BUILD_STARTED, "Building archive " + this.createArchiveName());
            bl = false;
            archiveBuilderSupport = null;
            buildEvent = null;
            try {
                AbstractArchiveWriterOutputStream abstractArchiveWriterOutputStream;
                block42: {
                    Object object;
                    this.checkCanceled();
                    if (this.wizard == null) {
                        if (this.wizardSource == null) {
                            throw new WizardException(300, "wizard must be specified");
                        }
                        this.wizard = (Wizard)QJML.read(WizardWriter.createURL(this.wizardSource), class$com$installshield$wizard$Wizard != null ? class$com$installshield$wizard$Wizard : (class$com$installshield$wizard$Wizard = WizardWriter.class$("com.installshield.wizard.Wizard")));
                    }
                    this.wizard.getWizardInf().setResId(UID.createUIDAsString());
                    this.wizard.getWizardInf().setExternalResourceLocation(this.externalResourceLocation);
                    this.checkCanceled();
                    if (this.wizardTree == null) {
                        if (this.wizardTreeSource == null) {
                            throw new WizardException(300, "wizard.tree must be specified");
                        }
                        this.wizardTree = (WizardTree)QJML.read(WizardWriter.createURL(this.wizardTreeSource), class$com$installshield$wizard$WizardTree != null ? class$com$installshield$wizard$WizardTree : (class$com$installshield$wizard$WizardTree = WizardWriter.class$("com.installshield.wizard.WizardTree")));
                    }
                    this.wizard.setWizardTree(this.wizardTree);
                    this.checkCanceled();
                    if (this.servicesDef == null && this.servicesSource != null) {
                        this.servicesDef = (ServicesDefinition)QJML.read(WizardWriter.createURL(this.servicesSource), class$com$installshield$wizard$service$ServicesDefinition != null ? class$com$installshield$wizard$service$ServicesDefinition : (class$com$installshield$wizard$service$ServicesDefinition = WizardWriter.class$("com.installshield.wizard.service.ServicesDefinition")));
                    }
                    this.checkCanceled();
                    if (this.buildtimeServices == null) {
                        this.buildtimeServices = this.createWizardServices(this.servicesDef);
                    }
                    ArchiveIndex.reset();
                    this.checkCanceled();
                    File file = new File(FileUtils.getParent(this.createArchiveName()));
                    if (!file.exists()) {
                        file.mkdirs();
                    }
                    this.checkCanceled();
                    abstractArchiveWriterOutputStream = null;
                    int n = this.archiveTypeInfo.getArchiveType();
                    if (n == 1) {
                        abstractArchiveWriterOutputStream = new ArchiveWriterZipOutputStream(this.archiveOutputDir, this.archiveMediaRootName, this.archiveName, this.externalResourceLocation, ArchiveIndex.getWriter(String.valueOf(this.wizard.getWizardInf().getResId()) + "/" + "index"));
                        this.currentWriter = ArchiveWriter.createArchiveWriter(this.classPath, abstractArchiveWriterOutputStream, this.wizard.getWizardInf().getResId());
                        this.currentWriter.putClassResource(this.createManifest(), "META-INF/MANIFEST.MF");
                    } else if (n == 2) {
                        abstractArchiveWriterOutputStream = new ArchiveWriterDirOutputStream(this.archiveOutputDir, this.archiveMediaRootName, this.archiveName, this.externalResourceLocation, ArchiveIndex.getWriter(String.valueOf(this.wizard.getWizardInf().getResId()) + "/" + "index"));
                        this.currentWriter = ArchiveWriter.createArchiveWriter(this.classPath, abstractArchiveWriterOutputStream, this.wizard.getWizardInf().getResId());
                    } else if (n == 3 || n == 4) {
                        int n2 = this.archiveName.indexOf(".");
                        object = this.archiveName.substring(0, n2);
                        abstractArchiveWriterOutputStream = new ArchiveWriterSpanOutputStream(this.archiveOutputDir, this.archiveMediaRootName, this.archiveName, this.externalResourceLocation, (String)object, ArchiveIndex.getWriter(String.valueOf(this.wizard.getWizardInf().getResId()) + "/" + "index"), this.archiveTypeInfo.getMediaSize(), this.archiveTypeInfo.getBlockSize());
                        this.currentWriter = ArchiveWriter.createArchiveWriter(this.classPath, abstractArchiveWriterOutputStream, this.wizard.getWizardInf().getResId());
                    }
                    if (this.currentWriter != null) {
                        this.currentWriter.addLogListener(this);
                    }
                    this.checkCanceled();
                    archiveBuilderSupport = this.createWizardBuilderSupport(this.currentWriter, this.selectedLocales, this.wizard, this.servicesDef);
                    if (archiveBuilderSupport instanceof UninstallerWizardBuilderSupport) {
                        ((UninstallerWizardBuilderSupport)archiveBuilderSupport).setMode(0);
                    }
                    this.currentSupport = archiveBuilderSupport;
                    buildEvent = new BuildEvent(this, archiveBuilderSupport);
                    archiveBuilderSupport.addLogListener(this);
                    archiveBuilderSupport.addBuildListener(this);
                    this.checkCanceled();
                    archiveBuilderSupport.buildStarted(buildEvent);
                    try {
                        Object object2;
                        String string;
                        Object object3;
                        this.checkCanceled();
                        Enumeration enumeration = this.definitions.keys();
                        while (enumeration.hasMoreElements()) {
                            object = (String)enumeration.nextElement();
                            object3 = (String)this.definitions.get(object);
                            this.currentWriter.putDefinition(WizardWriter.createURL((String)object3), (String)object);
                        }
                        this.checkCanceled();
                        object = this.resources.keys();
                        while (object.hasMoreElements()) {
                            object3 = (String)object.nextElement();
                            string = (String)this.resources.get(object3);
                            this.currentWriter.putResource(string, (String)object3);
                        }
                        this.checkCanceled();
                        object3 = this.resourceBundles.keys();
                        while (object3.hasMoreElements()) {
                            string = (String)object3.nextElement();
                            object2 = this.resourceBundles.get(string) instanceof Locale[] ? (Locale[])this.resourceBundles.get(string) : this.getSelectedLocales();
                            try {
                                this.currentWriter.putResourceBundles(string, (Locale[])object2);
                            }
                            catch (IOException iOException) {
                                this.eventLogged(this, "err", iOException);
                            }
                        }
                        this.checkCanceled();
                        this.eventLogged(this, SECTION_STARTED, "wizard");
                        this.stopBuild = false;
                        this.wizard.build((WizardBuilderSupport)archiveBuilderSupport);
                        int n3 = 0;
                        while (n3 < this.supplements.size()) {
                            this.checkCanceled();
                            object2 = (WizardWriterSupplement)this.supplements.elementAt(n3);
                            try {
                                object2.writeSupplement((WizardBuilderSupport)archiveBuilderSupport, this.buildtimeServices);
                            }
                            catch (Exception exception) {
                                this.stopBuild = true;
                                this.eventLogged(this, "err", exception);
                            }
                            ++n3;
                        }
                        this.checkCanceled();
                        object2 = new DefaultServiceBuilderResolver();
                        ServicesBuilder servicesBuilder = new ServicesBuilder(this.wizard.getWizardInf().getServices(), (ServiceBuilderResolver)object2, this.buildtimeServices);
                        servicesBuilder.setAvailableServices(((WizardBuilderSupport)archiveBuilderSupport).getAvailableServices());
                        servicesBuilder.setAvailableImplementors(((WizardBuilderSupport)archiveBuilderSupport).getAvailableServiceImplementors());
                        servicesBuilder.setRequiredServices(((WizardBuilderSupport)archiveBuilderSupport).getRequiredServices());
                        servicesBuilder.setStringResolverMethods(((WizardBuilderSupport)archiveBuilderSupport).getStringResolverMethods());
                        this.eventLogged(this, SECTION_STARTED, "services");
                        servicesBuilder.build(archiveBuilderSupport, this.getWizard().getWizardInf());
                        this.wizard.getWizardInf().setWizardDigest(QJML.createDigest(this.wizard, class$com$installshield$wizard$Wizard != null ? class$com$installshield$wizard$Wizard : (class$com$installshield$wizard$Wizard = WizardWriter.class$("com.installshield.wizard.Wizard")), (class$com$installshield$wizard$Wizard != null ? class$com$installshield$wizard$Wizard : (class$com$installshield$wizard$Wizard = WizardWriter.class$("com.installshield.wizard.Wizard"))).getName().getBytes()));
                        this.wizard.getWizardInf().setWizardTreeDigest(QJML.createDigest(this.wizard.getWizardTree(), class$com$installshield$wizard$WizardTree != null ? class$com$installshield$wizard$WizardTree : (class$com$installshield$wizard$WizardTree = WizardWriter.class$("com.installshield.wizard.WizardTree")), (class$com$installshield$wizard$WizardTree != null ? class$com$installshield$wizard$WizardTree : (class$com$installshield$wizard$WizardTree = WizardWriter.class$("com.installshield.wizard.WizardTree"))).getName().getBytes()));
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof WizardException && ((WizardException)throwable).getErrorCode() == 301) {
                            throw (WizardException)throwable;
                        }
                        throwable.printStackTrace();
                        this.eventLogged(this, "err", "An unhandled error occurred: " + throwable);
                        this.stopBuild = true;
                    }
                    if (this.stopBuild) {
                        this.eventLogged(this, "msg1", "Build stopped because of errors");
                    }
                    this.checkCanceled();
                    if (!this.stopBuild) {
                        try {
                            archiveBuilderSupport.writeStarting(buildEvent);
                            this.currentWriter.putClass("run");
                            this.currentWriter.putResourceBundles("com.installshield.wizard.i18n.WizardResources", this.getSelectedLocales());
                            this.currentWriter.putClassResource(this.createRunInf(), "run.inf");
                            this.currentWriter.putClassResource(this.createWizardInf(), "/wizard.inf");
                            this.checkCanceled();
                            this.currentWriter.write();
                            this.checkCanceled();
                            bl = true;
                        }
                        catch (Throwable throwable) {
                            if (throwable instanceof WizardException && ((WizardException)throwable).getErrorCode() == 301) break block42;
                            this.eventLogged(this, "err", throwable);
                        }
                    }
                }
                if (abstractArchiveWriterOutputStream == null) break block43;
                abstractArchiveWriterOutputStream.finish();
                abstractArchiveWriterOutputStream.close();
            }
            catch (Throwable throwable) {
                Object var8_26 = null;
                if (archiveBuilderSupport != null && buildEvent != null) {
                    if (bl) {
                        archiveBuilderSupport.writeFinished(buildEvent);
                    }
                    archiveBuilderSupport.buildFinished(buildEvent);
                }
                long l2 = System.currentTimeMillis();
                double d = ((double)l2 - (double)l) / 1000.0;
                if (!this.canceled) {
                    this.eventLogged(this, BUILD_FINISHED, "Finished build at " + dateFormat.format(Calendar.getInstance().getTime()) + " (" + d + " seconds)");
                } else {
                    this.eventLogged(this, BUILD_CANCELED, "Build canceled");
                }
                this.currentSupport = null;
                throw throwable;
            }
        }
        Object var8_25 = null;
        if (archiveBuilderSupport != null && buildEvent != null) {
            if (bl) {
                archiveBuilderSupport.writeFinished(buildEvent);
            }
            archiveBuilderSupport.buildFinished(buildEvent);
        }
        long l3 = System.currentTimeMillis();
        double d = ((double)l3 - (double)l) / 1000.0;
        if (!this.canceled) {
            this.eventLogged(this, BUILD_FINISHED, "Finished build at " + dateFormat.format(Calendar.getInstance().getTime()) + " (" + d + " seconds)");
        } else {
            this.eventLogged(this, BUILD_CANCELED, "Build canceled");
        }
        this.currentSupport = null;
    }

    public void writeFinished(BuildEvent buildEvent) {
        int n = 0;
        while (n < this.buildListeners.size()) {
            ((BuildListener)this.buildListeners.elementAt(n)).writeFinished(buildEvent);
            ++n;
        }
    }

    public void writeStarting(BuildEvent buildEvent) {
        int n = 0;
        while (n < this.buildListeners.size()) {
            ((BuildListener)this.buildListeners.elementAt(n)).writeStarting(buildEvent);
            ++n;
        }
    }
}

